/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.clientAPI.IceServerException;
import ice.communication.messageHandlers.serverExceptions.IceServerExceptionQueue;
import ice.communication.messageHandlers.serverExceptions.ServerExceptionListener;
import ice.event.communication.ErrorMessageEvent;
import ice.event.communication.ErrorMessageListener;
import ice.gui.panel.sans.events.SansPanelErrorEvent;
import ice.gui.panel.sans.events.SansPanelErrorListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorMessagePanel
extends JPanel
implements SansPanelErrorListener,
ServerExceptionListener,
ErrorMessageListener {
    private JTextArea errorLabel;
    private ArrayList<String> errors;

    public ErrorMessagePanel() {
        this.init();
        this.buildGUI();
    }

    private void init() {
        this.errorLabel = new JTextArea();
        this.errorLabel.setLineWrap(true);
        this.errorLabel.setEditable(false);
        this.errors = new ArrayList();
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 102, 102)));
        JScrollPane scrollPane = new JScrollPane(this.errorLabel);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.setForeground(new Color(153, 153, 255));
        this.setLayout(new BorderLayout());
        this.errorLabel.setForeground(new Color(255, 0, 0));
        scrollPane.setPreferredSize(new Dimension(500, 60));
        this.add((Component)scrollPane, "Center");
    }

    private void showErrors() {
        String errorMessage = "<html>";
        for (String message : this.errors) {
            errorMessage = String.valueOf(errorMessage) + message + "<br>";
        }
        errorMessage = String.valueOf(errorMessage) + "</html>";
    }

    public void setError(String text) {
        this.errorLabel.setText(text);
    }

    public void appendError(String text) {
        this.setError(text);
    }

    @Override
    public void errorOccured(SansPanelErrorEvent ipe) {
        Exception e = ipe.getException();
        this.setError(e.getMessage());
    }

    public void clearErrors() {
        this.setError("");
    }

    public void listenForDeviceErrors(String deviceName) {
        IceServerExceptionQueue.addListenerByDeviceName(this, deviceName);
    }

    public void stopListeningForDeviceErrors(String deviceName) {
        IceServerExceptionQueue.removeListenerByDeviceName(this, deviceName);
    }

    public void listenForCommandId(long commandId) {
        IceServerExceptionQueue.addListenerByCommandId(this, commandId);
    }

    public void stopListeningForCommandId(long commandId) {
        IceServerExceptionQueue.removeListenerByCommandId(this, commandId);
    }

    @Override
    public void receiveServerException(IceServerException e) {
        long commandId = e.getCommandId();
        String localizedMessage = e.getLocalizedMessage();
        if (commandId != 0L) {
            IceServerExceptionQueue.removeListenerByCommandId(this, commandId);
            this.errorLabel.setText(localizedMessage);
        }
    }

    public void clearErrors(String message) {
        String error = this.errorLabel.getText();
        if (error.equals(message)) {
            this.setError("");
        }
    }

    @Override
    public void actionPerformed(ErrorMessageEvent ee) {
        String message = ee.getMessage();
        this.setError(message);
    }
}

