/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.data.InstalledTempDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.gui.panel.sans.communication.TempDeviceChangedListener;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class BlueBoxTemperatureControlPanel
extends SansDeviceControlPanel
implements TempDeviceChangedListener {
    private static final long serialVersionUID = 1L;
    private JButton addRemoveBlueBoxButton;
    private JLabel blueBoxLabel;
    private JTextField blueBoxValueLabel;
    protected InstalledTempDevice theBlueBox;
    public static final String ADD_ACTION = "Add Blue Box";
    public static final String REMOVE_ACTION = "Remove Blue Box";
    public static final String BLUE_BOX_DEVICE_NAME = "BlueBoxTemperature";

    public BlueBoxTemperatureControlPanel() {
        super("Blue Box temperature", "bluebox");
    }

    @Override
    protected void init() {
        super.init();
        this.blueBoxLabel = new JLabel();
        this.blueBoxValueLabel = new SANSDecimalFormattedTextField(3);
        this.blueBoxValueLabel.setEditable(false);
        this.addRemoveBlueBoxButton = new JButton();
        this.theBlueBox = null;
        this.blueBoxValueLabel.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.blueBoxLabel.setText(this.controlName);
        this.add((Component)this.blueBoxLabel, gridBagConstraints);
        this.blueBoxLabel.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.blueBoxValueLabel.setText("");
        this.blueBoxValueLabel.setPreferredSize(new Dimension(60, 20));
        this.add((Component)this.blueBoxValueLabel, gridBagConstraints);
        this.blueBoxValueLabel.setEnabled(false);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.addRemoveBlueBoxButton.setText(ADD_ACTION);
        this.add((Component)this.addRemoveBlueBoxButton, gridBagConstraints);
        this.enableLabels(false);
    }

    @Override
    public String getCurrentValue() {
        return this.blueBoxValueLabel.getText();
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
        this.blueBoxValueLabel.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.addRemoveBlueBoxButton.addActionListener(listener);
        }
    }

    protected void setValues(InstalledTempDevice tempDevice) {
        String value = "";
        if (tempDevice != null) {
            value = tempDevice.getCurrValue();
        }
        this.setCurrentValue(value);
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        super.actionPerformed(evt);
        if (evt.getSource() instanceof InstalledTempDevice) {
            InstalledTempDevice changedDevice = (InstalledTempDevice)evt.getSource();
            this.setValues(changedDevice);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && this.theBlueBox == null) {
            this.enableLabels(false);
        } else if (enabled && this.theBlueBox != null) {
            this.enableLabels(true);
        }
    }

    protected void enableLabels(boolean enabled) {
        this.blueBoxLabel.setEnabled(enabled);
        this.blueBoxValueLabel.setEnabled(enabled);
    }

    @Override
    public void tempDeviceChanged(TempDeviceChangedListener.TempDeviceChangedEvent aEvent) {
        TempDeviceChangedListener.EventType eventType = TempDeviceChangedListener.EventType.UNDEFINED;
        InstalledTempDevice theDevice = null;
        ActionListener[] actionListeners = null;
        String name = null;
        eventType = aEvent.getEventType();
        theDevice = aEvent.getTheDevice();
        if (theDevice != null && (name = theDevice.getRealName()).equalsIgnoreCase("BLUEBOXTEMPERATURE")) {
            switch (eventType) {
                case ADDED: {
                    try {
                        theDevice.addValueChangeListener(this);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        Logger.getLogger("ErrorLogger").error("BuleBoxTemperatureControl " + e);
                    }
                    this.enableLabels(true);
                    this.theBlueBox = theDevice;
                    this.setValues(theDevice);
                    this.addRemoveBlueBoxButton.setText(REMOVE_ACTION);
                    break;
                }
                case REMOVED: {
                    theDevice.removeValueChangeListener(this);
                    this.enableLabels(false);
                    this.setValues(null);
                    this.addRemoveBlueBoxButton.setText(ADD_ACTION);
                    break;
                }
            }
        }
    }

    public void focusGained(FocusEvent e) {
        Container panel = this.getParent();
        if (panel instanceof SansIcePanel) {
            SansIcePanel sansPanel = (SansIcePanel)panel;
            sansPanel.setHelpText(this.hint);
        }
    }

    public void focusLost(FocusEvent e) {
    }
}

