/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.data.IceFile;
import ice.data.IceFileType;
import ice.event.communication.PythonResetEvent;
import ice.event.communication.PythonResetListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceViewPanel;
import ice.gui.core.IceWindow;
import ice.gui.core.controls.serverFileView.ServerFileSelectionDialog;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.jython.console.JythonConsole;
import ice.jython.management.PythonContainer;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class PythonConsolePanel
extends IceViewPanel
implements PythonResetListener {
    private static final String PANEL_NAME = "Python Console";
    protected PythonMenuItem pythonMenu = null;
    protected File currentLocalLoadDirectory = new File(".");
    private static Logger logger = Logger.getLogger("ErrorLogger");

    public PythonConsolePanel() throws IcePanelException {
        super(PANEL_NAME);
    }

    @Override
    protected void buildGUI() {
        this.addJyConsole();
    }

    @Override
    public void actionPerformed(PythonResetEvent ace) {
        this.removeJyConsole();
        this.addJyConsole();
    }

    protected void addJyConsole() {
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        JythonConsole jythonConsole = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        PythonContainer pythonContainer = null;
        pythonContainer = PythonContainer.getReference();
        jythonConsole = pythonContainer.getPythonConsole();
        this.add((Component)jythonConsole, gridBagConstraints);
        jythonConsole.revalidate();
        this.revalidate();
    }

    protected void removeJyConsole() {
        this.removeAll();
        this.revalidate();
    }

    @Override
    protected void init() {
        PythonContainer pythonContainer = null;
        pythonContainer = PythonContainer.getReference();
        try {
            pythonContainer.addPythonResetListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("Could not add python reset listener " + e);
        }
    }

    protected PythonMenuItem getPythonMenu() {
        if (this.pythonMenu == null) {
            this.pythonMenu = new PythonMenuItem();
        }
        return this.pythonMenu;
    }

    protected void addPythonMenuInFrontOfHelpMenu() {
        IceWindow theIceWindow = null;
        theIceWindow = this.getIceWindowParent();
        if (theIceWindow != null) {
            JMenuBar theMenuBar = null;
            theMenuBar = theIceWindow.getJMenuBar();
            if (theMenuBar != null) {
                int helpIndex = -1;
                MenuElement[] menus = null;
                Component aComponent = null;
                String menuElementText = null;
                MenuElement[] menuElementArray = menus = theMenuBar.getSubElements();
                int n = menus.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuElement menuElement = menuElementArray[n2];
                    aComponent = menuElement.getComponent();
                    if (aComponent instanceof JMenu && (menuElementText = ((JMenu)aComponent).getText()).compareTo("Help") == 0) {
                        PythonMenuItem thePythonMenu = null;
                        thePythonMenu = this.getPythonMenu();
                        helpIndex = theMenuBar.getComponentIndex(aComponent);
                        theMenuBar.add((Component)thePythonMenu, helpIndex);
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    protected void removePythonMenuFromTheMenuBar() {
        IceWindow theIceWindow = null;
        theIceWindow = this.getIceWindowParent();
        if (theIceWindow != null) {
            JMenuBar theMenuBar = null;
            theMenuBar = theIceWindow.getJMenuBar();
            if (theMenuBar != null) {
                theMenuBar.remove(this.pythonMenu);
            }
        }
    }

    @Override
    public void panelAddedToWindow() {
        super.panelAddedToWindow();
        this.addPythonMenuInFrontOfHelpMenu();
    }

    @Override
    public void panelRemovedFromWindow() {
        this.removePythonMenuFromTheMenuBar();
    }

    @Override
    public boolean panelClosing() {
        this.removePythonMenuFromTheMenuBar();
        return true;
    }

    @Override
    public boolean panelHandlesScrollBar() {
        return true;
    }

    protected class LocalLoadMenuSelected
    implements ActionListener {
        static final String DIALOG_NAME = "Load File";
        static final String ERROR_MESSAGE = " not found!";
        static final String ERROR_TITLE = "Error";

        protected LocalLoadMenuSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFileChooser fileChooser = null;
            PythonFileFilter pythonFileFilter = null;
            File selectedFile = null;
            fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(DIALOG_NAME);
            fileChooser.setCurrentDirectory(PythonConsolePanel.this.currentLocalLoadDirectory);
            pythonFileFilter = new PythonFileFilter();
            fileChooser.setFileFilter(pythonFileFilter);
            fileChooser.showOpenDialog(PythonConsolePanel.this);
            PythonConsolePanel.this.currentLocalLoadDirectory = fileChooser.getCurrentDirectory();
            selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                PythonContainer pythonContainer = null;
                pythonContainer = PythonContainer.getReference();
                try {
                    pythonContainer.executeFile(selectedFile);
                }
                catch (FileNotFoundException e) {
                    String message = "";
                    message = String.valueOf(message) + selectedFile.getName() + ERROR_MESSAGE;
                    PythonConsolePanel.this.throwErrorDialog(ERROR_TITLE, message);
                }
            }
        }
    }

    protected class PythonFileFilter
    extends FileFilter {
        static final String FILE_EXTENTION = ".py";
        static final String FILTER_DESCRIPTION = "Python (*..py)";

        protected PythonFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            boolean acceptFile = false;
            String fileName = null;
            boolean isDirectory = false;
            fileName = pathname.getName();
            isDirectory = pathname.isDirectory();
            if (isDirectory || fileName.endsWith(FILE_EXTENTION)) {
                acceptFile = true;
            }
            return acceptFile;
        }

        @Override
        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    protected class PythonMenuItem
    extends JMenu {
        protected static final String NAME = "Python";
        public static final String LOAD_MENU_NAME = "Load";
        public static final String LOCAL_MENU_NAME = "Local";
        public static final String REMOTE_MENU_NAME = "Remote";
        public static final String RESET_MENU_NAME = "Reset";
        public static final String STOP_MENU_NAME = "Stop";
        protected JMenu loadMenuPopup;
        protected JMenuItem localMenuItem;
        protected JMenuItem remoteMenuItem;
        protected JMenuItem resetMenuItem;
        protected JMenuItem stopMenuItem;

        public PythonMenuItem() {
            this.loadMenuPopup = null;
            this.localMenuItem = null;
            this.remoteMenuItem = null;
            this.resetMenuItem = null;
            this.stopMenuItem = null;
            this.init();
        }

        private PythonMenuItem(Action a) {
            super(a);
            this.loadMenuPopup = null;
            this.localMenuItem = null;
            this.remoteMenuItem = null;
            this.resetMenuItem = null;
            this.stopMenuItem = null;
            this.init();
        }

        private PythonMenuItem(String text) {
            super(text);
            this.loadMenuPopup = null;
            this.localMenuItem = null;
            this.remoteMenuItem = null;
            this.resetMenuItem = null;
            this.stopMenuItem = null;
            this.init();
        }

        protected void init() {
            ActionListener menuAction = null;
            this.setName(NAME);
            this.setText(NAME);
            this.loadMenuPopup = new JMenu(LOAD_MENU_NAME);
            this.add(this.loadMenuPopup);
            this.localMenuItem = new JMenuItem(LOCAL_MENU_NAME);
            this.loadMenuPopup.add(this.localMenuItem);
            menuAction = new LocalLoadMenuSelected();
            this.localMenuItem.addActionListener(menuAction);
            this.remoteMenuItem = new JMenuItem(REMOTE_MENU_NAME);
            this.loadMenuPopup.add(this.remoteMenuItem);
            menuAction = new RemoteLoadMenuSelected();
            this.remoteMenuItem.addActionListener(menuAction);
            JSeparator separator = new JSeparator();
            this.add(separator);
            this.resetMenuItem = new JMenuItem(RESET_MENU_NAME);
            this.add(this.resetMenuItem);
            menuAction = new ResetMenuSelected();
            this.resetMenuItem.addActionListener(menuAction);
            this.stopMenuItem = new JMenuItem(STOP_MENU_NAME);
            this.add(this.stopMenuItem);
            menuAction = new StopMenuSelected();
            this.stopMenuItem.addActionListener(menuAction);
        }
    }

    protected class RemoteLoadMenuSelected
    implements ActionListener {
        protected RemoteLoadMenuSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            IceWindow parentWindow = null;
            Object selectedFile = null;
            Object serverFileSelectionDialog = null;
            parentWindow = PythonConsolePanel.this.getIceWindowParent();
            selectedFile = ServerFileSelectionDialog.selectIceFileFromServer(parentWindow, IceFileType.pythonScript, ServerFolderView.ValidServerFolders.EXPT);
            if (selectedFile != null && selectedFile instanceof IceFile) {
                PythonContainer pythonContainer = null;
                String message = "";
                message = String.valueOf(message) + ((IceFile)selectedFile).getName() + " not found!";
                pythonContainer = PythonContainer.getReference();
                try {
                    boolean succeeded = false;
                    succeeded = pythonContainer.loadRemotePythonFile((IceFile)selectedFile);
                    if (!succeeded) {
                        PythonConsolePanel.this.throwErrorDialog("Error", message);
                    }
                }
                catch (Exception e) {
                    PythonConsolePanel.this.throwErrorDialog("Error", message);
                }
            }
        }
    }

    protected class ResetMenuSelected
    extends GenericIcePanel.ConfirmableAction {
        public static final String ACTION_NAME = "Reset";
        protected static final String CONFIRMATION_MESSAGE_KEY = "ice.gui.panel.PythonConsolePanel.ResetMenuSelected.ConfirmationMessage";
        protected static final String CONFIRMATION_TITLE_KEY = "ice.gui.panel.PythonConsolePanel.ResetMenuSelected.ConfirmationTitle";
        protected String title;
        protected String message;

        public ResetMenuSelected() {
            super(ACTION_NAME);
            this.title = I18N.getString(CONFIRMATION_TITLE_KEY);
            this.message = I18N.getString(CONFIRMATION_MESSAGE_KEY);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ArrayList<JButton> btns = this.createOkCancelBtns();
            PythonConsolePanel.this.throwConfirmDialog(this.title, this.message, btns);
        }

        @Override
        protected void confirmed() {
            PythonContainer pythonContainer = null;
            pythonContainer = PythonContainer.getReference();
            pythonContainer.reset();
        }

        @Override
        protected void declined() {
        }
    }

    protected class StopMenuSelected
    implements ActionListener {
        protected StopMenuSelected() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            PythonContainer pythonContainer = null;
            pythonContainer = PythonContainer.getReference();
            pythonContainer.stop();
        }
    }
}

