/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses.DeviceValue;

import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import ice.swing.textFields.ICEDecimalFormattedTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class HKLDeviceValue
extends DeviceValue {
    private Map<String, Double> value = new HashMap<String, Double>(3);
    protected PlainDocument hDocument = new PlainDocument();
    protected PlainDocument kDocument = new PlainDocument();
    protected PlainDocument lDocument = new PlainDocument();
    protected static final int defaultWidth = 5;
    protected static GridBagConstraints hLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0);
    protected static GridBagConstraints kLabelConstraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0);
    protected static GridBagConstraints lLabelConstraints = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0);
    protected static GridBagConstraints hControlConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 6, 0);
    protected static GridBagConstraints kControlConstraints = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0);
    protected static GridBagConstraints lControlConstraints = new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0);

    public HKLDeviceValue() {
        this.value.put("h", Double.NaN);
        this.value.put("k", Double.NaN);
        this.value.put("l", Double.NaN);
        this.valid = false;
        this.hDocument.addDocumentListener(new ControlDocumentsListener());
        this.kDocument.addDocumentListener(new ControlDocumentsListener());
        this.lDocument.addDocumentListener(new ControlDocumentsListener());
    }

    @Override
    public JComponent getControl() {
        HKLPanel hklPanel = new HKLPanel();
        hklPanel.setLayout(new GridBagLayout());
        JLabel hLabel = new JLabel("h");
        JLabel kLabel = new JLabel("k");
        JLabel lLabel = new JLabel("l");
        ICEDecimalFormattedTextField hField = new ICEDecimalFormattedTextField();
        hField.setDocument(this.hDocument);
        hField.setColumns(5);
        hField.setChangedColor(null);
        ICEDecimalFormattedTextField kField = new ICEDecimalFormattedTextField();
        kField.setDocument(this.kDocument);
        kField.setColumns(5);
        kField.setChangedColor(null);
        ICEDecimalFormattedTextField lField = new ICEDecimalFormattedTextField();
        lField.setDocument(this.lDocument);
        lField.setColumns(5);
        lField.setChangedColor(null);
        hklPanel.add((Component)hLabel, hLabelConstraints);
        hklPanel.add((Component)hField, hControlConstraints);
        hklPanel.add((Component)kLabel, kLabelConstraints);
        hklPanel.add((Component)kField, kControlConstraints);
        hklPanel.add((Component)lLabel, lLabelConstraints);
        hklPanel.add((Component)lField, lControlConstraints);
        return hklPanel;
    }

    @Override
    public String getValueString() {
        if (!this.valid) {
            return "";
        }
        return String.valueOf(String.valueOf(this.value.get("h"))) + "~" + String.valueOf(this.value.get("k")) + "~" + String.valueOf(this.value.get("l"));
    }

    @Override
    public boolean parseString(String qText) {
        String[] qComponents;
        block3: {
            try {
                qComponents = qText.split("~");
                if (qComponents.length == 3) break block3;
                return false;
            }
            catch (Exception e) {
                this.valid = false;
                return false;
            }
        }
        this.value.put("h", Double.valueOf(qComponents[0]));
        this.value.put("k", Double.valueOf(qComponents[1]));
        this.value.put("l", Double.valueOf(qComponents[2]));
        this.valid = true;
        return true;
    }

    @Override
    public String getErrorText() {
        if (this.validateData()) {
            return "";
        }
        return "Invalid";
    }

    public void updateFromControlDocuments() {
        try {
            this.value.put("h", Double.valueOf(this.hDocument.getText(0, this.hDocument.getLength())));
            this.value.put("k", Double.valueOf(this.kDocument.getText(0, this.kDocument.getLength())));
            this.value.put("l", Double.valueOf(this.lDocument.getText(0, this.lDocument.getLength())));
            this.valid = true;
        }
        catch (Exception ex) {
            this.valid = false;
        }
    }

    public void setValue(double h, double k, double l) {
        this.value.put("h", h);
        this.value.put("k", k);
        this.value.put("l", l);
    }

    public double getH() {
        return this.value.get("h");
    }

    public double getK() {
        return this.value.get("k");
    }

    public double getL() {
        return this.value.get("l");
    }

    protected class ControlDocumentsListener
    implements DocumentListener {
        protected ControlDocumentsListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            HKLDeviceValue.this.updateFromControlDocuments();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            HKLDeviceValue.this.updateFromControlDocuments();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            HKLDeviceValue.this.updateFromControlDocuments();
        }
    }

    protected class HKLPanel
    extends JPanel {
        protected HKLPanel() {
        }

        @Override
        public void setEnabled(boolean enabled) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setEnabled(enabled);
                ++n2;
            }
        }
    }
}

