/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses.DeviceValue;

import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import ice.swing.textFields.ICEDecimalFormattedTextField;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class DoubleDeviceValue
extends DeviceValue {
    private static Logger logger = Logger.getLogger("ScanOperation.DoubleDeviceValue");
    private double value;
    private double minimum = Double.MIN_VALUE;
    private double maximum = Double.MAX_VALUE;
    public static final int DEFAULTWIDTH = 22;
    protected PlainDocument controlDocument = new PlainDocument();

    public DoubleDeviceValue(double value) {
        this.value = value;
        this.valid = true;
        this.controlDocument.addDocumentListener(new ControlDocumentsListener());
    }

    public DoubleDeviceValue() {
        this.value = Double.NaN;
        this.valid = false;
        this.controlDocument.addDocumentListener(new ControlDocumentsListener());
    }

    public DoubleDeviceValue(String value) {
        this.parseString(value);
    }

    @Override
    public boolean parseString(String value) {
        try {
            this.value = Double.valueOf(value);
            this.valid = true;
            return true;
        }
        catch (NumberFormatException e) {
            this.valid = false;
            return false;
        }
    }

    @Override
    public Object getValue() {
        return new Double(this.value);
    }

    public void setValue(double newValue) {
        this.value = newValue;
        this.valid = true;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    @Override
    public String getErrorText() {
        if (this.validateData()) {
            return "";
        }
        return "Invalid";
    }

    @Override
    public JComponent getControl() {
        ICEDecimalFormattedTextField control = new ICEDecimalFormattedTextField();
        control.setDocument(this.controlDocument);
        control.setColumns(22);
        control.setChangedColor(null);
        if (!Double.isNaN(this.value)) {
            control.setValue(this.value);
        }
        return control;
    }

    protected class ControlDocumentsListener
    implements DocumentListener {
        protected ControlDocumentsListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            try {
                DoubleDeviceValue.this.setValue(new Double(DoubleDeviceValue.this.controlDocument.getText(0, DoubleDeviceValue.this.controlDocument.getLength())));
                DoubleDeviceValue.this.valid = true;
            }
            catch (Exception ex) {
                DoubleDeviceValue.this.setValue(Double.NaN);
                DoubleDeviceValue.this.valid = false;
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                DoubleDeviceValue.this.setValue(new Double(DoubleDeviceValue.this.controlDocument.getText(0, DoubleDeviceValue.this.controlDocument.getLength())));
                DoubleDeviceValue.this.valid = true;
            }
            catch (Exception ex) {
                DoubleDeviceValue.this.setValue(Double.NaN);
                DoubleDeviceValue.this.valid = false;
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                DoubleDeviceValue.this.setValue(new Double(DoubleDeviceValue.this.controlDocument.getText(0, DoubleDeviceValue.this.controlDocument.getLength())));
                DoubleDeviceValue.this.valid = true;
            }
            catch (Exception ex) {
                DoubleDeviceValue.this.setValue(Double.NaN);
                DoubleDeviceValue.this.valid = false;
            }
        }
    }
}

