/*
 * Decompiled with CFR 0.152.
 */
package ice.event;

import ice.IcePanelManager;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.core.TearTabbedPane;
import ice.rubberband.RubberBand;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IcePanelDragListener
extends MouseAdapter
implements MouseMotionListener {
    private static Logger logger = Logger.getLogger("RootLogger");
    private boolean inDragState = false;
    private RubberBand rubberBand = null;
    private Point offset;
    private HashMap<IceWindow, Rectangle> tabBars;
    private IcePanelManager panelManager;
    private Set<IceWindow> windowList;

    public IcePanelDragListener(RubberBand band) {
        this.rubberBand = band;
        this.tabBars = new HashMap();
        this.windowList = null;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.inDragState = true;
        this.processDrag(me);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.startDrag(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.inDragState) {
            this.stopDrag(me);
            this.inDragState = false;
        }
    }

    private void startDrag(MouseEvent me) {
        logger.debug("start drag.  Source: " + me.getSource());
        this.tabBars.clear();
        this.panelManager = IcePanelManager.getReference();
        this.windowList = this.panelManager.getWindowSet();
        for (IceWindow window : this.windowList) {
            this.tabBars.put(window, window.getTabBar());
        }
        try {
            TearTabbedPane tabbedPane = (TearTabbedPane)me.getSource();
            IceWindow mw = (IceWindow)tabbedPane.getRealParent();
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, (Component)me.getSource());
            Point win = mw.getLocationOnScreen();
            this.offset = new Point(win.x - p.x, win.y - p.y);
        }
        catch (ClassCastException cce) {
            logger.error("ClassCastException:", cce);
        }
    }

    private void processDrag(MouseEvent me) {
        try {
            TearTabbedPane tabbedPane = (TearTabbedPane)me.getSource();
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, tabbedPane);
            Iterator<IceWindow> iterator = this.tabBars.keySet().iterator();
            boolean inWindow = false;
            Rectangle r1 = tabbedPane.getSelectedComponent().getBounds();
            while (iterator.hasNext()) {
                IceWindow mw = iterator.next();
                Rectangle tabBar = this.tabBars.get(mw);
                if (!tabBar.contains(p)) continue;
                r1 = mw.getSelectedScreenBounds();
                r1.y -= tabBar.height;
                r1.height += tabBar.height;
                inWindow = true;
                break;
            }
            if (!inWindow) {
                r1.setLocation(this.getMousePoint(me));
            }
            logger.debug("r1: " + r1);
            if (this.rubberBand != null) {
                this.rubberBand.paint(r1);
            }
        }
        catch (ClassCastException cce) {
            logger.error("ClassCastException:", cce);
        }
    }

    private void stopDrag(MouseEvent me) {
        try {
            boolean inWindow = false;
            TearTabbedPane tabbedPane = (TearTabbedPane)me.getSource();
            IceWindow oldParent = (IceWindow)tabbedPane.getRealParent();
            logger.debug("stop drag");
            logger.debug("source: " + me.getSource());
            Point p = me.getPoint();
            SwingUtilities.convertPointToScreen(p, (Component)me.getSource());
            for (IceWindow mw : this.tabBars.keySet()) {
                Rectangle tabBar = this.tabBars.get(mw);
                if (tabBar.contains(p)) {
                    logger.debug("in tab bar");
                    Component comp = tabbedPane.getSelectedComponent();
                    this.moveTab(comp, mw, oldParent, p);
                    if (oldParent.getTabCount() == 0) {
                        this.windowList.remove(oldParent);
                        oldParent.dispose();
                        this.panelManager.removeIceWindowFromMenus(oldParent);
                    }
                    inWindow = true;
                    break;
                }
                logger.debug("not in tab bar");
            }
            if (!inWindow) {
                Component comp = tabbedPane.getSelectedComponent();
                this.createNewWindow(comp, oldParent, p);
            }
            if (this.rubberBand != null) {
                this.rubberBand.clear();
            }
            this.offset = null;
        }
        catch (ClassCastException cce) {
            logger.error("ClassCastException.  THIS SHOULDN'T HAPPEN.", cce);
        }
    }

    private Point getMousePoint(MouseEvent me) {
        Point p = me.getPoint();
        SwingUtilities.convertPointToScreen(p, (Component)me.getSource());
        p.x += this.offset.x;
        p.y += this.offset.y;
        return p;
    }

    private void createNewWindow(Component comp, IceWindow oldParent, Point p) {
        Point offsetPoint = new Point(p.x + this.offset.x, p.y + this.offset.y);
        this.panelManager.createNewIceWindow(this, comp, offsetPoint, oldParent);
    }

    private void moveTab(Component comp, IceWindow newParent, IceWindow oldParent, Point p) {
        int index = newParent.indexAtScreenLocation(p);
        GenericIcePanel panel = null;
        panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
        boolean withScrollBar = true;
        if (newParent != oldParent) {
            oldParent.removeTab(comp);
            if (index != -1) {
                newParent.addPanelTab(panel, index);
            } else {
                newParent.addPanelTab(panel);
            }
            this.panelManager.updateIceWindows(oldParent, newParent, panel);
            this.panelManager.updateIceWindowMenus(oldParent, newParent, panel);
        } else {
            newParent.removeTab(comp);
            if (index != -1) {
                newParent.addPanelTab(panel, index);
            } else {
                newParent.addPanelTab(panel);
            }
        }
    }
}

