/*
 * Decompiled with CFR 0.152.
 */
package ice.data.tas.bt7;

import ice.event.MonochromatorPropertyChangedEvent;
import ice.event.MonochromatorPropertyChangedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;

public class Monochromator {
    public static final String DSpacingFieldName = "DSpacing";
    public static final String[] materials = new String[]{"PG002=3.35416", "Cu220=1.278"};
    private double dSpacing;
    private ICEListenerList<MonochromatorPropertyChangedListener, MonochromatorPropertyChangedEvent> changeListeners = new ICEListenerList();

    public double getDSpacing() {
        return this.dSpacing;
    }

    public void setDSpacing(double spacing) {
        double oldDSpacing = this.dSpacing;
        this.dSpacing = spacing;
        this.notifyPropertyChangeListeners(DSpacingFieldName, oldDSpacing, this.dSpacing);
    }

    public void addPropertyChangeListener(MonochromatorPropertyChangedListener pcl) throws ICEListenerListExceptionBase {
        this.changeListeners.addListener(pcl);
    }

    public void removePropertyChangeListener(MonochromatorPropertyChangedListener pcl) {
        this.changeListeners.removeListener(pcl);
    }

    public void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        MonochromatorPropertyChangedEvent pce = new MonochromatorPropertyChangedEvent(this, propertyName, oldValue, newValue);
        this.changeListeners.notifyListeners(pce);
    }
}

