/*
 * Decompiled with CFR 0.152.
 */
package ice.data.tas.bt7;

import ice.event.AnalyzerPropertyChangedEvent;
import ice.event.AnalyzerPropertyChangedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import org.apache.log4j.Logger;

public class Analyzer {
    private static Logger logger = Logger.getLogger("DataLogger.AnalyzerLogger");
    public static final String[] materials = new String[]{"PG002=3.35416", "PG004=1.67708", "Ge111=3.2658", "Ge311=1.7055"};
    public static final String DSpacingFieldName = "DSpacing";
    private double dSpacing;
    private ICEListenerList<AnalyzerPropertyChangedListener, AnalyzerPropertyChangedEvent> changeListeners = new ICEListenerList();

    public double getDSpacing() {
        return this.dSpacing;
    }

    public void setDSpacing(double spacing) {
        double oldDSpacing = this.dSpacing;
        this.dSpacing = spacing;
        logger.debug("setAnaDSpacing");
        this.notifyPropertyChangeListeners(DSpacingFieldName, oldDSpacing, this.dSpacing);
    }

    public void addPropertyChangeListener(AnalyzerPropertyChangedListener pcl) throws ICEListenerListExceptionBase {
        this.changeListeners.addListener(pcl);
    }

    public void removePropertyChangeListener(AnalyzerPropertyChangedListener pcl) {
        this.changeListeners.removeListener(pcl);
    }

    public void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        AnalyzerPropertyChangedEvent pce = new AnalyzerPropertyChangedEvent(this, propertyName, oldValue, newValue);
        this.changeListeners.notifyListeners(pce);
    }
}

