/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

public enum IceFileType {
    directory("Directory", "", false),
    scanList("Scan List", ".scan.txt", false),
    scan("Scan", "", true),
    angleScan("ANGLE", "", true),
    environmentScan("ENV", "", true),
    motorScan("MOTOR", "", true),
    vectorScan("VECTOR", "", true),
    sansScan("SANS", "", true),
    sansAutoScan("SANSAUTO", "", true),
    unknownScan("UNKNOWN", "", true),
    sequence("Sequence", ".seq.txt", false),
    pythonScript("Python Script", ".py", false),
    data("Data File", "", false),
    xml("XML File", ".xml", false),
    sansConfig("SANS Config", ".cfg", false),
    other("Other", "", false),
    unknown("UNKNOWN", "", false);

    private String name;
    private String extension;
    private boolean isAScanType = false;
    private String regex;

    private IceFileType(String name, String extension, boolean isAScanType) {
        this.name = name;
        this.extension = extension;
        this.isAScanType = isAScanType;
        if (!this.isAScanType) {
            if (extension != null && !extension.equals("")) {
                this.regex = "^.+\\." + extension.substring(1) + "$";
            }
        } else {
            this.regex = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public static IceFileType valueFromExtension(String extension) {
        IceFileType returnValue = unknown;
        IceFileType[] fileTypes = null;
        fileTypes = IceFileType.values();
        if (extension != null) {
            IceFileType[] iceFileTypeArray = fileTypes;
            int n = fileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IceFileType fileType = iceFileTypeArray[n2];
                if (fileType.getExtension().equals(extension)) {
                    returnValue = fileType;
                }
                ++n2;
            }
        }
        return returnValue;
    }

    public static IceFileType valueFromName(String theName) {
        IceFileType returnValue = unknown;
        IceFileType[] fileTypes = null;
        fileTypes = IceFileType.values();
        if (theName != null) {
            IceFileType[] iceFileTypeArray = fileTypes;
            int n = fileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IceFileType fileType = iceFileTypeArray[n2];
                if (fileType.getName().equals(theName)) {
                    returnValue = fileType;
                }
                ++n2;
            }
        }
        return returnValue;
    }

    public boolean isAScanType() {
        return this.isAScanType;
    }

    public String getRegex() {
        return this.regex;
    }
}

