/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.IceFileType;
import ice.data.Resource;
import ice.event.IceFileEvent;
import ice.event.IceFileListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class IceFile
extends Resource
implements Comparable,
Transferable,
Cloneable {
    private static Logger logger = Logger.getLogger("IceFileLogger");
    public static final String FileLengthFieldName = "fileLength";
    public static final String FileLastModifiedFieldName = "fileLastModified";
    public static final String FileParentFieldName = "fileParent";
    private DataFlavor flavor;
    private DataFlavor[] availableFlavors;
    private long lastModified;
    private long length;
    private IceFile parent;
    private ArrayList<IceFile> children = new ArrayList();
    private boolean magicWord = false;
    protected ICEListenerList<IceFileListener, IceFileEvent> listeners;
    private boolean initialized;

    public IceFile(String filename, IceFileType fileType) {
        this(filename, null, fileType);
    }

    public IceFile(String filename, String contents, IceFileType fileType) {
        this(filename, contents, fileType, false);
    }

    public IceFile(String filename, IceFileType fileType, boolean magicWord) {
        this(filename, null, fileType, magicWord);
    }

    public IceFile(String filename, String contents, IceFileType fileType, boolean magicWord) {
        super(filename, contents, fileType);
        this.magicWord = magicWord;
        this.flavor = new DataFlavor(IceFile.class, "IceFile");
        this.availableFlavors = new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
        this.initialized = false;
        this.init();
    }

    protected void init() {
        this.listeners = new ICEListenerList();
    }

    public void addIceFileListener(IceFileListener ifl) throws ICEListenerListExceptionBase {
        this.listeners.addListener(ifl);
    }

    public void removeIceFileListener(IceFileListener ifl) {
        this.listeners.removeListener(ifl);
    }

    public int getIndexOfChild(String name) {
        int i = 0;
        while (i < this.children.size()) {
            if (this.children.get(i).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllChildren() {
        int[] indices = new int[this.children.size()];
        IceFile[] childrenRemoved = new IceFile[this.children.size()];
        int i = 0;
        Iterator<IceFile> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            childrenRemoved[i] = iterator.next();
            iterator.remove();
            indices[i] = i;
            ++i;
        }
        this.notifyListenersOfRemove(indices, childrenRemoved);
    }

    public boolean remove(IceFile fileToRemove) {
        int index = this.children.indexOf(fileToRemove);
        int[] indices = new int[]{index};
        IceFile[] files = new IceFile[]{fileToRemove};
        this.notifyListenersOfRemove(indices, files);
        return this.children.remove(fileToRemove);
    }

    public boolean add(IceFile newChild) {
        if (this.getFileType() != IceFileType.directory && this.getFileType() != IceFileType.scanList) {
            return false;
        }
        boolean result = this.children.add(newChild);
        if (result) {
            newChild.setParent(this);
            int index = this.children.indexOf(newChild);
            logger.debug("adding " + newChild.getName() + " to " + this.getName() + " at index " + index);
            int[] indices = new int[]{index};
            this.notifyListenersOfAdd(indices);
        }
        return result;
    }

    private void notifyListenersOfAdd(int[] indices) {
        IceFileEvent iceFileEvent = new IceFileEvent(IceFileEvent.Type.ADDED, this, this, indices);
        this.listeners.notifyListeners(iceFileEvent);
    }

    private void notifyListenersOfRemove(int[] indices, IceFile[] childrenRemoved) {
        IceFileEvent iceFileEvent = new IceFileEvent(IceFileEvent.Type.REMOVED, this, this, indices, childrenRemoved);
        this.listeners.notifyListeners(iceFileEvent);
    }

    public int getIndexOfChild(IceFile child) {
        return this.children.indexOf(child);
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public IceFile getChildAt(int i) {
        return this.children.get(i);
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        long oldLastModified = this.lastModified;
        this.lastModified = lastModified;
        this.notifyPropertyChangeListeners(FileLastModifiedFieldName, oldLastModified, this.lastModified);
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        long oldLength = this.length;
        this.length = length;
        this.notifyPropertyChangeListeners(FileLengthFieldName, oldLength, this.length);
    }

    public IceFile getParent() {
        return this.parent;
    }

    public void setParent(IceFile parent) {
        IceFile oldParent = this.parent;
        this.parent = parent;
        this.notifyPropertyChangeListeners(FileParentFieldName, oldParent, this.parent);
    }

    public boolean isRoot() {
        return this.parent != null;
    }

    public ArrayList<IceFile> getChildren() {
        return this.children;
    }

    public boolean isMagicWord() {
        return this.magicWord;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (this.flavor.equals(flavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getName();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.availableFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavor.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
    }

    public static void main(String[] s) {
        IceFile iceFile = new IceFile("blah", IceFileType.other);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public Object cloneWithNewListeners() {
        Object returnValue = null;
        returnValue = super.cloneWithNewListeners();
        ((IceFile)returnValue).listeners = new ICEListenerList();
        ((IceFile)returnValue).children = new ArrayList();
        ((IceFile)returnValue).children = (ArrayList)this.children.clone();
        return returnValue;
    }
}

