/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.AvailableEnvDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AvailableTempDevice
extends AvailableEnvDevice {
    public static final String sampleChannelFieldName = "sampleChannel";
    public static final String controlChannelFieldName = "controlChannel";
    public static final String numChannelsFieldName = "numChannels";
    public static final String maxUpperTiltFieldName = "maxUpperTilt";
    public static final String maxLowerTiltFieldName = "maxLowerTilt";
    private static Logger logger = Logger.getLogger("ice.ServerModel.AvailableTempDevice");
    protected int sampleChannel;
    protected int controlChannel;
    protected int numChannels;
    protected double maxUpperTilt;
    protected double maxLowerTilt;

    public static List<AvailableTempDevice> parseXmlList(Node listNode) {
        ArrayList<AvailableTempDevice> deviceList = new ArrayList<AvailableTempDevice>();
        NodeList deviceNodes = listNode.getChildNodes();
        int i = 0;
        while (i < deviceNodes.getLength()) {
            Node deviceNode = deviceNodes.item(i);
            if (1 == deviceNode.getNodeType()) {
                String units = null;
                Integer sampleChannel = null;
                Integer controlChannel = null;
                Integer numChannels = null;
                Double maxUpperTilt = null;
                Double maxLowerTilt = null;
                String deviceName = deviceNode.getNodeName();
                NodeList deviceProperties = deviceNode.getChildNodes();
                int j = 0;
                while (j < deviceProperties.getLength()) {
                    Node devicePropertyNode = deviceProperties.item(j);
                    if (1 == devicePropertyNode.getNodeType()) {
                        String devicePropertyName = devicePropertyNode.getNodeName();
                        if ("units".equals(devicePropertyName)) {
                            logger.debug("units");
                            units = devicePropertyNode.getFirstChild().getNodeValue().trim();
                        } else if ("lowerTiltLimit".equals(devicePropertyName)) {
                            logger.debug("lower tilt");
                            try {
                                maxLowerTilt = Double.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid max lower tilt.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("upperTiltLimit".equals(devicePropertyName)) {
                            logger.debug("upper tilt");
                            try {
                                maxUpperTilt = Double.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid max upper tilt.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("sampleSensorIndex".equals(devicePropertyName)) {
                            logger.debug("sample channel");
                            try {
                                sampleChannel = Integer.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid sample channel.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("controlSensorIndex".equals(devicePropertyName)) {
                            logger.debug("control channel");
                            try {
                                controlChannel = Integer.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid control channel.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("numSensors".equals(devicePropertyName)) {
                            logger.debug("number of sensores/channels");
                            try {
                                numChannels = Integer.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException e) {
                                logger.error("Invalid number for number of channels (" + devicePropertyNode.getFirstChild().getNodeValue().trim() + ").  This shouldn't happen.  Ignoring.");
                            }
                        }
                    }
                    ++j;
                }
                AvailableTempDevice device = new AvailableTempDevice(deviceName, units, sampleChannel, controlChannel, numChannels, maxUpperTilt, maxLowerTilt);
                deviceList.add(device);
            }
            ++i;
        }
        return deviceList;
    }

    public AvailableTempDevice(String name, String units, int sampleChannel, int controlChannel, int numChannels, double maxUpperTilt, double maxLowerTilt) {
        super(name, units);
        this.sampleChannel = sampleChannel;
        this.controlChannel = controlChannel;
        this.numChannels = numChannels;
        this.maxUpperTilt = maxUpperTilt;
        this.maxLowerTilt = maxLowerTilt;
    }

    public int getControlChannel() {
        return this.controlChannel;
    }

    public void setControlChannel(int newControlChannel) {
        double oldControlChannel = this.controlChannel;
        this.controlChannel = newControlChannel;
        this.notifyValueChangeListeners(controlChannelFieldName, oldControlChannel, this.controlChannel);
    }

    public double getMaxLowerTilt() {
        return this.maxLowerTilt;
    }

    public void setMaxLowerTilt(double lowerTilt) {
        double oldMaxLowerTilt = this.maxLowerTilt;
        this.maxLowerTilt = lowerTilt;
        this.notifyValueChangeListeners(maxLowerTiltFieldName, oldMaxLowerTilt, this.maxLowerTilt);
    }

    public int getSampleChannel() {
        return this.sampleChannel;
    }

    public void setSampleChannel(int newSampleChannel) {
        int oldSampleChannel = this.sampleChannel;
        this.sampleChannel = newSampleChannel;
        this.notifyValueChangeListeners(sampleChannelFieldName, oldSampleChannel, this.sampleChannel);
    }

    public double getMaxUpperTilt() {
        return this.maxUpperTilt;
    }

    public void setMaxUpperTilt(double newMaxUpperTilt) {
        double oldUpperTilt = this.maxUpperTilt;
        this.maxUpperTilt = newMaxUpperTilt;
        this.notifyValueChangeListeners(maxUpperTiltFieldName, oldUpperTilt, this.maxUpperTilt);
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(int numChannels) {
        double oldNumChannels = this.numChannels;
        this.numChannels = numChannels;
        this.notifyValueChangeListeners(numChannelsFieldName, oldNumChannels, this.numChannels);
    }
}

