/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.MessageQueue;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MoveCommand
extends QueuedCommand {
    protected ErrorType errorType;
    private static final String command = "MOVE ";
    private String deviceName = null;
    private String movePosition;
    private long commandID = 0L;
    private Hashtable<String, String> properties = null;
    private boolean relative;

    public MoveCommand() throws NoClientAPIInstanceException {
        this.errorType = ErrorType.UNKNOWN;
        this.setRelative(false);
    }

    public MoveCommand(String deviceName, String movePosition) throws NoClientAPIInstanceException {
        super(command + deviceName + " " + movePosition);
        this.deviceName = deviceName;
        this.movePosition = movePosition;
        this.commandID = this.getCommandId();
        this.errorType = ErrorType.UNKNOWN;
        this.setRelative(false);
        this.generateCommandString();
    }

    public MoveCommand(String deviceName, double movePosition) throws NoClientAPIInstanceException {
        super(command + deviceName + " " + movePosition);
        this.deviceName = deviceName;
        this.movePosition = Double.toString(movePosition);
        this.commandID = this.getCommandId();
        this.setRelative(false);
        this.errorType = ErrorType.UNKNOWN;
        this.generateCommandString();
    }

    public MoveCommand(String deviceName, double movePosition, boolean relative) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.movePosition = Double.toString(movePosition);
        this.commandID = this.getCommandId();
        this.errorType = ErrorType.UNKNOWN;
        this.setRelative(relative);
        this.generateCommandString();
    }

    public MoveCommand(String deviceName, double movePosition, Hashtable<String, String> properties) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.movePosition = Double.toString(movePosition);
        this.commandID = this.getCommandId();
        this.errorType = ErrorType.UNKNOWN;
        this.properties = properties;
        this.setRelative(false);
        this.generateCommandString();
    }

    public MoveCommand(String deviceName, double movePosition, ClientAPI clientApiRef) {
        super(command + deviceName + " " + movePosition, clientApiRef);
        this.deviceName = deviceName;
        this.movePosition = Double.toString(movePosition);
        this.commandID = this.getCommandId();
        this.errorType = ErrorType.UNKNOWN;
        this.generateCommandString();
    }

    public String generatePropertyString() {
        String returnValue = "";
        if (this.properties != null && this.properties.size() > 0) {
            Set<String> keys = null;
            String value = null;
            returnValue = String.valueOf(returnValue) + " -presetdevicesproperties\"" + this.deviceName + " ";
            keys = this.properties.keySet();
            for (String key : keys) {
                value = this.properties.get(key);
                if (value == null || value.equals("")) continue;
                returnValue = String.valueOf(returnValue) + key + " " + value + ", ";
            }
            returnValue = returnValue.substring(0, returnValue.length() - 2);
            returnValue = String.valueOf(returnValue) + "\"";
        }
        return returnValue;
    }

    @Override
    public synchronized String generateCommandString() {
        String propertyString = "";
        String commandString = "";
        propertyString = this.generatePropertyString();
        commandString = command + propertyString + " " + this.deviceName + " " + this.movePosition;
        if (this.relative) {
            commandString = String.valueOf(commandString) + " -relative";
        }
        this.setCommandString(commandString);
        return commandString;
    }

    @Override
    protected void parseSynchronousResponse() {
        Pattern moveRegEx = Pattern.compile("Moving\\s(\\S*)\\s(\\S*)");
        Pattern hardLimitRegEx = Pattern.compile("Motor_Move_HARDLIMIT_ERROR: \\S*\\s*hit a hard limit at \\S*");
        Pattern outsideToleranceRegEx = Pattern.compile("Motor_Move_ERROR:  \\S* failed to reach its backlash correction destination.  Backlash correction destination: \\S*  Location: \\S*");
        Pattern softLimitRegEx = Pattern.compile("Error: Cannot move device \\S* to \\S* because it is outside of the device's limits: \\S* \\S*");
        Pattern temperatureSoftLimitRegEx = Pattern.compile("DaliError: set point outside software limits");
        MessageQueue<String> messageQueue = this.getResponseMessageQueue();
        MessageQueue<String> errorQueue = this.getErrorMessageQueue();
        MessageQueue<String> commandMessageQueue = messageQueue.getMessagesForAbsCommandId(this.getCommandId());
        MessageQueue<String> commandErrorQueue = errorQueue.getMessagesForAbsCommandId(this.getCommandId());
        if (commandErrorQueue.size() > 0) {
            String firstErrorString = commandErrorQueue.remove();
            Matcher matcher = temperatureSoftLimitRegEx.matcher(firstErrorString = this.stripResponseString(firstErrorString));
            if (matcher.matches()) {
                this.setResponseString(firstErrorString);
                this.errorType = ErrorType.SOFTLIMIT;
                this.setError(true);
                this.setSuccess(false);
                return;
            }
            this.setResponseString(firstErrorString);
            this.errorType = ErrorType.UNKNOWN;
            this.setError(true);
            this.setSuccess(false);
            return;
        }
        if (messageQueue.size() < 2) {
            this.setError(true);
            this.setSuccess(false);
            this.errorType = ErrorType.INVALID_SERVER_RESPONSE;
            return;
        }
        String firstMessageString = commandMessageQueue.remove();
        firstMessageString = this.stripResponseString(firstMessageString);
        String secondMessageString = commandMessageQueue.remove();
        secondMessageString = this.stripResponseString(secondMessageString);
        Matcher matcher = temperatureSoftLimitRegEx.matcher(firstMessageString);
        if (matcher.matches()) {
            this.errorType = ErrorType.SOFTLIMIT;
            this.setError(true);
            this.setSuccess(false);
            return;
        }
        matcher = softLimitRegEx.matcher(secondMessageString);
        if (matcher.matches()) {
            this.errorType = ErrorType.SOFTLIMIT;
            this.setError(true);
            this.setSuccess(false);
            return;
        }
        matcher = moveRegEx.matcher(firstMessageString);
        if (!matcher.matches() || matcher.group(1).compareToIgnoreCase(this.deviceName) != 0) {
            this.setError(true);
            this.setSuccess(false);
            this.errorType = ErrorType.INVALID_SERVER_RESPONSE;
            return;
        }
        matcher = outsideToleranceRegEx.matcher(secondMessageString);
        if (matcher.matches()) {
            this.errorType = ErrorType.OUTSIDE_TOLERANCE;
            this.setError(true);
            this.setSuccess(false);
            return;
        }
        matcher = hardLimitRegEx.matcher(secondMessageString);
        if (matcher.matches()) {
            this.errorType = ErrorType.HARDLIMIT;
            this.setError(true);
            this.setSuccess(false);
            return;
        }
        this.errorType = ErrorType.INVALID_SERVER_RESPONSE;
        this.setError(true);
        this.setSuccess(false);
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getMovePosition() {
        return this.movePosition;
    }

    public void setMovePosition(double movePosition) {
        this.movePosition = Double.toString(movePosition);
        this.generateCommandString();
    }

    public void setCommandID(long id) {
        this.commandID = id;
        this.setCommandId(id);
        this.generateCommandString();
    }

    public String getQueueCommandString() {
        return command + this.deviceName + " " + this.movePosition;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public boolean hitSoftLimit() {
        return this.errorType == ErrorType.SOFTLIMIT;
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public static enum ErrorType {
        SOFTLIMIT,
        HARDLIMIT,
        OUTSIDE_TOLERANCE,
        INVALID_SERVER_RESPONSE,
        UNKNOWN;

    }
}

