/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class DeviceSetUpperLimitCommand
extends ImmediateCommand {
    private static final String command = "DEVICE SETUPPERLIMIT ";
    private double upperLimit = 0.0;
    private String deviceName = null;

    public DeviceSetUpperLimitCommand() throws NoClientAPIInstanceException {
    }

    public DeviceSetUpperLimitCommand(String deviceName, double upperLimit) throws NoClientAPIInstanceException {
        super(command + deviceName + " " + upperLimit);
        this.deviceName = deviceName;
        this.upperLimit = upperLimit;
        this.generateCommandString();
    }

    public DeviceSetUpperLimitCommand(String deviceName, double upperLimit, ClientAPI clientApiRef) {
        super(command + deviceName + " " + upperLimit, clientApiRef);
        this.deviceName = deviceName;
        this.upperLimit = upperLimit;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName + " " + this.upperLimit);
        return command + this.deviceName + " " + this.upperLimit;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            String upperLimitStr = this.getResponse();
            int openBracketIndex = upperLimitStr.lastIndexOf("[") + 1;
            int closedBracketIndex = upperLimitStr.lastIndexOf("]");
            upperLimitStr = upperLimitStr.substring(openBracketIndex, closedBracketIndex);
            double upperLimitDbl = Double.parseDouble(upperLimitStr);
            this.setSuccess(true);
            this.setError(false);
        }
        catch (NumberFormatException notDouble) {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return command + this.deviceName + " " + this.upperLimit;
    }
}

