/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class DeviceAddCommand
extends QueuedCommand {
    protected ErrorType errorType = ErrorType.UNKNOWN;
    protected String deviceName;
    protected String handleName;
    protected DeviceType deviceType;
    protected Boolean dummyFlag = null;
    protected Boolean busyCheck = null;
    protected Double busyUpdateTime = null;
    protected Double silentUpdateTime = null;
    protected String alias = null;
    protected boolean toFile = false;

    public DeviceAddCommand(String deviceName, DeviceType deviceType, Boolean dummyFlag, Boolean busyCheck, Double busyUpdate, Double silentUpdateTime, boolean toFile, String aliasName, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceName;
        this.deviceType = deviceType;
        this.dummyFlag = dummyFlag;
        this.busyCheck = busyCheck;
        this.busyUpdateTime = busyUpdate;
        this.silentUpdateTime = silentUpdateTime;
        this.toFile = toFile;
        this.alias = aliasName;
        this.generateCommandString();
    }

    public DeviceAddCommand(String deviceName, DeviceType deviceType, Boolean dummyFlag, Boolean busyCheck, Double busyUpdate, Double silentUpdateTime, boolean toFile, String aliasName) throws NoClientAPIInstanceException {
        this(deviceName, deviceType, dummyFlag, busyCheck, busyUpdate, silentUpdateTime, toFile, aliasName, ClientAPI.getInstance());
    }

    public DeviceAddCommand(String deviceName, DeviceType deviceType, Boolean dummyFlag, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceName;
        this.deviceType = deviceType;
        this.dummyFlag = dummyFlag;
        this.generateCommandString();
    }

    public DeviceAddCommand(String deviceName, DeviceType deviceType, Boolean dummyFlag) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.deviceType = deviceType;
        this.dummyFlag = dummyFlag;
        this.generateCommandString();
    }

    public DeviceAddCommand(String aliasName, String deviceHandleName, boolean dummyFlag, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceHandleName;
        this.deviceType = DeviceType.ALIAS;
        this.dummyFlag = null;
        this.handleName = aliasName;
        this.generateCommandString();
    }

    public DeviceAddCommand(String aliasName, String deviceHandleName) throws NoClientAPIInstanceException {
        this.deviceName = aliasName;
        this.deviceType = DeviceType.ALIAS;
        this.dummyFlag = null;
        this.handleName = deviceHandleName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        String handleText;
        String dummySwitchText = "";
        String busyCheckText = "";
        String busyUpdateText = "";
        String silentUpdateText = "";
        String aliasNameText = "";
        String toFileText = this.toFile ? "-f " : "";
        String string = handleText = this.handleName == null ? "" : this.handleName;
        if (this.dummyFlag != null) {
            dummySwitchText = "-d " + (this.dummyFlag != false ? "1" : "0");
        }
        if (this.busyCheck != null) {
            busyCheckText = "-b " + (this.busyCheck != false ? "1" : "0");
        }
        if (this.busyUpdateTime != null) {
            busyUpdateText = "-u " + String.valueOf(this.busyUpdateTime);
        }
        if (this.silentUpdateTime != null) {
            silentUpdateText = "-s " + String.valueOf(this.silentUpdateTime);
        }
        if (this.alias != null) {
            aliasNameText = "-a " + this.alias;
        }
        this.setCommandString("DEVICE ADD " + (Object)((Object)this.deviceType) + " " + this.deviceName + " " + handleText + " " + dummySwitchText + busyCheckText + busyUpdateText + silentUpdateText + toFileText + aliasNameText);
        return this.getCommandString();
    }

    @Override
    protected void parseSynchronousResponse() {
        String expectedResponse;
        String response;
        this.setError(false);
        this.setSuccess(true);
        if (this.parseOneLineResponse() && !(response = this.getResponse().toLowerCase()).contains(expectedResponse = ("Added " + (Object)((Object)this.deviceType) + " " + this.deviceName).toLowerCase())) {
            this.setError(true);
            this.setSuccess(false);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public boolean isDummyFlag() {
        return this.dummyFlag;
    }

    public void setDummyFlag(boolean dummyFlag) {
        this.dummyFlag = dummyFlag;
    }

    public static enum DeviceType {
        MOTOR,
        COUNTER,
        ENV,
        ALIAS,
        Placeholder;

    }

    private static enum ErrorType {
        UNKNOWN;

    }
}

