/*
 * Decompiled with CFR 0.152.
 */
package ice.clientAPI;

import ice.exceptions.ICEBaseException;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class IceServerException
extends ICEBaseException {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("ice.ServerModel.ServerException");
    protected String name = null;
    protected String className = null;
    protected int severity = 0;
    protected long commandId = 0L;
    protected String message = null;
    protected String trace = null;
    protected Date creationTime = null;
    protected String deviceName = null;
    protected String deviceAlias = null;
    protected String deviceType = null;

    public Date getCreationTime() {
        return this.creationTime;
    }

    public IceServerException(String name, long commandId, int severity, String trace, String message, Date creationTime, String className, String deviceName, String deviceAlias, String deviceType) {
        super("IceServerException");
        this.name = name;
        this.commandId = commandId;
        this.severity = severity;
        this.trace = trace;
        this.message = message;
        this.className = className;
        this.creationTime = creationTime;
        this.deviceName = deviceName;
        this.deviceAlias = deviceAlias;
        this.deviceType = deviceType;
    }

    public static IceServerException parseXml(String xmlText) {
        try {
            String name = null;
            String trace = null;
            String message = null;
            String deviceName = null;
            String deviceAlias = null;
            String deviceType = null;
            String className = null;
            DocumentBuilderFactory docBuildFac = DocumentBuilderFactory.newInstance();
            docBuildFac.setValidating(false);
            DocumentBuilder builder = docBuildFac.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlText)));
            name = doc.getDocumentElement().getAttribute("name");
            long commandId = Integer.parseInt(doc.getDocumentElement().getAttribute("commandid"));
            int severity = Integer.parseInt(doc.getDocumentElement().getAttribute("severity"));
            trace = doc.getDocumentElement().getElementsByTagName("trace").item(0).getTextContent();
            message = doc.getDocumentElement().getElementsByTagName("message").item(0).getTextContent();
            Date creationTime = new Date(Long.valueOf(doc.getDocumentElement().getAttribute("epochcreationtime")));
            NodeList deviceNodes = doc.getDocumentElement().getElementsByTagName("device");
            if (deviceNodes.getLength() > 0) {
                deviceName = ((Element)deviceNodes.item(0)).getAttribute("name").toUpperCase();
                if (deviceName == "") {
                    deviceName = null;
                }
                if ((deviceAlias = ((Element)deviceNodes.item(0)).getAttribute("alias").toUpperCase()) == "") {
                    deviceAlias = null;
                }
                if ((deviceType = ((Element)deviceNodes.item(0)).getAttribute("type").toUpperCase()) == "") {
                    deviceType = null;
                }
            }
            return new IceServerException(name, commandId, severity, trace, message, creationTime, className, deviceName, deviceAlias, deviceType);
        }
        catch (Exception e) {
            logger.error("Error building server exception from text: " + xmlText, e);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getCommandId() {
        return this.commandId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getServerGeneratedTrace() {
        return this.trace;
    }

    @Override
    public String toString() {
        String output = super.toString();
        output = String.valueOf(output) + " created: " + this.getCreationTime().toString() + " ";
        output = String.valueOf(output) + " name: " + this.getName() + " ";
        return output;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public static enum Severity {
        NOTSET(0),
        ROUTINE(10),
        SIGNIFICANT(20),
        SERIOUS(30),
        ERROR(40),
        CRITICAL(50);

        public int level;

        private Severity(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

