/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.Controller;
import ice.Global;
import ice.clientAPI.CommandResponse;
import ice.clientAPI.MessageQueue;
import ice.clientAPI.exceptions.InconsistentClientApiInstanceException;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.MoveCommand;
import ice.data.DataSet;
import ice.data.Server;
import ice.data.tas.bt7.Instrument;
import ice.event.SendEvent;
import ice.event.SendListener;
import ice.event.communication.BroadcastMessageEvent;
import ice.event.communication.BroadcastMessageListener;
import ice.event.communication.ClientMessageEvent;
import ice.event.communication.ClientMessageListener;
import ice.event.communication.ConnectionEvent;
import ice.event.communication.ConnectionListener;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.event.communication.ErrorMessageEvent;
import ice.event.communication.ErrorMessageListener;
import ice.event.communication.ResponseMessageEvent;
import ice.event.communication.ResponseMessageListener;
import ice.event.communication.StatusChangeEvent;
import ice.event.communication.StatusChangeListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class ClientAPI
implements ClientMessageListener,
BroadcastMessageListener,
SendListener,
ErrorMessageListener,
StatusChangeListener,
DataMessageListener,
ConnectionListener,
ResponseMessageListener {
    protected Controller controller;
    private static Logger logger = Logger.getLogger("Ice.Adaptor");
    private static ClientAPI currentInstance = null;
    private static Server currServer = null;
    private int maxConnectionTries = 5;
    private int connectionTries = 0;
    private int reconnectionTries = 0;
    private int maxReconnectionTries = 5;
    protected Instrument.State lastKnownStatus = Instrument.State.unknown;
    protected String instrumentName = "";
    protected int scanPoint = 1;
    protected float scanProgress = -1.0f;
    protected int totalScanPoints = -1;
    protected Date lastStatusReceivedTime;
    private boolean clientActive = false;
    protected ConnectionEvent.ConnectionState connectionStatus = ConnectionEvent.ConnectionState.PRE_CONNECTION;
    private static final long defaultCommandWaitTimeout = 15000L;
    protected ArrayList<CommandResponse> commandsWaitingForResponse = new ArrayList();
    public static final int DEFAULT_MAX_QUEUE_LENGTH = 50;
    private int maxClientMessageQueueLength = 50;
    protected MessageQueue<String> clientMessageQueue = new MessageQueue(50);
    protected MessageQueue<String> broadcastMessageQueue = new MessageQueue(50);
    protected MessageQueue<String> errorMessageQueue = new MessageQueue(50);
    protected MessageQueue<DataMessageEvent> dataMessageQueue = new MessageQueue(50);
    protected MessageQueue<StatusChangeEvent> statusMessageQueue = new MessageQueue(50);
    protected MessageQueue<String> sentMessageQueue = new MessageQueue(50);
    protected MessageQueue<String> consoleMessageQueue = new MessageQueue(50);

    public int getMaxClientMessageQueueLength() {
        return this.maxClientMessageQueueLength;
    }

    private ClientAPI(String user, String serverHost) {
        currServer = new Server(user, serverHost);
        this.controller = Controller.getReference();
        try {
            Global.init(this.controller.getInstrument().getName());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.controller.getCommMgr().addConnectionListener(this);
        this.controller.getCommMgr().connectToServer(currServer);
        try {
            this.controller.getCommMgr().addClientListener(this);
            this.controller.getCommMgr().addMessageListener(this);
            this.controller.getCommMgr().addErrorListener(this);
            this.controller.getCommMgr().addDataMessageListener(this);
            this.controller.getCommMgr().addStatusListener(this);
            this.controller.getCommMgr().addResponseMessageListener(this);
            this.controller.getCommMgr().addSendListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ClientAPI could not add listener " + e);
        }
    }

    private ClientAPI(Controller controllerInst) {
        this.clientActive = true;
        this.controller = controllerInst;
        try {
            this.controller.getCommMgr().addClientListener(this);
            this.controller.getCommMgr().addMessageListener(this);
            this.controller.getCommMgr().addErrorListener(this);
            this.controller.getCommMgr().addDataMessageListener(this);
            this.controller.getCommMgr().addStatusListener(this);
            this.controller.getCommMgr().addResponseMessageListener(this);
            this.controller.getCommMgr().addSendListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ClientAPI could not add listener " + e);
        }
    }

    public static ClientAPI getInstance(String user, String serverHost) throws InconsistentClientApiInstanceException {
        Server server = new Server(user, serverHost);
        if (currentInstance == null) {
            currentInstance = new ClientAPI(user, serverHost);
            return currentInstance;
        }
        if (currServer.compareTo(server) != 0) {
            throw new InconsistentClientApiInstanceException(currServer.getName(), currServer.getAddress(), user, serverHost);
        }
        return currentInstance;
    }

    public static ClientAPI getInstance() throws NoClientAPIInstanceException {
        if (currentInstance != null) {
            return currentInstance;
        }
        Controller controllerInst = Controller.getReference();
        if (!controllerInst.getCommMgr().isConnected()) {
            throw new NoClientAPIInstanceException();
        }
        currentInstance = new ClientAPI(controllerInst);
        return currentInstance;
    }

    public static void close() {
        if (currentInstance != null) {
            ClientAPI.currentInstance.controller.getCommMgr().disconnect();
            ClientAPI.currentInstance.controller.getSendManager().stopRunning();
            Instrument.destroyInstance();
            ClientAPI.currentInstance.connectionStatus = ConnectionEvent.ConnectionState.LOST_CONNECTION;
            ClientAPI.currentInstance.controller = null;
        }
        currServer = null;
        currentInstance = null;
    }

    protected void finalize() {
        if (this == currentInstance) {
            ClientAPI.close();
        }
        try {
            this.controller.getCommMgr().removeErrorListener(this);
            this.controller.getCommMgr().removeMessageListener(this);
            this.controller.getCommMgr().removeResponseMessageListener(this);
            this.controller.getCommMgr().removeDataMessageListener(this);
            this.controller.getCommMgr().removeSendListener(this);
            this.controller.getCommMgr().removeStatusListener(this);
            this.controller.getCommMgr().removeClientListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("Error removing message listeners from finalized ClientAPI", e);
        }
    }

    public synchronized void waitForConnection() throws InterruptedException {
        while (!this.controller.getCommMgr().isConnected()) {
            this.wait(1000L);
        }
    }

    public synchronized boolean waitForConnection(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return this.controller.getCommMgr().isConnected();
    }

    @Override
    public void actionPerformed(ClientMessageEvent ce) {
        if (this.clientMessageQueue.remainingCapacity() == 0) {
            this.clientMessageQueue.poll();
        }
        this.clientMessageQueue.add(ce.getData());
        if (this.consoleMessageQueue.remainingCapacity() == 0) {
            this.consoleMessageQueue.poll();
        }
        this.consoleMessageQueue.add(ce.getData());
    }

    @Override
    public void actionPerformed(BroadcastMessageEvent me) {
        if (this.broadcastMessageQueue.remainingCapacity() == 0) {
            this.broadcastMessageQueue.poll();
        }
        if (this.consoleMessageQueue.remainingCapacity() == 0) {
            this.consoleMessageQueue.poll();
        }
        this.consoleMessageQueue.add(me.getData());
        this.broadcastMessageQueue.add(me.getData());
    }

    @Override
    public void actionPerformed(SendEvent se) {
        if (this.sentMessageQueue.remainingCapacity() == 0) {
            this.sentMessageQueue.poll();
        }
        this.sentMessageQueue.add(se.getMessage());
    }

    @Override
    public void actionPerformed(ErrorMessageEvent ee) {
        if (this.errorMessageQueue.remainingCapacity() == 0) {
            this.errorMessageQueue.poll();
        }
        this.errorMessageQueue.add(ee.getMessage());
        if (this.consoleMessageQueue.remainingCapacity() == 0) {
            this.consoleMessageQueue.poll();
        }
        this.consoleMessageQueue.add(ee.getMessage());
    }

    @Override
    public void statusChanged(StatusChangeEvent ce) {
        if (this.statusMessageQueue.remainingCapacity() == 0) {
            this.statusMessageQueue.poll();
        }
        this.statusMessageQueue.add(ce);
        this.lastKnownStatus = ce.getState();
        this.scanPoint = ce.getScanPoint();
        this.scanProgress = ce.getScanProgress().floatValue();
        this.instrumentName = ce.getInstrumentName();
        this.lastStatusReceivedTime = ce.getTime();
        this.totalScanPoints = ce.getTotalScanPoints();
    }

    @Override
    public void actionPerformed(DataMessageEvent de) {
        if (this.dataMessageQueue.remainingCapacity() == 0) {
            this.dataMessageQueue.poll();
        }
        this.dataMessageQueue.add(de);
    }

    public boolean sendMessage(String message) {
        try {
            this.controller.getCommMgr().sendMessage(message);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void receiveConnectionEvent(ConnectionEvent ce) {
        this.connectionStatus = ce.getConnectionState();
        if (this.clientActive) {
            return;
        }
        if (ce.getConnectionState() == ConnectionEvent.ConnectionState.INITIAL_CONNECTION_FAILURE) {
            if (this.maxConnectionTries > ++this.connectionTries) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.controller.getCommMgr().connectToServer(currServer);
            } else {
                System.exit(1);
            }
        } else if (ce.getConnectionState() == ConnectionEvent.ConnectionState.LOST_CONNECTION) {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.controller.getCommMgr().reconnect();
        } else if (ce.getConnectionState() == ConnectionEvent.ConnectionState.RECONNECTION_FAILURE) {
            if (this.reconnectionTries < this.maxReconnectionTries) {
                ++this.reconnectionTries;
                try {
                    Thread.sleep(1500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.controller.getCommMgr().reconnect();
            }
            System.out.println("Reconnection failure");
            logger.error("Reconnection failure");
        } else if (ce.getConnectionState() == ConnectionEvent.ConnectionState.INITIAL_CONNECTION_SUCCESS) {
            this.connectionTries = 0;
            this.notifyAll();
        } else if (ce.getConnectionState() == ConnectionEvent.ConnectionState.RECONNECTION_SUCCESS) {
            this.reconnectionTries = 0;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void actionPerformed(ResponseMessageEvent rm) {
        ArrayList<CommandResponse> removeList = new ArrayList<CommandResponse>();
        for (CommandResponse cr : this.commandsWaitingForResponse) {
            if (!rm.getMesage().startsWith(cr.getLabel())) continue;
            CommandResponse commandResponse = cr;
            synchronized (commandResponse) {
                cr.setResponseString(rm.getMesage().substring(cr.getLabel().length() + 1));
                cr.notifyAll();
                removeList.add(cr);
            }
        }
        this.commandsWaitingForResponse.removeAll(removeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResponse synchronousAskCommand(String commandString) {
        CommandResponse askCmdResponse = new CommandResponse(commandString, CommandResponse.CommandTypes.IMMEDIATE);
        this.commandsWaitingForResponse.add(askCmdResponse);
        this.errorMessageQueue.clear();
        this.sendMessage("ASK " + askCmdResponse.generateLabel() + " " + commandString);
        try {
            CommandResponse commandResponse = askCmdResponse;
            synchronized (commandResponse) {
                askCmdResponse.wait(15000L);
            }
        }
        catch (Exception e) {
            System.out.println("Error waiting in synchronousASK " + e.toString());
            logger.error("Error waiting for Ask response", e);
            askCmdResponse.setError(true);
            this.commandsWaitingForResponse.remove(askCmdResponse);
            askCmdResponse.setErrorString(this.errorMessageQueue.getContentsAsString());
        }
        return askCmdResponse;
    }

    public void waitOnCommandId(long commandId) {
        this.controller.getServerQueue().waitOnCommandId(commandId);
    }

    public boolean stackContainsID(long id) {
        String resp = this.synchronousAskCommand("Stack ContainsID " + String.valueOf(id)).getResponseString();
        return resp != null && resp.startsWith("Stack ContainsID True:");
    }

    public CommandResponse synchronousIssueQueuedCommand(String commandString) {
        CommandResponse cmdResponse = this.synchronousAskCommand("Stack Add \"" + commandString + "\"");
        cmdResponse.setCommandType(CommandResponse.CommandTypes.QUEUED);
        return cmdResponse;
    }

    public CommandResponse synchronousCommand(String commandString) {
        if (commandString == null || commandString.length() == 0) {
            CommandResponse errorResponse = new CommandResponse("");
            errorResponse.setError(true);
            errorResponse.setErrorString("Error: No command sent to run.");
            errorResponse.setResponseString("Error: No command sent to run.");
            return errorResponse;
        }
        this.clientMessageQueue.clear();
        this.broadcastMessageQueue.clear();
        this.consoleMessageQueue.clear();
        CommandResponse cmdResponse = this.synchronousAskCommand("Stack Add \"" + commandString + "\"");
        long id = Integer.valueOf(cmdResponse.getResponseString().substring("Queued (commandID=".length(), cmdResponse.getResponseString().indexOf(41))).intValue();
        cmdResponse.setCommandID(id);
        while (this.stackContainsID(id)) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cmdResponse.setDataSet(this.controller.getDataManager().getCurrentDataSet());
        cmdResponse.setResponseString(this.consoleMessageQueue.getContentsAsString());
        cmdResponse.setErrorString(this.errorMessageQueue.getContentsAsString());
        return cmdResponse;
    }

    public String getInstrumentName() {
        return this.controller.getInstrument().getName();
    }

    public long getCurrentScanPoint() {
        return this.controller.getInstrument().getCurrScanPnt();
    }

    public long getTotalScanPoints() {
        return this.controller.getInstrument().getTotalScanPnts();
    }

    public Date getLastStatusReceivedTime() {
        return this.lastStatusReceivedTime;
    }

    public boolean isConnected() {
        return this.controller.getCommMgr().isConnected();
    }

    public String getRunningScanFromServer() {
        CommandResponse cr = this.synchronousAskCommand("Scan Getrunningscan");
        return cr.getResponseString().substring("Current running scan: ".length());
    }

    public String getDeviceValue(String deviceName) {
        return this.controller.getDevice(deviceName).getCurrValue();
    }

    public CommandResponse runScanSynchronous(String scanName) {
        return this.synchronousCommand("SCAN RUNSCAN " + scanName);
    }

    public CommandResponse runScanAsynchronous(String scanName) {
        return this.synchronousIssueQueuedCommand("SCAN RUNSCAN " + scanName);
    }

    public String getLastData() {
        CommandResponse cr = this.synchronousAskCommand("SCAN GETSCANDATA");
        return cr.getResponseString();
    }

    public void addResponseMessageListener(ResponseMessageListener rml, String label) throws ICEListenerListExceptionBase {
        this.controller.getCommMgr().addResponseMessageListener(rml, label);
    }

    public boolean removeResponseMessageListener(ResponseMessageListener rml, String label) {
        return this.controller.getCommMgr().removeResponseMessageListener(rml, label);
    }

    public boolean removeResponseMessageListener(ResponseMessageListener rml) {
        return this.controller.getCommMgr().removeResponseMessageListener(rml);
    }

    public MessageQueue<String> getConsoleMessages(long commandID) {
        return this.consoleMessageQueue.getMessagesForCommandId(commandID);
    }

    public MessageQueue<String> getConsoleMessagesForAbsCommandID(long commandID) {
        return this.consoleMessageQueue.getMessagesForAbsCommandId(commandID);
    }

    public MessageQueue<String> getConsoleMessages() {
        return this.consoleMessageQueue;
    }

    public MessageQueue<String> getErrorMessagesForAbsCommandID(long commandID) {
        return this.errorMessageQueue.getMessagesForAbsCommandId(commandID);
    }

    public MessageQueue<String> getErrorMessages(long commandID) {
        return this.errorMessageQueue.getMessagesForCommandId(commandID);
    }

    public MessageQueue<String> getErrorMessages() {
        return this.errorMessageQueue;
    }

    public DataSet getDataSetByCommandId(long commandID) {
        return this.controller.getDataManager().getDataSetByCommandId(commandID);
    }

    public static void main(String[] s) {
        String cmd = "";
        CommandResponse resp = null;
        boolean exit = false;
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        try {
            ClientAPI adaptor = ClientAPI.getInstance("testUser", "192.168.237.130");
            try {
                adaptor.waitForConnection();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("ICE adaptor testing program.");
            MoveCommand readCmd = new MoveCommand("SansVelSel", 3000.0);
            try {
                readCmd.run();
            }
            catch (ICEListenerListExceptionBase e1) {
                e1.printStackTrace();
            }
            System.out.println(readCmd.getResponse());
            System.out.println(String.valueOf(readCmd.getResponse()) + "; success: " + String.valueOf(readCmd.isSuccess()) + " Error: " + String.valueOf(readCmd.isError()));
            readCmd.setDeviceName("SansVelSel");
            readCmd.setMovePosition(55.0);
            readCmd.setCommandID(55L);
            System.out.println(readCmd.getQueueCommandString());
            try {
                readCmd.run();
            }
            catch (ICEListenerListExceptionBase e1) {
                e1.printStackTrace();
            }
            System.out.println(String.valueOf(readCmd.getCommandId()) + ":" + readCmd.getDeviceName() + ":" + readCmd.getMovePosition());
            while (!exit) {
                System.out.print(">");
                try {
                    cmd = br.readLine();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cmd.equalsIgnoreCase("exit")) {
                    exit = true;
                    continue;
                }
                resp = adaptor.synchronousCommand(cmd);
            }
            ClientAPI.close();
        }
        catch (InconsistentClientApiInstanceException ICAPIe) {
            System.out.println("Error getting a client api instance.");
        }
    }
}

