/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon.xrootd;

import hep.io.root.daemon.xrootd.ConnectionDescriptor;
import hep.io.root.daemon.xrootd.ResponseHandler;
import hep.io.root.daemon.xrootd.Session;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class Multiplexor
implements Runnable {
    private static final int MAX_IDLE = 5000;
    private static Logger logger = Logger.getLogger("hep.io.root.daemon.xrootd");
    private static Timer timer;
    private static Map connectionMap;
    private boolean socketClosed = false;
    private Socket socket;
    private Thread thread;
    private ConnectionDescriptor descriptor;
    private Message message;
    private Response response;
    private Map responseMap = new HashMap();
    private TimerTask idleTimer;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(20);
    private DataOutputStream out = new DataOutputStream(this.bos);
    private BitSet handles = new BitSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Multiplexor allocate(ConnectionDescriptor desc) throws IOException {
        Multiplexor m;
        Map map = connectionMap;
        synchronized (map) {
            m = (Multiplexor)connectionMap.get(desc);
            if (m == null) {
                m = new Multiplexor(desc);
                connectionMap.put(desc, m);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Short allocate(Session session) {
        int handle;
        BitSet bitSet = this.handles;
        synchronized (bitSet) {
            handle = this.handles.nextClearBit(0);
            this.handles.set(handle);
            if (this.idleTimer != null) {
                this.idleTimer.cancel();
                this.idleTimer = null;
            }
        }
        logger.fine(this.descriptor + " Add session " + handle);
        return new Short((short)handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(Session session) {
        int handle;
        BitSet bitSet = this.handles;
        synchronized (bitSet) {
            handle = session.getHandle().intValue();
            this.handles.clear(handle);
            if (this.handles.cardinality() == 0) {
                this.idleTimer = new TimerTask(){

                    public void run() {
                        Multiplexor.this.close();
                    }
                };
                timer.schedule(this.idleTimer, 5000L);
            }
        }
        logger.fine(this.descriptor + " Free session " + handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Map map = connectionMap;
        synchronized (map) {
            BitSet bitSet = this.handles;
            synchronized (bitSet) {
                if (this.handles.cardinality() > 0) {
                    return;
                }
            }
            connectionMap.remove(this.descriptor);
        }
        logger.fine(this.descriptor + " Closing connection");
        try {
            this.socketClosed = true;
            this.socket.close();
        }
        catch (IOException x) {
            logger.log(Level.WARNING, this.descriptor + " Error while closing socket", x);
        }
    }

    private Multiplexor(ConnectionDescriptor desc) throws IOException {
        logger.fine(desc + " Opening connection");
        this.descriptor = desc;
        int port = desc.getPort();
        if (port == -1) {
            port = 1094;
        }
        this.socket = new Socket(desc.getAddress(), port);
        try {
            this.bos.reset();
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(4);
            this.out.writeInt(2012);
            this.out.flush();
            this.bos.writeTo(this.socket.getOutputStream());
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            int check = in.readInt();
            if (check == 8) {
                throw new IOException("rootd protocol not supported");
            }
            if (check != 0) {
                throw new IOException("Unexpected initial handshake response");
            }
            int rlen = in.readInt();
            if (rlen != 8) {
                throw new IOException("Unexpected initial handshake length");
            }
            int protocol = in.readInt();
            int mode = in.readInt();
            logger.fine(desc + " Logging in protocol=" + protocol + " mode=" + mode);
            this.message = new Message(this.socket.getOutputStream());
            this.bos.reset();
            this.out.writeInt(12345);
            byte[] user = desc.getUserName().getBytes();
            for (int i = 0; i < 8; ++i) {
                this.out.writeByte(i < user.length ? user[i] : 0);
            }
            this.out.writeByte(0);
            this.out.writeByte(0);
            this.out.writeByte(130);
            this.out.writeByte(0);
            this.out.flush();
            this.sendMessage(new Short(0), 3007, this.bos.toByteArray());
            this.response = new Response(in);
            this.response.read();
            int dlen = this.response.getLength();
            DataInputStream rin = this.response.getInputStream();
            for (int i = 0; i < dlen; ++i) {
                rin.read();
            }
            this.thread = new Thread((Runnable)this, "XrootdReader-" + desc.getAddress() + ":" + port);
            this.thread.setDaemon(true);
            this.thread.start();
            logger.fine(desc + " Success");
        }
        catch (IOException x) {
            this.socket.close();
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            try {
                int status;
                while (true) {
                    int seconds;
                    byte[] message;
                    DataInputStream in;
                    ResponseHandler handler;
                    Multiplexor multiplexor = this;
                    if (multiplexor.thread.currentThread().isInterrupted()) break block13;
                    this.response.read();
                    status = this.response.getStatus();
                    Short handle = this.response.getHandle();
                    Map map = this.responseMap;
                    synchronized (map) {
                        handler = (ResponseHandler)this.responseMap.get(handle);
                    }
                    if (handler == null && status != 4001) {
                        throw new IOException(this.descriptor + " No handler found for handle " + handle);
                    }
                    if (status == 4003) {
                        in = this.response.getInputStream();
                        int rc = in.readInt();
                        message = new byte[this.response.getLength() - 4];
                        in.readFully(message);
                        handler.handleError(new IOException("Xrootd error " + rc + ": " + new String(message, 0, message.length - 1)));
                        continue;
                    }
                    if (status == 4005) {
                        in = this.response.getInputStream();
                        seconds = in.readInt();
                        message = new byte[this.response.getLength() - 4];
                        in.readFully(message);
                        logger.info(this.descriptor + " wait: " + new String(message, 0, message.length) + " seconds=" + seconds);
                        TimerTask task = new TimerTask(){

                            public void run() {
                                try {
                                    logger.fine(Multiplexor.this.descriptor + " resending message");
                                    handler.sendMessage();
                                }
                                catch (IOException x) {
                                    Multiplexor.this.handleSocketException(x);
                                }
                            }
                        };
                        timer.schedule(task, 1000 * seconds);
                        continue;
                    }
                    if (status == 4006) {
                        in = this.response.getInputStream();
                        seconds = in.readInt();
                        message = new byte[this.response.getLength() - 4];
                        in.readFully(message);
                        logger.info(this.descriptor + " waitresp: " + new String(message, 0, message.length) + " seconds=" + seconds);
                        continue;
                    }
                    if (status == 4004) {
                        in = this.response.getInputStream();
                        int port = in.readInt();
                        message = new byte[this.response.getLength() - 4];
                        in.readFully(message);
                        String host = new String(message, 0, message.length);
                        logger.info(this.descriptor + " redirect: " + host + " " + port);
                        handler.handleRedirect(host, port);
                        continue;
                    }
                    if (status == 4001) {
                        in = this.response.getInputStream();
                        int code = in.readInt();
                        if (code == 5008) {
                            in.readInt();
                            continue;
                        }
                        throw new IOException("Xrootd: Unimplemented asycn message received: " + code);
                    }
                    if (status != 0 && status != 4000) break;
                    handler.handleResponse(this.response);
                }
                throw new IOException("Xrootd: Unimplemented status received: " + status);
            }
            catch (IOException x) {
                this.handleSocketException(x);
            }
        }
    }

    private void handleSocketException(IOException x) {
        if (!this.socketClosed) {
            this.socketClosed = true;
            logger.log(Level.WARNING, "Unexpected IO exception on socket", x);
            ArrayList waiting = new ArrayList(this.responseMap.values());
            Iterator i = waiting.iterator();
            while (i.hasNext()) {
                ResponseHandler handler = (ResponseHandler)i.next();
                handler.handleSocketError(x);
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerResponseHandler(Short handle, ResponseHandler handler) {
        Map map = this.responseMap;
        synchronized (map) {
            this.responseMap.put(handle, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterResponseHandler(Short handle) {
        Map map = this.responseMap;
        synchronized (map) {
            this.responseMap.remove(handle);
        }
    }

    void sendMessage(Short handle, int message) throws IOException {
        this.sendMessage(handle, message, null);
    }

    void sendMessage(Short handle, int message, byte[] extra) throws IOException {
        this.sendMessage(handle, message, extra, null);
    }

    void sendMessage(Short handle, int message, byte[] extra, String string) throws IOException {
        if (this.socketClosed) {
            throw new IOException("Socket closed");
        }
        this.message.send(handle, message, extra, string);
    }

    static {
        if (System.getProperty("debugRootDaemon") != null) {
            logger.setLevel(Level.FINER);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(Level.FINER);
            logger.addHandler(handler);
        }
        timer = new Timer("XrootdReader-timer", true);
        connectionMap = new HashMap();
    }

    static class Response {
        private DataInputStream in;
        private Short handle;
        private int status;
        private int dataLength;

        private Response(DataInputStream in) {
            this.in = in;
        }

        private int read() throws IOException {
            this.handle = new Short(this.in.readShort());
            this.status = this.in.readUnsignedShort();
            this.dataLength = this.in.readInt();
            logger.finer("<-" + this.handle + " " + this.status + " " + this.dataLength);
            return this.status;
        }

        int getStatus() {
            return this.status;
        }

        int getLength() {
            return this.dataLength;
        }

        Short getHandle() {
            return this.handle;
        }

        DataInputStream getInputStream() {
            return this.in;
        }
    }

    private static class Message {
        private OutputStream data;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(this.bos);

        Message(OutputStream data) {
            this.data = data;
        }

        synchronized void send(Short handle, int message, byte[] extra, String string) throws IOException {
            logger.finer("->" + message);
            this.bos.reset();
            this.out.writeShort(handle.shortValue());
            this.out.writeShort(message);
            for (int i = 0; i < 16; ++i) {
                this.out.writeByte(extra == null ? 0 : extra[i]);
            }
            if (string == null) {
                this.out.writeInt(0);
            } else {
                byte[] bytes = string.getBytes();
                this.out.writeInt(bytes.length);
                this.out.write(bytes);
            }
            this.out.flush();
            this.bos.writeTo(this.data);
        }
    }
}

