/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.daemon;

import hep.io.root.daemon.DaemonInputStream;
import hep.io.root.daemon.RootProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;

public class RootURLConnection
extends URLConnection {
    private String username;
    private String password;
    private String auth;
    private int bufferSize = 0;
    private DaemonInputStream connection;
    private long date;
    private long fSize;
    private static Logger logger = Logger.getLogger("hep.io.root.daemon");

    RootURLConnection(URL url) {
        super(url);
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.connection;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.auth == null) {
            this.auth = System.getProperty("root.scheme");
        }
        if (this.auth != null && this.auth.equalsIgnoreCase("anonymous")) {
            this.username = "anonymous";
            try {
                this.password = System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (SecurityException x) {
                this.password = "freehep-user@freehep.org";
            }
        }
        if (this.username == null) {
            this.username = System.getProperty("root.user");
        }
        if (this.password == null) {
            this.password = System.getProperty("root.password");
        }
        if ((this.password == null || this.username == null) && this.getAllowUserInteraction()) {
            PasswordAuthentication pa;
            int port = this.url.getPort();
            if (port == -1) {
                port = 1094;
            }
            if ((pa = Authenticator.requestPasswordAuthentication(this.url.getHost(), null, port, "root", "Username/Password required", this.auth)) != null) {
                this.username = pa.getUserName();
                this.password = new String(pa.getPassword());
            }
        }
        if (this.password == null || this.username == null) {
            throw new IOException("Authorization Required");
        }
        logger.fine("Opening rootd connection to: " + this.url);
        RootProtocol rp = new RootProtocol(this.url.getHost(), this.url.getPort(), this.auth, this.username, this.password);
        if (this.bufferSize != 0) {
            rp.setBufferSize(this.bufferSize);
        }
        rp.open(this.url.getFile());
        String[] fstat = rp.fstat();
        this.fSize = Long.parseLong(fstat[1]);
        this.date = Long.parseLong(fstat[3]) * 1000L;
        this.connection = rp.openStream(this.fSize);
        this.connected = true;
    }

    public int getContentLength() {
        if (this.connection == null) {
            return -1;
        }
        return (int)this.fSize;
    }

    public long getLastModified() {
        if (this.connection == null) {
            return -1L;
        }
        return this.date;
    }

    public long getDate() {
        return this.getLastModified();
    }

    public void setRequestProperty(String key, String value) {
        if (key.equalsIgnoreCase("user")) {
            this.username = value;
        } else if (key.equalsIgnoreCase("password")) {
            this.password = value;
        } else if (key.equalsIgnoreCase("scheme")) {
            this.auth = value;
        } else if (key.equalsIgnoreCase("bufferSize")) {
            this.bufferSize = Integer.parseInt(value);
        }
    }
}

