/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.RootMember;
import hep.io.root.RootObject;
import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootClassLoader;
import hep.io.root.core.StreamerInfo;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class GenericRootClass
extends BasicRootClass {
    private static final Type rootObjectType = new ObjectType("hep.io.root.RootObject");
    private Class javaClass;
    private Class proxyClass;
    private RootClassFactory factory;
    private StreamerInfo streamerInfo;
    private String name;

    public GenericRootClass(String name, StreamerInfo info) {
        this.streamerInfo = info;
        this.name = name;
    }

    public int getCheckSum() {
        return this.streamerInfo.getCheckSum();
    }

    public String getClassName() {
        return this.name;
    }

    public Class getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = this.getClass("hep.io.root.interfaces." + this.name);
        }
        return this.javaClass;
    }

    public Type getJavaType() {
        return new ObjectType("hep.io.root.interfaces." + this.name);
    }

    public RootMember[] getMembers() {
        return this.streamerInfo.getMembers();
    }

    public RootClass[] getSuperClasses() {
        return this.streamerInfo.getSuperClasses();
    }

    public int getVersion() {
        return this.streamerInfo.getVersion();
    }

    public boolean instanceOf(RootClass superClass) {
        if (superClass == this) {
            return true;
        }
        RootClass[] classes = this.getSuperClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].instanceOf(superClass)) continue;
            return true;
        }
        return false;
    }

    public AbstractRootObject newInstance() {
        try {
            return (AbstractRootObject)this.getProxyClass().newInstance();
        }
        catch (Exception t) {
            throw new RuntimeException("Error while instantiating " + this.name, t);
        }
    }

    StreamerInfo getStreamerInfo() {
        return this.streamerInfo;
    }

    void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp) {
        il.append(new LDC(cp.addString(this.name)));
        il.append(factory.createInvoke("hep.io.root.core.RootInput", "readObject", rootObjectType, new Type[]{Type.STRING}, (short)185));
        il.append(factory.createCast(rootObjectType, this.getJavaType()));
    }

    void generateReadPointerCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp) {
        il.append(factory.createInvoke("hep.io.root.core.RootInput", "readObjectRef", rootObjectType, Type.NO_ARGS, (short)185));
        il.append(factory.createCast(rootObjectType, this.getJavaType()));
    }

    void resolve(RootClassFactory factory) throws RootClassNotFound {
        this.factory = factory;
        this.streamerInfo.resolve(factory);
    }

    private Class getClass(String fullName) {
        try {
            RootClassLoader loader = this.factory.getLoader();
            Class<?> result = loader.loadClass(fullName);
            if (!RootObject.class.isAssignableFrom(result)) {
                throw new RuntimeException("Invalid class " + this.name);
            }
            return result;
        }
        catch (ClassNotFoundException x) {
            throw new RuntimeException("Error loading " + this.name, x);
        }
    }

    private Class getProxyClass() {
        if (this.proxyClass == null) {
            this.proxyClass = this.getClass("hep.io.root.proxy." + this.name);
        }
        return this.proxyClass;
    }
}

