/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.Hbook;
import hep.io.hbook.HbookObject;

public class OneDHistogram
extends HbookObject {
    private float max;
    private float min;
    private float mean;
    private float rms;
    private float equiv;
    private int nent;
    private int bins;
    private int id;
    private int idx;

    OneDHistogram(CompositeHbookObject parent, String name, int id, int idx, int bins, float min, float max, int nent, float mean, float rms, float equiv) {
        super(parent, name);
        this.id = id;
        this.idx = idx;
        this.min = min;
        this.max = max;
        this.bins = bins;
        this.mean = mean;
        this.rms = rms;
        this.equiv = equiv;
        this.nent = nent;
    }

    void close() {
        super.close();
        if (this.id >= 0) {
            Hbook.delete(this.id);
        }
        this.id = -1;
    }

    public void finalize() {
        this.close();
    }

    public String toString() {
        String result = "1D Histogram: " + this.idx + " " + this.getName() + " (min=" + this.min + " max=" + this.max + " bins=" + this.bins + ")";
        return result;
    }

    public float getXMin() {
        return this.min;
    }

    public float getXMax() {
        return this.max;
    }

    public float getXMean() {
        return this.mean;
    }

    public float getXRMS() {
        return this.rms;
    }

    public int getXNBins() {
        return this.bins;
    }

    public float getXEquivBinEntries() {
        return this.equiv;
    }

    public int getNEntries() {
        return this.nent;
    }

    public double[] getBins() {
        return Hbook.Hist1DData(this.id, this.bins);
    }

    public double[] getErrors() {
        return Hbook.Hist1DErrors(this.id, this.bins);
    }

    public int id() {
        return this.idx;
    }
}

