/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.util.comparison;

import hep.aida.ext.IComparisonData;
import hep.aida.util.comparison.AbstractComparisonAlgorithm;

public class KolmogorovSmirnovComparisonAlgorithm
extends AbstractComparisonAlgorithm {
    private static final String[] names = new String[]{"KolmogorovSmirnov", "KS"};
    private static final int dType = 2;
    private static final int eType = 1;

    public KolmogorovSmirnovComparisonAlgorithm() {
        super(2, 1);
    }

    public String[] algorithmNames() {
        return names;
    }

    public double quality(IComparisonData d1, IComparisonData d2) {
        double distance = this.evaluateDistance(d1, d2);
        double entries1 = this.entries(d1);
        double entries2 = this.entries(d2);
        double p = this.probability(distance *= Math.sqrt(entries1 * entries2 / (entries1 + entries2)));
        return p;
    }

    protected double evaluateDistance(IComparisonData d1, IComparisonData d2) {
        int nPoints1 = d1.nPoints();
        int nPoints2 = d2.nPoints();
        double[] cumulativeWeights1 = this.getCumulativeArray(d1);
        double[] cumulativeWeights2 = this.getCumulativeArray(d2);
        double D2 = 0.0;
        double data1 = 0.0;
        double data2 = 0.0;
        double cumulative1 = 0.0;
        double cumulative2 = 0.0;
        double d = 0.0;
        int j1 = 0;
        int j2 = 0;
        boolean flag1 = true;
        boolean flag2 = true;
        do {
            boolean advance1 = false;
            boolean advance2 = false;
            data1 = d1.value(j1);
            if (data1 <= (data2 = d2.value(j2))) {
                cumulative1 = cumulativeWeights1[j1];
                advance1 = true;
            }
            if (data1 >= data2) {
                cumulative2 = cumulativeWeights2[j2];
                advance2 = true;
            }
            if ((d = Math.abs(cumulative1 - cumulative2)) > D2) {
                D2 = d;
            }
            if (j1 == nPoints1 - 1) {
                flag1 = false;
            }
            if (j2 == nPoints2 - 1) {
                flag2 = false;
            }
            if (advance1) {
                if (flag1) {
                    ++j1;
                }
            } else if (!flag2 && flag1) {
                ++j1;
            }
            if (advance2) {
                if (!flag2) continue;
                ++j2;
                continue;
            }
            if (flag1 || !flag2) continue;
            ++j2;
        } while (flag1 || flag2);
        return D2;
    }

    protected double probability(double distance) {
        double prob = distance;
        double p = 0.0;
        if (prob < 0.2) {
            return 1.0;
        }
        if (prob > 1.0) {
            double[] fj2 = new double[]{-2.0, -8.0, -18.0, -32.0, -50.0};
            double s = -2.0;
            double p2 = prob * prob;
            for (int i = 0; i < 5; ++i) {
                s *= -1.0;
                double c = fj2[i] * p2;
                if (c < -100.0) {
                    return p;
                }
                p += s * Math.exp(c);
            }
            return p;
        }
        double[] cons = new double[]{-1.233700550136, -11.10330496, -30.84251376};
        double sqr2pi = Math.sqrt(Math.PI * 2);
        double zinv = 1.0 / prob;
        double a = sqr2pi * zinv;
        double zinv2 = zinv * zinv;
        for (int i = 0; i < 3; ++i) {
            double arg = cons[i] * zinv2;
            if (arg < -30.0) continue;
            p += Math.exp(arg);
        }
        p = 1.0 - a * p;
        return p;
    }
}

