/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.dev.IAddable;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IOnDemandStore;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.xml.AIDAEntityResolver;
import hep.aida.ref.xml.AidaHandlerImpl;
import hep.aida.ref.xml.AidaObjectProxy;
import hep.aida.ref.xml.AidaParser;
import hep.aida.ref.xml.AidaWBXMLParser;
import hep.aida.ref.xml.AidaXMLWriter;
import hep.aida.ref.xml.AidaZipXMLWriter;
import hep.aida.util.Addable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AidaXMLStore
implements IOnDemandStore {
    protected de.schlichtherle.io.File root;
    protected boolean createNew = false;
    protected boolean useProxies = false;
    int n = 0;

    public boolean isReadOnly() {
        return false;
    }

    public void read(IDevTree tree, String path) throws IllegalArgumentException, IOException {
        if (this.root == null) {
            return;
        }
        de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)this.root, path = path.startsWith("/") ? path.substring(1) : path);
        if (file.isDirectory()) {
            tree.mkdirs("/" + path);
            de.schlichtherle.io.File[] files = (de.schlichtherle.io.File[])file.listFiles();
            int rootLength = this.root.getPath().length() + 1;
            for (int i = 0; i < files.length; ++i) {
                String tmpPath = files[i].getInnerEntryName();
                if (tmpPath == null) {
                    tmpPath = files[i].getPath().substring(rootLength);
                }
                if (files[i].isDirectory()) {
                    tree.mkdirs("/" + tmpPath);
                    ++this.n;
                    continue;
                }
                this.read(tree, "/" + tmpPath);
            }
            tree.hasBeenFilled("/" + path);
        } else if (this.useProxies) {
            String treePath = file.getInnerEntryName();
            if (treePath == null) {
                treePath = file.getPath();
            }
            String type = "IManagedObject";
            int index = treePath.lastIndexOf(".");
            if (index >= 0) {
                type = treePath.substring(index + 1);
                treePath = treePath.substring(0, index);
            }
            IManagedObject mo = AidaObjectProxy.createProxy(this, path, type);
            tree.add(AidaUtils.parseDirName(treePath), mo);
        } else {
            FileInputStream in = new FileInputStream(file);
            try {
                this.parse(tree, false, in, true);
                ++this.n;
            }
            catch (Exception x) {
                IOException xx = new IOException("Error reading " + tree.storeName() + " " + path);
                xx.initCause(x);
                throw xx;
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
        }
    }

    public void read(IDevTree tree, Map optionsMap, boolean readOnly, boolean createNew) throws IOException {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(tree.storeName());
        file.isDirectory();
        this.createNew = createNew;
        boolean exists = file.exists();
        if (!(exists || !readOnly && createNew)) {
            throw new IOException("File " + file + " does not exist.");
        }
        if (exists && !readOnly && !createNew && !file.canWrite()) {
            throw new IOException("File " + file + " is a read-only file.");
        }
        if (exists) {
            readOnly |= file.canWrite();
            if (file.isFile()) {
                this.root = null;
                FileInputStream in = new FileInputStream(file);
                try {
                    String validateString = (String)optionsMap.get("validate");
                    boolean validate = validateString == null || validateString.equalsIgnoreCase("true");
                    this.parse(tree, true, in, validate);
                }
                catch (Exception x) {
                    IOException xx = new IOException("Error reading " + tree.storeName());
                    xx.initCause(x);
                    System.err.println(x);
                    x.printStackTrace();
                    throw xx;
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
            } else {
                this.root = file;
                this.useProxies = this.toBoolean(optionsMap, "useProxies", true);
                this.read(tree, "/");
            }
        }
    }

    public void commit(IDevTree tree, Map optionsMap) throws IOException {
        String cString;
        String createString = (String)optionsMap.get("createNew");
        if (createString != null && createString.equalsIgnoreCase("true")) {
            this.createNew = true;
        }
        boolean zip = (cString = (String)optionsMap.get("compress")) != null && cString.equalsIgnoreCase("zip");
        boolean compress = cString == null || cString.equalsIgnoreCase("yes") || cString.equalsIgnoreCase("true") || cString.equalsIgnoreCase("gzip");
        String bString = (String)optionsMap.get("binary");
        boolean binary = bString != null && (bString.equalsIgnoreCase("yes") || bString.equalsIgnoreCase("true"));
        String[] skip = null;
        if (optionsMap.get("skip") != null) {
            skip = AidaUtils.parseString((String)optionsMap.get("skip"));
        }
        File f = new File(tree.storeName());
        if (this.createNew && f.exists() && !f.isDirectory()) {
            f.delete();
        }
        this.commit(tree, new de.schlichtherle.io.File(tree.storeName()), skip, zip, compress, binary);
    }

    public void commit(ITree tree, de.schlichtherle.io.File file, String[] skip, boolean zip, boolean compress, boolean binary) throws IOException {
        if (file.isDirectory() || zip) {
            AidaZipXMLWriter zw = new AidaZipXMLWriter(file, binary, skip);
            zw.toXML(tree);
            zw.close();
        } else {
            FilterOutputStream os2 = new FileOutputStream(file);
            if (compress) {
                os2 = new GZIPOutputStream(os2);
            }
            AidaXMLWriter out = binary ? new AidaXMLWriter(new DataOutputStream(new BufferedOutputStream(os2))) : new AidaXMLWriter(new BufferedWriter(new OutputStreamWriter(os2)));
            out.toXML(tree);
            out.close();
        }
    }

    public void close() {
        this.root = null;
    }

    IManagedObject readManagedObject(String path) throws IOException {
        Addable addable = new Addable();
        de.schlichtherle.io.File file = new de.schlichtherle.io.File((File)this.root, path);
        FileInputStream in = new FileInputStream(file);
        try {
            this.parse(addable, false, in, true);
            ++this.n;
        }
        catch (Exception x) {
            IOException xx = new IOException("Error creating managed object for " + path);
            xx.initCause(x);
            throw xx;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return addable.object();
    }

    protected void parse(IAddable tree, boolean markAsFilled, InputStream in, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        byte[] magic = new byte[4];
        PushbackInputStream pin = new PushbackInputStream(in, magic.length);
        int b = pin.read(magic);
        if (b != magic.length) {
            throw new IOException("Unexpected EOF");
        }
        pin.unread(magic);
        if ((magic[0] & 0xFF) == 31 && (magic[1] & 0xFF) == 139) {
            b = (pin = new PushbackInputStream(new GZIPInputStream(pin), magic.length)).read(magic);
            if (b != magic.length) {
                throw new IOException("Unexpected EOF");
            }
            pin.unread(magic);
        }
        in = pin;
        boolean binary = (magic[0] & 0xFF) == 3 && (magic[1] & 0xFF) == 0 && (magic[2] & 0xFF) == 0 && (magic[3] & 0xFF) == 106;
        in = new BufferedInputStream(in);
        AidaHandlerImpl handler = new AidaHandlerImpl(tree, markAsFilled);
        if (binary) {
            AidaWBXMLParser parser = new AidaWBXMLParser(handler);
            parser.parse(in);
        } else {
            AIDAEntityResolver er = new AIDAEntityResolver(AidaParser.class, "http://aida.freehep.org/");
            AidaParser parser = new AidaParser(handler, er);
            parser.setValidate(validate);
            InputSource is = new InputSource(in);
            String id = tree instanceof ITree ? ((ITree)((Object)tree)).storeName() : "AidaXMLStore";
            is.setSystemId(id);
            parser.parse(is);
        }
    }

    private boolean toBoolean(Map options, String key) {
        return this.toBoolean(options, key, false);
    }

    private boolean toBoolean(Map options, String key, boolean def) {
        Object value = options.get(key);
        if (value == null) {
            return def;
        }
        return Boolean.valueOf(value.toString());
    }
}

