/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.client;

import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.remote.rmi.RmiRemoteUtils;
import hep.aida.ref.remote.rmi.interfaces.RmiClient;
import hep.aida.ref.remote.rmi.interfaces.RmiServant;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Logger;

public class RmiClientImpl
extends UnicastRemoteObject
implements RmiClient,
AidaTreeServant {
    static final long serialVersionUID = 2380161439616929888L;
    private RmiServant rmiServant;
    private AidaTreeClient aidaClient;
    private int port = RmiRemoteUtils.port;
    private String currentHost = null;
    private String bindName;
    private boolean duplex;
    private transient Logger remoteLogger;

    public RmiClientImpl(boolean duplex) throws MalformedURLException, RemoteException, UnknownHostException {
        this(null, null, duplex);
    }

    public RmiClientImpl(RmiServant rmiServant, boolean duplex) throws MalformedURLException, RemoteException, UnknownHostException {
        this(rmiServant, null, duplex);
    }

    public RmiClientImpl(AidaTreeClient aidaClient, boolean duplex) throws MalformedURLException, RemoteException, UnknownHostException {
        this(null, aidaClient, duplex);
    }

    public RmiClientImpl(RmiServant rmiServant, AidaTreeClient aidaClient, boolean duplex) throws MalformedURLException, RemoteException, UnknownHostException {
        this.rmiServant = rmiServant;
        this.aidaClient = aidaClient;
        this.duplex = duplex;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        if (duplex) {
            this.connect();
        }
    }

    void setAidaTreeClient(AidaTreeClient aidaClient) {
        this.aidaClient = aidaClient;
    }

    void setRmiServant(RmiServant rmiServant) {
        this.rmiServant = rmiServant;
    }

    void connect() throws MalformedURLException, RemoteException, UnknownHostException {
        this.currentHost = InetAddress.getLocalHost().getHostAddress();
        this.bindName = this.createBindName();
        this.remoteLogger.fine("RmiClient ready");
    }

    void disconnect() {
        this.remoteLogger.finest("RmiClient.disconnect: Start");
        if (this.duplex) {
            try {
                RmiClientImpl.unexportObject(this, true);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.remoteLogger.finest("RmiClient.disconnect: Finish");
        this.rmiServant = null;
        this.aidaClient = null;
    }

    private String createBindName() {
        String name = "/RmiAidaClient";
        String dateString = RmiRemoteUtils.getCurrentDateString();
        name = "//" + this.currentHost + ":" + this.port + name + "/" + dateString;
        return name;
    }

    public String getBindName() throws RemoteException {
        return this.bindName;
    }

    public void stateChanged(AidaUpdateEvent[] events) throws RemoteException {
        this.aidaClient.stateChanged(events);
    }

    public Object find(String path) {
        this.remoteLogger.finest("RmiClient find for path=" + path);
        Object result = null;
        try {
            result = this.rmiServant.find(path);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        this.remoteLogger.finest("RmiClient find for path=" + path + ", obj=" + result);
        return result;
    }

    public String[] listObjectNames(String path, boolean recursive) {
        String[] result = null;
        try {
            result = this.rmiServant.listObjectNames(path, recursive);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return result;
    }

    public String[] listObjectTypes(String path, boolean recursive) {
        String[] result = null;
        try {
            result = this.rmiServant.listObjectTypes(path, recursive);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        return result;
    }

    public void setValid(String[] nodePaths) {
        this.remoteLogger.finest("RmiClient setValid for path=" + nodePaths[0]);
        try {
            this.rmiServant.setValid(nodePaths);
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        this.remoteLogger.finest("RmiClient setValid AFTER for path=" + nodePaths[0]);
    }

    public AidaUpdateEvent[] updates() {
        AidaUpdateEvent[] result = null;
        try {
            result = this.rmiServant.updates();
        }
        catch (RemoteException re) {
            throw new RemoteConnectionException(re.getMessage(), re);
        }
        this.remoteLogger.fine("RmiClient updates gotEvents=" + result.length);
        return result;
    }
}

