/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.basic;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.basic.BasicUpdateEvent;
import hep.aida.ref.remote.basic.ServerQueue;
import hep.aida.ref.remote.basic.TestBasic;
import hep.aida.ref.remote.basic.interfaces.AidaTreeClient;
import hep.aida.ref.remote.basic.interfaces.AidaTreeServant;
import hep.aida.ref.remote.basic.interfaces.UpdateEvent;
import hep.aida.ref.tree.Tree;
import java.util.EventObject;
import java.util.Random;
import java.util.Vector;

public class BasicTreeServant
extends Thread
implements AidaTreeServant,
AIDAListener {
    protected ITree tree;
    protected AidaTreeClient client;
    protected String clientID;
    protected boolean duplex;
    protected boolean keepRunning;
    protected Vector sources;
    protected ServerQueue queue;
    protected boolean useValidation;

    public BasicTreeServant(ITree tree, String clientID) {
        System.out.println("BasicTreeServant() clientID=" + clientID);
        this.tree = tree;
        this.clientID = clientID;
        this.client = null;
        this.duplex = false;
        this.init();
    }

    public BasicTreeServant(ITree tree, AidaTreeClient client) {
        System.out.println("BasicTreeServant() client=" + client);
        this.tree = tree;
        this.clientID = null;
        this.client = client;
        this.duplex = true;
        this.init();
        this.start();
    }

    protected void init() {
        this.sources = new Vector();
        this.queue = new ServerQueue();
        this.useValidation = true;
        this.keepRunning = this.duplex;
        if (this.tree instanceof IsObservable) {
            ((IsObservable)((Object)this.tree)).addListener(this);
            this.sources.add(this.tree);
            ((IsObservable)((Object)this.tree)).setValid(this);
        }
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched("/", true);
        }
    }

    public void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        BasicTreeServant basicTreeServant = this;
        synchronized (basicTreeServant) {
            System.out.print("\n\tClosing BasicTreeServant ... ");
            this.keepRunning = false;
            if (this.duplex) {
                ServerQueue serverQueue = this.queue;
                synchronized (serverQueue) {
                    this.queue.notify();
                }
            }
            for (int i = 0; i < this.sources.size(); ++i) {
                IsObservable o = (IsObservable)this.sources.get(i);
                if (o == null) continue;
                o.removeListener(this);
            }
            this.sources.clear();
            this.sources = null;
            this.tree = null;
            this.client = null;
            this.queue.close();
            this.queue = null;
            System.out.print(" Done\n");
        }
    }

    public Object find(String path) {
        IManagedObject mo = this.tree.find(path);
        if (mo instanceof IsObservable && !this.sources.contains(mo)) {
            ((IsObservable)((Object)mo)).addListener(this);
            this.sources.add(mo);
        }
        if (!this.useValidation && mo instanceof IsObservable) {
            ((IsObservable)((Object)mo)).setValid(this);
        }
        return mo;
    }

    public String[] listObjectNames(String path) {
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        return this.tree.listObjectNames(path);
    }

    public String[] listObjectTypes(String path) {
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        return this.tree.listObjectTypes(path);
    }

    public void setValid(String[] paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i] == null || paths[i].equals("") || paths[i].equals("/")) {
                if (!(this.tree instanceof IsObservable)) continue;
                ((IsObservable)((Object)this.tree)).setValid(this);
                continue;
            }
            IManagedObject mo = this.tree.find(paths[i]);
            if (mo instanceof IsObservable && !this.sources.contains(mo)) {
                ((IsObservable)((Object)mo)).addListener(this);
                this.sources.add(mo);
            }
            if (!(mo instanceof IsObservable)) continue;
            ((IsObservable)((Object)mo)).setValid(this);
        }
    }

    public UpdateEvent[] updates() {
        UpdateEvent[] events = new UpdateEvent[]{};
        if (!this.duplex) {
            events = this.queue.getEvents();
        }
        return events;
    }

    public void stateChanged(EventObject ev) {
        int id = -1;
        String pathString = "";
        String nodeType = "null";
        if (ev instanceof TreeEvent) {
            TreeEvent tev = (TreeEvent)ev;
            String[] path = tev.getPath();
            if (path != null) {
                for (int i = 0; i < path.length; ++i) {
                    pathString = pathString + "/" + path[i];
                }
            }
            if (tev.getType() != null) {
                nodeType = tev.getType().getName();
            }
            if (tev.getFlags() == 1) {
                nodeType = "dir";
            }
            if (tev.getID() == 1) {
                id = 1;
                IManagedObject hist = this.tree.find(pathString);
                nodeType = hist.type();
            } else {
                id = tev.getID() == 2 ? 2 : -1;
            }
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
        } else if (ev instanceof HistogramEvent) {
            IBaseHistogram hist = (IBaseHistogram)ev.getSource();
            id = 0;
            pathString = this.tree.findPath((IManagedObject)((Object)hist));
            nodeType = ((IManagedObject)((Object)hist)).type();
            if (!this.useValidation && hist instanceof IsObservable) {
                ((IsObservable)((Object)hist)).setValid(this);
            }
        }
        if (id >= 0) {
            this.queue.schedule(new BasicUpdateEvent(id, pathString, nodeType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.duplex && this.keepRunning) {
            int size = 0;
            UpdateEvent[] events = null;
            try {
                ServerQueue serverQueue = this.queue;
                synchronized (serverQueue) {
                    if (this.queue.size() == 0) {
                        this.queue.wait();
                    }
                    int n = size = this.queue == null ? 0 : this.queue.size();
                    if (size > 0) {
                        events = this.queue.getEvents();
                    }
                }
                if (events == null || events.length == 0) {
                    return;
                }
                this.client.stateChanged(events);
            }
            catch (InterruptedException e2) {
                System.out.println("ServerQueue Thread InterruptedException.");
                e2.printStackTrace();
            }
            catch (Exception e3) {
                System.out.println("Problems in ServerQueue!.");
                e3.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Random r = new Random();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITreeFactory tf = af.createTreeFactory();
        ITree serverTree = tf.create();
        ((IsObservable)((Object)serverTree)).addListener(new TestBasic((Tree)serverTree));
        IHistogramFactory histogramFactory = af.createHistogramFactory(serverTree);
        int nEntries = 1000;
        int xbins = 10;
        double xLowerEdge = -10.0;
        double xUpperEdge = 10.0;
        serverTree.mkdir("/dir1");
        IHistogram1D h1 = histogramFactory.createHistogram1D("Hist-1", xbins, xLowerEdge, xUpperEdge);
        IHistogram1D h2 = histogramFactory.createHistogram1D("Hist-2", xbins, xLowerEdge, xUpperEdge);
        for (int i = 0; i < nEntries; ++i) {
            double xval = r.nextGaussian() * 3.0 + 2.0;
            h1.fill(xval);
            xval = r.nextGaussian() * 3.0 + 2.0;
            h2.fill(xval);
        }
        System.out.println("Creating TreeServant ...");
        BasicTreeServant servant = new BasicTreeServant(serverTree, "Test Servant");
        try {
            System.out.println("Servant is ready. To add Hist-3 press ENTER");
            System.in.read();
            IHistogram1D h3 = histogramFactory.createHistogram1D("Hist-1", xbins, xLowerEdge, xUpperEdge);
            System.out.println("To call \"updates()\" press ENTER");
            System.in.read();
            UpdateEvent[] ue = servant.updates();
            System.out.println("Got " + ue.length + "  events");
            for (int i = 0; i < ue.length; ++i) {
                System.out.println("Event " + i + "   id=" + ue[i].id() + "  path=" + ue[i].path() + "   type=" + ue[i].nodeType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

