/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.fitter.fitdata.FitData;
import hep.aida.ref.fitter.fitdata.FitDataIterator;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;

public class NonParametricPdf
extends Function {
    public static final int NO_MIRROR = 0;
    public static final int MIRROR_LEFT = 1;
    public static final int MIRROR_RIGHT = 2;
    public static final int MIRROR_BOTH = 3;
    private static final int nPoints = 1000;
    private static final double sqrt2pi = Math.sqrt(Math.PI * 2);
    private Dependent x;
    private double xVal;
    private double rho = 1.0;
    private double[] lookupTable;
    private double[] dataPoints;
    private double[] weights;
    private int nEntries;
    private int nData;
    private double lowerBound;
    private double upperBound;
    private double binWidth;
    private boolean mirrorLeft;
    private boolean mirrorRight;
    private int type;

    public NonParametricPdf(String name, FitData data, Dependent x) {
        this(name, data, x, 3);
    }

    public NonParametricPdf(String name, FitData data, Dependent x, int mirrorCode) {
        super(name);
        this.x = x;
        switch (mirrorCode) {
            case 0: {
                this.mirrorLeft = false;
                this.mirrorRight = false;
                break;
            }
            case 1: {
                this.mirrorLeft = true;
                this.mirrorRight = false;
                break;
            }
            case 2: {
                this.mirrorLeft = false;
                this.mirrorRight = true;
                break;
            }
            case 3: {
                this.mirrorLeft = true;
                this.mirrorRight = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported mirror code " + mirrorCode);
            }
        }
        this.lowerBound = x.range().lowerBounds()[0];
        this.upperBound = x.range().upperBounds()[0];
        this.binWidth = (this.upperBound - this.lowerBound) / 999.0;
        VariableList list = new VariableList();
        list.add(x);
        this.addVariables(list);
        if (data.dimension() != 1) {
            throw new IllegalArgumentException("Cannot create a multi-dimensional NonParametricPdf");
        }
        this.type = data.fitType();
        if (data.fitType() == 0) {
            throw new IllegalArgumentException("Cannot create NonParametricPdf for binned data");
        }
        this.initializeUnbinnedDataSet(data);
    }

    public void variableChanged(Variable var) {
        if (var == this.x) {
            this.xVal = this.x.value();
        }
    }

    public double functionValue() {
        if (this.type == 1) {
            int i = (int)Math.floor((this.xVal - this.lowerBound) / this.binWidth);
            if (i < 0) {
                System.out.println("Got point below lower bound " + this.xVal + ". Peforming linear extrapolation.");
                i = 0;
            }
            if (i > 999) {
                System.out.println("Got point above upper bound " + this.xVal + ". Peforming linear extrapolation.");
                i = 999;
            }
            double dx = (this.xVal - (this.lowerBound + (double)i * this.binWidth)) / this.binWidth;
            double r = this.lookupTable[i] + dx * (this.lookupTable[i + 1] - this.lookupTable[i]);
            return r;
        }
        throw new UnsupportedOperationException("Cannot evaluate NonParametricPdf for binned data");
    }

    private void initializeUnbinnedDataSet(FitData d) {
        this.lookupTable = new double[1001];
        FitDataIterator iter = (FitDataIterator)d.dataIterator();
        this.nData = this.nEntries = iter.entries();
        if (this.mirrorLeft) {
            this.nEntries += iter.entries();
        }
        if (this.mirrorRight) {
            this.nEntries += iter.entries();
        }
        this.dataPoints = new double[this.nEntries];
        this.weights = new double[this.nEntries];
        double sumX = 0.0;
        double sumXSquared = 0.0;
        int count = 0;
        while (iter.next()) {
            double tmpx;
            this.dataPoints[count] = tmpx = iter.vars()[0];
            sumX += tmpx;
            sumXSquared += tmpx * tmpx;
            ++count;
            if (this.mirrorLeft) {
                this.dataPoints[count] = 2.0 * this.lowerBound - tmpx;
                ++count;
            }
            if (!this.mirrorRight) continue;
            this.dataPoints[count] = 2.0 * this.upperBound - tmpx;
            ++count;
        }
        double mean = sumX / (double)this.nData;
        double sigma = Math.sqrt(sumXSquared / (double)this.nData - mean * mean);
        double h = Math.pow(1.3333333333333333, 0.2) * Math.pow(this.nData, -0.2) * this.rho;
        double hmin = h * sigma * Math.sqrt(2.0) / 10.0;
        double norm = h * Math.sqrt(sigma) / (2.0 * Math.sqrt(3.0));
        this.weights = new double[this.nEntries];
        for (int j = 0; j < this.nEntries; ++j) {
            this.weights[j] = norm / Math.sqrt(this.weightFactor(this.dataPoints[j], h * sigma));
            if (!(this.weights[j] < hmin)) continue;
            this.weights[j] = hmin;
        }
        for (int i = 0; i < 1001; ++i) {
            this.lookupTable[i] = this.evaluateFull(this.lowerBound + (double)i * this.binWidth);
        }
    }

    private double weightFactor(double x, double sigma) {
        double c = 1.0 / (2.0 * sigma * sigma);
        double y = 0.0;
        for (int i = 0; i < this.nEntries; ++i) {
            double arg = x - this.dataPoints[i];
            y += Math.exp(-c * arg * arg);
        }
        return y / (sigma * sqrt2pi * (double)this.nData);
    }

    private double evaluateFull(double x) {
        double y = 0.0;
        for (int i = 0; i < this.nEntries; ++i) {
            double chi = (x - this.dataPoints[i]) / this.weights[i];
            y += Math.exp(-0.5 * chi * chi) / this.weights[i];
        }
        return y / (sqrt2pi * (double)this.nData);
    }

    public boolean hasAnalyticalVariableGradient(Variable var) {
        return false;
    }

    public boolean hasAnalyticalNormalization(Dependent dep) {
        return dep == this.x;
    }

    public double evaluateAnalyticalNormalization(Dependent dep) {
        return 1.0;
    }
}

