/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.IRangeSet;
import hep.aida.ref.Annotation;
import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.FunctionChangedEvent;
import hep.aida.ref.pdf.FunctionDerivative;
import hep.aida.ref.pdf.FunctionDispatcher;
import hep.aida.ref.pdf.FunctionIntegrator;
import hep.aida.ref.pdf.FunctionListener;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Units;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;
import hep.aida.ref.pdf.VariableListener;
import java.util.ArrayList;

public class Function
extends Variable
implements IModelFunction,
VariableListener,
FunctionDispatcher {
    private VariableList parList = new VariableList(VariableList.PARAMETER);
    private VariableList depList = new VariableList(VariableList.DEPENDENT);
    private VariableList funList = new VariableList(VariableList.FUNCTION);
    private ArrayList listeners = new ArrayList();
    private boolean isNormalized = false;
    private double normalization = 1.0;
    private Parameter norm = new Parameter("norm", 1.0);
    private String codeletString;
    private Annotation annotation;

    public Function(String name) {
        super(name, Variable.FUNCTION);
        this.setCodeletString("codelet:" + this.getClass() + ":class:");
        this.annotation = new Annotation();
        this.annotation.addItem(Annotation.titleKey, "");
        this.annotation.setFillable(true);
    }

    public void addVariable(Variable v) {
        if (v instanceof Dependent) {
            this.addDependent((Dependent)v, true);
        } else if (v instanceof Parameter) {
            this.addParameter((Parameter)v, true);
        } else if (v instanceof Function) {
            this.addFunction((Function)v, true);
        }
    }

    public void addVariables(VariableList list) {
        for (int i = 0; i < list.size(); ++i) {
            Variable v = list.get(i);
            this.addVariable(v);
            this.variableChanged(v);
        }
    }

    private void addDependent(Dependent dep, boolean addListener) {
        this.checkVariable(dep);
        if (addListener) {
            dep.addVariableListener(this);
        }
        this.depList.add(dep);
    }

    private void addParameter(Parameter par, boolean addListener) {
        this.checkVariable(par);
        if (addListener) {
            par.addVariableListener(this);
        }
        this.parList.add(par);
    }

    private void addFunction(Function func, boolean addListener) {
        int i;
        if (addListener) {
            func.addVariableListener(this);
        }
        this.funList.add(func);
        for (i = 0; i < func.numberOfDependents(); ++i) {
            this.addDependent(func.getDependent(i), false);
        }
        for (i = 0; i < func.numberOfParameters(); ++i) {
            this.addParameter(func.getParameter(i), false);
        }
    }

    private Function getCompositeFunction(Variable var) {
        for (int i = 0; i < this.funList.size(); ++i) {
            Function f = (Function)this.funList.get(i);
            if (!f.hasVariable(var)) continue;
            return f;
        }
        throw new IllegalArgumentException("Variable " + var.name() + " is not composite!");
    }

    private void checkVariable(Variable var) {
        if (!this.isValidVariableName(var.name())) {
            throw new IllegalArgumentException("A Variable with name " + var.name() + " already belongs to this Function.");
        }
        if (this.hasVariable(var)) {
            throw new IllegalArgumentException("Variable " + var.name() + " already belongs to this Function");
        }
    }

    private boolean isValidVariableName(String name) {
        if (this.depList.contains(name) || this.parList.contains(name)) {
            return false;
        }
        return this.norm == null || !name.equals(this.norm.name());
    }

    protected boolean hasDependent(Dependent dep) {
        return this.depList.contains(dep);
    }

    protected boolean hasParameter(Parameter par) {
        return this.parList.contains(par);
    }

    protected boolean hasVariable(Variable var) {
        if (this.depList.contains(var) || this.parList.contains(var)) {
            return true;
        }
        return this.norm != null && var == this.norm;
    }

    public boolean variableChangingUnits(Variable var, Units units) {
        return false;
    }

    public void variableChangedUnits(Variable var) {
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.FUNCTION_CHANGED));
    }

    public boolean variableChangingValue(Variable var, double value) {
        return true;
    }

    public String normalizationParameter() {
        return this.norm.name();
    }

    public void variableChanged(Variable var) {
    }

    public void variableChangedValue(Variable var) {
        this.variableChanged(var);
        if (this.parList.contains(var)) {
            this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
            this.updateNormalization();
        }
    }

    public boolean variableChangingName(Variable var, String name) {
        return this.isValidVariableName(name);
    }

    public void variableChangedName(Variable var) {
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_NAME_CHANGED));
    }

    public void setValue(double value) {
        super.setValue(value);
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.FUNCTION_VALUE_CHANGED));
    }

    public double functionValue() {
        throw new RuntimeException("This method MUST be overwritten!!");
    }

    public double functionMaxValue() {
        return Double.NaN;
    }

    private double numericalIntegral() {
        return this.numericalIntegral(this.depList);
    }

    private double numericalIntegral(VariableList l) {
        int i;
        int dim = l.size();
        if (dim == 0) {
            return 0.0;
        }
        double val = 0.0;
        double[] x = new double[dim];
        for (i = 0; i < x.length; ++i) {
            x[i] = l.get(i).value();
        }
        val = dim == 1 ? FunctionIntegrator.integralTrapezoid(this, l) : FunctionIntegrator.integralMC(this, l);
        for (i = 0; i < x.length; ++i) {
            l.get(i).setValue(x[i]);
        }
        return val;
    }

    protected void updateNormalization() {
        this.normalization = 0.0;
        VariableList l = new VariableList(VariableList.DEPENDENT);
        for (int i = 0; i < this.numberOfDependents(); ++i) {
            Dependent dep = this.getDependent(i);
            if (!this.isComposite(dep) && this.hasAnalyticalNormalization(dep)) {
                this.normalization += this.evaluateAnalyticalNormalization(dep);
                continue;
            }
            l.add(dep);
        }
        if (l.size() > 0) {
            this.normalization += this.numericalIntegral(l);
        }
    }

    public boolean hasAnalyticalNormalization(Dependent dep) {
        return false;
    }

    public double evaluateAnalyticalNormalization(Dependent dep) {
        VariableList l = new VariableList(VariableList.DEPENDENT);
        l.add(dep);
        return this.numericalIntegral(l);
    }

    protected double maxValue() {
        this.updateNormalization();
        return this.functionMaxValue() / this.normalization;
    }

    public double value() {
        double fVal = this.functionValue();
        if (fVal < 0.0) {
            System.out.println("Negative value for " + this.name() + " : " + fVal + ". Setting it to 0.");
            fVal = 0.0;
        }
        if (this.isNormalized) {
            fVal /= this.normalization;
            if (this.isNormalized && fVal > 1.0) {
                throw new RuntimeException("Probability greater than 1 for " + this.name() + " : " + fVal);
            }
        }
        if (this.norm != null) {
            fVal *= this.norm.value();
        }
        return fVal;
    }

    public double evaluateAnalyticalVariableGradient(Variable var) {
        throw new IllegalArgumentException("This function does not provide the gradient");
    }

    private double evaluateVariableGradient(Variable var) {
        if (var == this.norm) {
            return this.functionValue();
        }
        if (this.providesGradientWithRespectToVariable(var)) {
            return this.evaluateAnalyticalVariableGradient(var);
        }
        return FunctionDerivative.derivative(this, var, 1.0);
    }

    public boolean hasAnalyticalVariableGradient(Variable var) {
        return false;
    }

    public boolean providesGradientWithRespectToVariable(Variable var) {
        if (this.isComposite(var)) {
            Function composite = this.getCompositeFunction(var);
            return composite.providesGradientWithRespectToVariable(var) && this.providesGradientWithRespectToVariable(composite);
        }
        if (this.hasVariable(var)) {
            return this.hasAnalyticalVariableGradient(var);
        }
        throw new IllegalArgumentException("Variable " + var.name() + " does not belong to this function.");
    }

    public double[] gradient() {
        double[] grad = new double[this.numberOfDependents()];
        for (int i = 0; i < grad.length; ++i) {
            grad[i] = this.evaluateVariableGradient(this.getDependent(i));
        }
        return grad;
    }

    public double[] parameterGradient() {
        double[] parGrad = new double[this.numberOfParameters()];
        for (int i = 0; i < parGrad.length; ++i) {
            parGrad[i] = this.evaluateVariableGradient(this.getParameter(i));
        }
        return parGrad;
    }

    public Parameter getParameter(int index) {
        if (index != this.parList.size() || this.norm != null) {
            // empty if block
        }
        return (Parameter)this.parList.get(index);
    }

    public Parameter getParameter(String parName) {
        if (this.norm != null && parName.equals(this.norm.name())) {
            return this.norm;
        }
        return (Parameter)this.parList.get(parName);
    }

    public int numberOfParameters() {
        int nPars = this.parList.size();
        if (!this.isNormalized && this.norm != null) {
            ++nPars;
        }
        return nPars;
    }

    public Dependent getDependent(int index) {
        return (Dependent)this.depList.get(index);
    }

    public Dependent getDependent(String parName) {
        return (Dependent)this.depList.get(parName);
    }

    public int numberOfDependents() {
        return this.depList.size();
    }

    public boolean isComposite(Variable var) {
        for (int i = 0; i < this.funList.size(); ++i) {
            Function f = (Function)this.funList.get(i);
            if (!f.hasVariable(var)) continue;
            return true;
        }
        return false;
    }

    public Parameter getNormalizationParameter() {
        return this.norm;
    }

    public void setNormalizationParamter(Parameter par) {
        this.norm = par;
    }

    public void addFunctionListener(FunctionListener listener) {
        this.listeners.add(listener);
    }

    public void removeFunctionListener(FunctionListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyFunctionChanged(FunctionChangedEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FunctionListener)this.listeners.get(i)).functionChanged(event);
        }
    }

    public void variableChangedRange(Variable var) {
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
        this.updateNormalization();
    }

    public void normalizationRangeChanged() {
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
        this.updateNormalization();
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void normalize(boolean normalize) {
        Parameter norm = this.getNormalizationParameter();
        if (norm != null) {
            if (normalize) {
                if (!this.isNormalized()) {
                    norm.setValue(1.0);
                    norm.setFixed(true);
                }
            } else {
                norm.setFixed(false);
            }
        }
        this.isNormalized = normalize;
        this.updateNormalization();
    }

    public boolean providesNormalization() {
        return false;
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public String codeletString() {
        return this.codeletString;
    }

    public void setCodeletString(String str) {
        this.codeletString = str;
    }

    public double value(double[] v) {
        if (v.length != this.dimension()) {
            throw new IllegalArgumentException("Illegal dimension for the vector " + v.length + ". It should match the Function's dimension " + this.dimension());
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).setValue(v[i]);
        }
        return this.value();
    }

    public double[] gradient(double[] v) {
        if (v.length != this.dimension()) {
            throw new IllegalArgumentException("Illegal dimension for the vector " + v.length + ". It should match the Function's dimension " + this.dimension());
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).setValue(v[i]);
        }
        return this.gradient();
    }

    public int dimension() {
        return this.numberOfDependents();
    }

    public int indexOfParameter(String parName) {
        return this.parList.indexOf(parName);
    }

    public double parameter(String parName) {
        return this.getParameter(parName).value();
    }

    public String[] parameterNames() {
        String[] parNames = new String[this.numberOfParameters()];
        for (int i = 0; i < parNames.length; ++i) {
            parNames[i] = this.getParameter(i).name();
        }
        return parNames;
    }

    public double[] parameters() {
        double[] parValues = new double[this.numberOfParameters()];
        for (int i = 0; i < parValues.length; ++i) {
            parValues[i] = this.getParameter(i).value();
        }
        return parValues;
    }

    public void setParameter(String parName, double parValue) throws IllegalArgumentException {
        this.getParameter(parName).setValue(parValue);
    }

    public void setParameters(double[] pars) throws IllegalArgumentException {
        if (pars.length != this.numberOfParameters()) {
            throw new IllegalArgumentException("Wrong number of input parameters:" + pars.length + ", must be " + this.numberOfParameters());
        }
        for (int i = 0; i < pars.length; ++i) {
            this.getParameter(i).setValue(pars[i]);
        }
    }

    public void setTitle(String title) throws IllegalArgumentException {
        this.annotation.setValue(Annotation.titleKey, title);
    }

    public String title() {
        return this.annotation.value(Annotation.titleKey);
    }

    public String variableName(int index) {
        return this.getDependent(index).name();
    }

    public String[] variableNames() {
        String[] depNames = new String[this.dimension()];
        for (int i = 0; i < depNames.length; ++i) {
            depNames[i] = this.getDependent(i).name();
        }
        return depNames;
    }

    public double functionValue(double[] v) {
        if (v.length != this.dimension()) {
            throw new IllegalArgumentException("Illegal dimension for the vector " + v.length + ". It should match the Function's dimension " + this.dimension());
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).setValue(v[i]);
        }
        return this.functionValue();
    }

    public void excludeNormalizationAll() {
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).range().excludeAll();
        }
        this.normalizationRangeChanged();
    }

    public void includeNormalizationAll() {
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).range().includeAll();
        }
        this.normalizationRangeChanged();
    }

    public IRangeSet normalizationRange(int i) {
        return this.getDependent(i).range();
    }

    public double[] parameterGradient(double[] v) {
        if (v.length != this.dimension()) {
            throw new IllegalArgumentException("Illegal dimension for the vector " + v.length + ". It should match the Function's dimension " + this.dimension());
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.getDependent(i).setValue(v[i]);
        }
        double[] tmpGrad = this.parameterGradient();
        if (this.isNormalized()) {
            return tmpGrad;
        }
        double[] grad = new double[tmpGrad.length + 1];
        for (int i = 0; i < tmpGrad.length; ++i) {
            grad[i] = tmpGrad[i];
        }
        grad[grad.length - 1] = this.functionValue();
        return grad;
    }

    public boolean isEqual(IFunction iFunction) {
        throw new UnsupportedOperationException("This method has not been implemented.");
    }

    public boolean providesGradient() {
        for (int i = 0; i < this.numberOfDependents(); ++i) {
            if (this.providesGradientWithRespectToVariable(this.getDependent(i))) continue;
            return false;
        }
        return true;
    }

    public boolean providesParameterGradient() {
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            if (this.providesGradientWithRespectToVariable(this.getParameter(i))) continue;
            return false;
        }
        return true;
    }

    protected void setVariableValue(double value) {
        throw new IllegalArgumentException("Cannot set the value of a function ");
    }
}

