/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.AbstractBinner1D;
import hep.aida.ref.histogram.binner.Binner1D;
import hep.aida.ref.histogram.binner.EfficiencyBinnerUtils;

public class EfficiencyBinner1D
extends AbstractBinner1D {
    private double[] error;

    public EfficiencyBinner1D(int bins) {
        super(bins);
    }

    public EfficiencyBinner1D(Binner1D binner) {
        super(binner);
    }

    protected void createArrays(int n) {
        super.createArrays(n);
        this.error = new double[n];
    }

    public double plusError(int bin) {
        return EfficiencyBinnerUtils.H95CL(this.error[bin], this.entries[bin], 1);
    }

    public double minusError(int bin) {
        return EfficiencyBinnerUtils.H95CL(this.error[bin], this.entries[bin], 2);
    }

    public void setBinCenter(int bin, double x) {
        super.setBinCenter(bin, x);
        this.error[bin] = 0.0;
    }

    public void clear() {
        super.clear();
        for (int i = 0; i < this.bins; ++i) {
            this.error[i] = 0.0;
        }
    }

    public void fill(int bin, double x, double weight) {
        super.fill(bin, x, weight);
    }

    public void setBinContent(int bin, int entries, double height, double plusError, double minusError, double sumWW, double sumXW, double sumXXW) {
        this.setBinContent(bin, entries, height, plusError, minusError, sumWW, sumXW, sumXXW);
        this.error[bin] = !Double.isNaN(height) ? height * (double)entries : (double)(entries * entries);
    }
}

