/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.function.JELCompiledExpression;

public class JELFunctionCore
extends FunctionCore {
    private String expression;
    private boolean providesGradient;
    private JELCompiledExpression compExpression;
    private JELCompiledExpression[] compGradient;

    public JELFunctionCore(int dim, int nPar, String expr2, String[] pNames, String[] gradient) {
        super(dim, nPar);
        if (expr2 == null || expr2.equals("")) {
            throw new IllegalArgumentException("Can not create function from an empty script!");
        }
        this.expression = expr2;
        if (pNames != null && nPar != pNames.length) {
            throw new IllegalArgumentException("Number of parameters (" + nPar + ") is different from number of parameter names (" + pNames.length + ")");
        }
        this.compExpression = new JELCompiledExpression(this.dimension, this.numberOfParameters, this.expression, pNames);
        this.compGradient = null;
        if (gradient != null && gradient.length > 0) {
            this.providesGradient = true;
            this.compGradient = new JELCompiledExpression[dim];
            for (int i = 0; i < dim; ++i) {
                this.compGradient[i] = new JELCompiledExpression(this.dimension, this.numberOfParameters, gradient[i], pNames);
            }
        } else {
            this.providesGradient = false;
        }
        if (pNames != null) {
            this.setParameterNames(pNames);
        }
    }

    public double functionValue(double[] var) {
        return this.compExpression.evaluate(var, this.parameters());
    }

    public boolean setParameterNames(String[] params) {
        super.setParameterNames(params);
        this.compExpression.setParameterNames(params);
        if (this.compGradient != null) {
            for (int i = 0; i < this.dimension; ++i) {
                this.compGradient[i].setParameterNames(params);
            }
        }
        return true;
    }

    public boolean providesGradient() {
        return this.providesGradient;
    }

    public double[] gradient(double[] x) {
        if (this.compGradient == null || !this.providesGradient) {
            throw new UnsupportedOperationException("This function does not provide gradient");
        }
        double[] grad = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            grad[i] = this.compGradient[i].evaluate(x, this.parameters());
        }
        return grad;
    }

    public boolean providesParameterGradient() {
        return false;
    }

    public double[] parameterGradient(double[] x) {
        throw new UnsupportedOperationException("JELFunctionCore does not provide parameter gradient");
    }

    public boolean providesNormalization() {
        return false;
    }

    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException("JELFunctionCore does not provide normalization");
    }
}

