/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import [Ljava.lang.String;;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.ext.IManagedFunction;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.CodeletUtils;
import hep.aida.ref.function.ExponentialCoreNorm;
import hep.aida.ref.function.ExponentialCoreNotNorm;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.function.GaussianCore2DNorm;
import hep.aida.ref.function.GaussianCore2DNotNorm;
import hep.aida.ref.function.GaussianCoreNorm;
import hep.aida.ref.function.GaussianCoreNotNorm;
import hep.aida.ref.function.JELBaseModelFunction;
import hep.aida.ref.function.LorentzianCoreNotNorm;
import hep.aida.ref.function.MoyalCoreNotNorm;
import hep.aida.ref.function.PolynomialCoreNorm;
import hep.aida.ref.function.PolynomialCoreNotNorm;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public class FunctionCreator {
    public IFunction createFromCodelet(String codeletString) {
        return this.createFromCodelet(null, codeletString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IFunction createFromCodelet(String nameInTree, String codeletString) {
        IFunction f = null;
        if (!codeletString.toLowerCase().startsWith(FunctionCatalog.prefix)) {
            throw new IllegalArgumentException("\"" + codeletString + "\" is not a codelet string (must start with \"" + FunctionCatalog.prefix + "\")");
        }
        String name = CodeletUtils.modelFromCodelet(codeletString);
        String location = CodeletUtils.locationFromCodelet(codeletString);
        if (CodeletUtils.isCodeletFromCatalog(codeletString)) {
            if (name.toLowerCase().equals("e")) {
                f = new BaseModelFunction(name, name, new ExponentialCoreNotNorm(name), new ExponentialCoreNorm(name));
            } else if (name.toLowerCase().startsWith("p")) {
                f = new BaseModelFunction(name, name, new PolynomialCoreNotNorm(name), new PolynomialCoreNorm(name));
            } else if (name.toLowerCase().startsWith("g2")) {
                f = new BaseModelFunction(name, name, new GaussianCore2DNotNorm(name), new GaussianCore2DNorm(name));
            } else if (name.toLowerCase().startsWith("g")) {
                f = new BaseModelFunction(name, name, new GaussianCoreNotNorm(name), new GaussianCoreNorm(name));
            } else if (name.toLowerCase().startsWith("moyal")) {
                f = new BaseModelFunction(name, name, new MoyalCoreNotNorm(name), null);
            } else {
                if (!name.toLowerCase().startsWith("lorentzian")) throw new UnsupportedOperationException("Can not create function: " + name);
                f = new BaseModelFunction(name, name, new LorentzianCoreNotNorm(name), null);
            }
            ((BaseModelFunction)f).setCodeletString(codeletString);
            if (nameInTree == null) {
                nameInTree = name;
            }
            ((ManagedObject)((Object)f)).setName(nameInTree);
            return f;
        }
        if (CodeletUtils.isCodeletFromScript(codeletString)) {
            StringTokenizer st = new StringTokenizer(codeletString, ":");
            String[] args = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i] = st.nextToken().trim();
                ++i;
            }
            int dim = Integer.parseInt(args[4]);
            String valexpr = args[5];
            String parameters = args[6];
            String gradexpr = "";
            if (args.length > 7) {
                gradexpr = args[7];
            }
            if (gradexpr.trim().toLowerCase().equals("null") || gradexpr.trim().equals("")) {
                gradexpr = null;
            }
            f = new JELBaseModelFunction(name, dim, valexpr, parameters, name, gradexpr);
            ((JELBaseModelFunction)f).setCodeletString(codeletString);
            ((ManagedObject)((Object)f)).setName(nameInTree);
            return f;
        }
        if (CodeletUtils.isCodeletFromClass(codeletString)) {
            StringTokenizer st = new StringTokenizer(codeletString, ":");
            String[] args = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i] = st.nextToken().trim();
                ++i;
            }
            String[] varList = CodeletUtils.stringToArray(args[3]);
            String[] parList = CodeletUtils.stringToArray(args[4]);
            try {
                if (varList != null && parList != null) {
                    Class[] types = new Class[]{String;.class, String;.class};
                    Class<?> cl = Class.forName(name);
                    f = (IFunction)cl.getConstructor(types).newInstance(varList, parList);
                } else {
                    Class<?> cl = Class.forName(name);
                    f = (IFunction)cl.newInstance();
                }
                if (f instanceof ManagedObject) {
                    ((ManagedObject)((Object)f)).setName(nameInTree);
                }
                if (f instanceof IManagedFunction) {
                    ((IManagedFunction)f).setName(nameInTree);
                }
                if (f == null) return f;
                f.setTitle(nameInTree);
                return f;
            }
            catch (Exception ec) {
                throw new RuntimeException("Can not create user CLASS function:" + name, ec);
            }
        }
        if (!CodeletUtils.isCodeletFromFile(codeletString)) return f;
        try {
            String urlString = location.substring(5).trim();
            if (urlString == null || urlString.equals("")) {
                Class<?> cl = Class.forName(name);
                f = (IFunction)cl.newInstance();
            } else {
                URL[] urlList = new URL[]{new File(urlString.substring(1)).toURL()};
                URLClassLoader loader = new URLClassLoader(urlList);
                System.out.println("Name: " + name + "\nFile Name: " + urlString);
                System.out.println("URL: " + urlList[0].getFile());
                Class<?> cl = loader.loadClass(name);
                f = (IFunction)cl.newInstance();
            }
            if (f instanceof ManagedObject) {
                ((ManagedObject)((Object)f)).setName(nameInTree);
            }
            if (!(f instanceof IManagedFunction)) return f;
            ((IManagedFunction)f).setName(nameInTree);
            return f;
        }
        catch (Exception ec) {
            throw new RuntimeException("Can not create user FILE function:" + name, ec);
        }
    }

    public static String toString(IFunction f) {
        String out = "Codelet: " + f.codeletString() + "\n";
        if (f instanceof IManagedObject) {
            out = out + "   name: " + ((IManagedObject)((Object)f)).name() + "\n";
        }
        out = out + "\tDimensions: " + f.dimension() + "\n";
        for (int i = 0; i < f.dimension(); ++i) {
            out = out + "\t\t Variable " + i + "\t Name: " + f.variableName(i) + "\n";
        }
        out = out + "\tParameters: " + f.numberOfParameters() + "\n";
        String[] par = f.parameterNames();
        for (int i = 0; i < f.numberOfParameters(); ++i) {
            out = out + "\t\t Parameter " + i + "\t Name: " + par[i] + "\n";
        }
        out = out + "Provides gradiant: " + f.providesGradient();
        return out;
    }
}

