/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.command;

import com.artenum.jyconsole.command.Command;
import com.artenum.jyconsole.command.CommandRunner;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.python.core.PyException;

public class SingleThreadCommandRunner
implements CommandRunner,
Runnable {
    private List runnables = new ArrayList();
    private Thread currentThread;
    private String threadName;
    private Command r;

    public SingleThreadCommandRunner(String threadName) {
        this.threadName = threadName;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            List list = this.runnables;
            synchronized (list) {
                try {
                    if (this.r != null && this.r.isRunning()) {
                        this.r.stop();
                    }
                    this.currentThread = null;
                    this.runnables.notify();
                }
                catch (Exception e) {
                    Logger.getLogger("ErrorLogger").error("Could not notify runnables object in KillableSingleThread " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeLater(Command r) {
        List list = this.runnables;
        synchronized (list) {
            this.runnables.add(r);
            if (this.runnables.size() > 0) {
                this.runnables.notify();
            }
        }
    }

    @Override
    public void reset() {
        this.stop();
        this.currentThread = new Thread((Runnable)this, this.threadName);
        this.currentThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (this.currentThread == Thread.currentThread()) {
            this.r = null;
            List list = this.runnables;
            synchronized (list) {
                while (true) {
                    if (this.runnables.size() != 0) {
                        if (this.currentThread == Thread.currentThread()) {
                            this.r = (Command)this.runnables.remove(0);
                        }
                        break;
                    }
                    try {
                        this.runnables.wait();
                        Thread a = Thread.currentThread();
                        if (a == this.currentThread) continue;
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
            }
            try {
                if (this.r == null) continue;
                this.r.run();
            }
            catch (PyException t) {
                t.printStackTrace();
            }
        }
    }
}

