; Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;+
; CLASS_NAME:
;    YAML_Alias
;
; PURPOSE:
;    The YAML_Alias class is used to create a YAML alias (reference),
;    containing an ALIAS and an optional TAG.
;
; CATEGORY:
;    Datatypes
;
;-

;---------------------------------------------------------------------------
function YAML_Alias::Init, alias
  compile_opt IDL2, HIDDEN
  self.YAML_Node::SetProperty, ALIAS=alias
  return, 1
end

;---------------------------------------------------------------------------
pro YAML_Alias::SetProperty, ALIAS=alias
  compile_opt IDL2, HIDDEN
  self.YAML_Node::SetProperty, ALIAS=alias
end

;---------------------------------------------------------------------------
pro YAML_Alias__DEFINE
  compile_opt IDL2, HIDDEN
  void = {YAML_Alias, $
    inherits YAML_Node, $
    inherits IDL_Object}
end
