/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public class ClassUtil {
    private static String _userClasspath;
    private static URL[] _urls;
    private static String PATH_SEP;
    private static URLClassLoader _loader;

    public static Class findClass(String slashSeparatedName) {
        if (slashSeparatedName == null || slashSeparatedName.equals("")) {
            return null;
        }
        String dotSeparatedName = slashSeparatedName.replace('/', '.');
        Class<?> clazz = null;
        try {
            clazz = Class.forName(dotSeparatedName);
        }
        catch (ClassNotFoundException e) {
            if (_loader == null && _urls != null) {
                _loader = new URLClassLoader(_urls);
            }
            if (_loader != null) {
                try {
                    clazz = Class.forName(dotSeparatedName, true, _loader);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (ExceptionInInitializerError e) {
            System.out.println("ERR -ClassUtil::findClass ExceptionInInitailizerError:" + e.getMessage());
            e.printStackTrace();
            System.out.println("ERR -ClassUtil::findClass ExceptionInInitailizerError:" + String.valueOf(e.getException()));
            System.out.println("ERR -ClassUtil::findClass ExceptionInInitailizerError:" + e.getException().getMessage());
            e.getException().printStackTrace();
        }
        catch (LinkageError e) {
            System.out.println("ERR -ClassUtil::findClass LinkageError:" + e.getMessage());
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("ERR -ClassUtil::findClass Throwable:" + e.getMessage());
            e.printStackTrace();
        }
        return clazz;
    }

    public static void setUserClasspath(String cp) {
        _userClasspath = cp == null ? "" : cp;
        ClassUtil.parseUserClasspath(cp);
        System.setProperty("java.class.path", System.getProperty("java.class.path") + PATH_SEP + cp);
    }

    public static String getUserClasspath() {
        return _userClasspath;
    }

    private static void parseUserClasspath(String cp) {
        if (cp == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cp, PATH_SEP);
        _urls = new URL[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreElements()) {
            Object nextToken = tok.nextToken();
            if (!((String)(nextToken = ((String)nextToken).replace('\\', '/'))).endsWith(".jar") && !((String)nextToken).endsWith("/")) {
                nextToken = (String)nextToken + "/";
            }
            try {
                if (!((String)nextToken).startsWith("/")) {
                    nextToken = "/" + (String)nextToken;
                }
                ClassUtil._urls[i] = new URL("file", "localhost", (String)nextToken);
                ++i;
            }
            catch (MalformedURLException e) {
                _urls = null;
                System.out.println("Invalid User-Defined Classpath\nThe user-defined classpath in <INSTALL_DIR>/resource/bridges/import/java/idljavabrc\nhas an invalid entry: " + (String)nextToken + "\nPlease correct the problem, restart, and try again.");
                e.printStackTrace();
            }
        }
    }

    static {
        PATH_SEP = System.getProperty("path.separator");
        _loader = null;
    }
}

