;  Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;------------------------------------------------
;   Routine to compute dither patterns to simulate levels of
;   transparency from 0% to 100% in 17 levels (0-16 inc)
;   Origin: "Computer Graphics Principles and Practice" (Foley vanDam ptII)
;   page 571 - "Halftone Approximation" (4x4 dither matrix)
;

function stipple_pattern, intensity

pat = lonarr(32)
case intensity of
    0: begin
        pat[0] = '00000000'xL
        pat[1] = '00000000'xL
        pat[2] = '00000000'xL
        pat[3] = '00000000'xL
        pat[4] = '00000000'xL
        pat[5] = '00000000'xL
        pat[6] = '00000000'xL
        pat[7] = '00000000'xL
        pat[8] = '00000000'xL
        pat[9] = '00000000'xL
        pat[10] = '00000000'xL
        pat[11] = '00000000'xL
        pat[12] = '00000000'xL
        pat[13] = '00000000'xL
        pat[14] = '00000000'xL
        pat[15] = '00000000'xL
        pat[16] = '00000000'xL
        pat[17] = '00000000'xL
        pat[18] = '00000000'xL
        pat[19] = '00000000'xL
        pat[20] = '00000000'xL
        pat[21] = '00000000'xL
        pat[22] = '00000000'xL
        pat[23] = '00000000'xL
        pat[24] = '00000000'xL
        pat[25] = '00000000'xL
        pat[26] = '00000000'xL
        pat[27] = '00000000'xL
        pat[28] = '00000000'xL
        pat[29] = '00000000'xL
        pat[30] = '00000000'xL
        pat[31] = '00000000'xL
        end
    1: begin
        pat[0] = '88888888'xL
        pat[1] = '00000000'xL
        pat[2] = '00000000'xL
        pat[3] = '00000000'xL
        pat[4] = '88888888'xL
        pat[5] = '00000000'xL
        pat[6] = '00000000'xL
        pat[7] = '00000000'xL
        pat[8] = '88888888'xL
        pat[9] = '00000000'xL
        pat[10] = '00000000'xL
        pat[11] = '00000000'xL
        pat[12] = '88888888'xL
        pat[13] = '00000000'xL
        pat[14] = '00000000'xL
        pat[15] = '00000000'xL
        pat[16] = '88888888'xL
        pat[17] = '00000000'xL
        pat[18] = '00000000'xL
        pat[19] = '00000000'xL
        pat[20] = '88888888'xL
        pat[21] = '00000000'xL
        pat[22] = '00000000'xL
        pat[23] = '00000000'xL
        pat[24] = '88888888'xL
        pat[25] = '00000000'xL
        pat[26] = '00000000'xL
        pat[27] = '00000000'xL
        pat[28] = '88888888'xL
        pat[29] = '00000000'xL
        pat[30] = '00000000'xL
        pat[31] = '00000000'xL
        end
    2: begin
        pat[0] = '88888888'xL
        pat[1] = '00000000'xL
        pat[2] = '22222222'xL
        pat[3] = '00000000'xL
        pat[4] = '88888888'xL
        pat[5] = '00000000'xL
        pat[6] = '22222222'xL
        pat[7] = '00000000'xL
        pat[8] = '88888888'xL
        pat[9] = '00000000'xL
        pat[10] = '22222222'xL
        pat[11] = '00000000'xL
        pat[12] = '88888888'xL
        pat[13] = '00000000'xL
        pat[14] = '22222222'xL
        pat[15] = '00000000'xL
        pat[16] = '88888888'xL
        pat[17] = '00000000'xL
        pat[18] = '22222222'xL
        pat[19] = '00000000'xL
        pat[20] = '88888888'xL
        pat[21] = '00000000'xL
        pat[22] = '22222222'xL
        pat[23] = '00000000'xL
        pat[24] = '88888888'xL
        pat[25] = '00000000'xL
        pat[26] = '22222222'xL
        pat[27] = '00000000'xL
        pat[28] = '88888888'xL
        pat[29] = '00000000'xL
        pat[30] = '22222222'xL
        pat[31] = '00000000'xL
        end
    3: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '00000000'xL
        pat[2] = '22222222'xL
        pat[3] = '00000000'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '00000000'xL
        pat[6] = '22222222'xL
        pat[7] = '00000000'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '00000000'xL
        pat[10] = '22222222'xL
        pat[11] = '00000000'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '00000000'xL
        pat[14] = '22222222'xL
        pat[15] = '00000000'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '00000000'xL
        pat[18] = '22222222'xL
        pat[19] = '00000000'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '00000000'xL
        pat[22] = '22222222'xL
        pat[23] = '00000000'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '00000000'xL
        pat[26] = '22222222'xL
        pat[27] = '00000000'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '00000000'xL
        pat[30] = '22222222'xL
        pat[31] = '00000000'xL
        end
    4: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '00000000'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '00000000'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '00000000'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '00000000'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '00000000'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '00000000'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '00000000'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '00000000'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '00000000'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '00000000'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '00000000'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '00000000'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '00000000'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '00000000'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '00000000'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '00000000'xL
        end
    5: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '44444444'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '00000000'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '44444444'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '00000000'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '44444444'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '00000000'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '44444444'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '00000000'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '44444444'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '00000000'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '44444444'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '00000000'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '44444444'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '00000000'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '44444444'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '00000000'xL
        end
    6: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '44444444'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '11111111'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '44444444'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '11111111'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '44444444'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '11111111'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '44444444'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '11111111'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '44444444'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '11111111'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '44444444'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '11111111'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '44444444'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '11111111'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '44444444'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '11111111'xL
        end
    7: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '55555555'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '11111111'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '55555555'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '11111111'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '55555555'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '11111111'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '55555555'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '11111111'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '55555555'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '11111111'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '55555555'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '11111111'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '55555555'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '11111111'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '55555555'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '11111111'xL
        end
    8: begin
        pat[0] = 'aaaaaaaa'xL
        pat[1] = '55555555'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '55555555'xL
        pat[4] = 'aaaaaaaa'xL
        pat[5] = '55555555'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '55555555'xL
        pat[8] = 'aaaaaaaa'xL
        pat[9] = '55555555'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '55555555'xL
        pat[12] = 'aaaaaaaa'xL
        pat[13] = '55555555'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '55555555'xL
        pat[16] = 'aaaaaaaa'xL
        pat[17] = '55555555'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '55555555'xL
        pat[20] = 'aaaaaaaa'xL
        pat[21] = '55555555'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '55555555'xL
        pat[24] = 'aaaaaaaa'xL
        pat[25] = '55555555'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '55555555'xL
        pat[28] = 'aaaaaaaa'xL
        pat[29] = '55555555'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '55555555'xL
        end
    9: begin
        pat[0] = 'eeeeeeee'xL
        pat[1] = '55555555'xL
        pat[2] = 'aaaaaaaa'xL
        pat[3] = '55555555'xL
        pat[4] = 'eeeeeeee'xL
        pat[5] = '55555555'xL
        pat[6] = 'aaaaaaaa'xL
        pat[7] = '55555555'xL
        pat[8] = 'eeeeeeee'xL
        pat[9] = '55555555'xL
        pat[10] = 'aaaaaaaa'xL
        pat[11] = '55555555'xL
        pat[12] = 'eeeeeeee'xL
        pat[13] = '55555555'xL
        pat[14] = 'aaaaaaaa'xL
        pat[15] = '55555555'xL
        pat[16] = 'eeeeeeee'xL
        pat[17] = '55555555'xL
        pat[18] = 'aaaaaaaa'xL
        pat[19] = '55555555'xL
        pat[20] = 'eeeeeeee'xL
        pat[21] = '55555555'xL
        pat[22] = 'aaaaaaaa'xL
        pat[23] = '55555555'xL
        pat[24] = 'eeeeeeee'xL
        pat[25] = '55555555'xL
        pat[26] = 'aaaaaaaa'xL
        pat[27] = '55555555'xL
        pat[28] = 'eeeeeeee'xL
        pat[29] = '55555555'xL
        pat[30] = 'aaaaaaaa'xL
        pat[31] = '55555555'xL
        end
    10: begin
        pat[0] = 'eeeeeeee'xL
        pat[1] = '55555555'xL
        pat[2] = 'bbbbbbbb'xL
        pat[3] = '55555555'xL
        pat[4] = 'eeeeeeee'xL
        pat[5] = '55555555'xL
        pat[6] = 'bbbbbbbb'xL
        pat[7] = '55555555'xL
        pat[8] = 'eeeeeeee'xL
        pat[9] = '55555555'xL
        pat[10] = 'bbbbbbbb'xL
        pat[11] = '55555555'xL
        pat[12] = 'eeeeeeee'xL
        pat[13] = '55555555'xL
        pat[14] = 'bbbbbbbb'xL
        pat[15] = '55555555'xL
        pat[16] = 'eeeeeeee'xL
        pat[17] = '55555555'xL
        pat[18] = 'bbbbbbbb'xL
        pat[19] = '55555555'xL
        pat[20] = 'eeeeeeee'xL
        pat[21] = '55555555'xL
        pat[22] = 'bbbbbbbb'xL
        pat[23] = '55555555'xL
        pat[24] = 'eeeeeeee'xL
        pat[25] = '55555555'xL
        pat[26] = 'bbbbbbbb'xL
        pat[27] = '55555555'xL
        pat[28] = 'eeeeeeee'xL
        pat[29] = '55555555'xL
        pat[30] = 'bbbbbbbb'xL
        pat[31] = '55555555'xL
        end
    11: begin
        pat[0] = 'ffffffff'xL
        pat[1] = '55555555'xL
        pat[2] = 'bbbbbbbb'xL
        pat[3] = '55555555'xL
        pat[4] = 'ffffffff'xL
        pat[5] = '55555555'xL
        pat[6] = 'bbbbbbbb'xL
        pat[7] = '55555555'xL
        pat[8] = 'ffffffff'xL
        pat[9] = '55555555'xL
        pat[10] = 'bbbbbbbb'xL
        pat[11] = '55555555'xL
        pat[12] = 'ffffffff'xL
        pat[13] = '55555555'xL
        pat[14] = 'bbbbbbbb'xL
        pat[15] = '55555555'xL
        pat[16] = 'ffffffff'xL
        pat[17] = '55555555'xL
        pat[18] = 'bbbbbbbb'xL
        pat[19] = '55555555'xL
        pat[20] = 'ffffffff'xL
        pat[21] = '55555555'xL
        pat[22] = 'bbbbbbbb'xL
        pat[23] = '55555555'xL
        pat[24] = 'ffffffff'xL
        pat[25] = '55555555'xL
        pat[26] = 'bbbbbbbb'xL
        pat[27] = '55555555'xL
        pat[28] = 'ffffffff'xL
        pat[29] = '55555555'xL
        pat[30] = 'bbbbbbbb'xL
        pat[31] = '55555555'xL
        end
    12: begin
        pat[0] = 'ffffffff'xL
        pat[1] = '55555555'xL
        pat[2] = 'ffffffff'xL
        pat[3] = '55555555'xL
        pat[4] = 'ffffffff'xL
        pat[5] = '55555555'xL
        pat[6] = 'ffffffff'xL
        pat[7] = '55555555'xL
        pat[8] = 'ffffffff'xL
        pat[9] = '55555555'xL
        pat[10] = 'ffffffff'xL
        pat[11] = '55555555'xL
        pat[12] = 'ffffffff'xL
        pat[13] = '55555555'xL
        pat[14] = 'ffffffff'xL
        pat[15] = '55555555'xL
        pat[16] = 'ffffffff'xL
        pat[17] = '55555555'xL
        pat[18] = 'ffffffff'xL
        pat[19] = '55555555'xL
        pat[20] = 'ffffffff'xL
        pat[21] = '55555555'xL
        pat[22] = 'ffffffff'xL
        pat[23] = '55555555'xL
        pat[24] = 'ffffffff'xL
        pat[25] = '55555555'xL
        pat[26] = 'ffffffff'xL
        pat[27] = '55555555'xL
        pat[28] = 'ffffffff'xL
        pat[29] = '55555555'xL
        pat[30] = 'ffffffff'xL
        pat[31] = '55555555'xL
        end
    13: begin
        pat[0] = 'ffffffff'xL
        pat[1] = 'dddddddd'xL
        pat[2] = 'ffffffff'xL
        pat[3] = '55555555'xL
        pat[4] = 'ffffffff'xL
        pat[5] = 'dddddddd'xL
        pat[6] = 'ffffffff'xL
        pat[7] = '55555555'xL
        pat[8] = 'ffffffff'xL
        pat[9] = 'dddddddd'xL
        pat[10] = 'ffffffff'xL
        pat[11] = '55555555'xL
        pat[12] = 'ffffffff'xL
        pat[13] = 'dddddddd'xL
        pat[14] = 'ffffffff'xL
        pat[15] = '55555555'xL
        pat[16] = 'ffffffff'xL
        pat[17] = 'dddddddd'xL
        pat[18] = 'ffffffff'xL
        pat[19] = '55555555'xL
        pat[20] = 'ffffffff'xL
        pat[21] = 'dddddddd'xL
        pat[22] = 'ffffffff'xL
        pat[23] = '55555555'xL
        pat[24] = 'ffffffff'xL
        pat[25] = 'dddddddd'xL
        pat[26] = 'ffffffff'xL
        pat[27] = '55555555'xL
        pat[28] = 'ffffffff'xL
        pat[29] = 'dddddddd'xL
        pat[30] = 'ffffffff'xL
        pat[31] = '55555555'xL
        end
    14: begin
        pat[0] = 'ffffffff'xL
        pat[1] = 'dddddddd'xL
        pat[2] = 'ffffffff'xL
        pat[3] = '77777777'xL
        pat[4] = 'ffffffff'xL
        pat[5] = 'dddddddd'xL
        pat[6] = 'ffffffff'xL
        pat[7] = '77777777'xL
        pat[8] = 'ffffffff'xL
        pat[9] = 'dddddddd'xL
        pat[10] = 'ffffffff'xL
        pat[11] = '77777777'xL
        pat[12] = 'ffffffff'xL
        pat[13] = 'dddddddd'xL
        pat[14] = 'ffffffff'xL
        pat[15] = '77777777'xL
        pat[16] = 'ffffffff'xL
        pat[17] = 'dddddddd'xL
        pat[18] = 'ffffffff'xL
        pat[19] = '77777777'xL
        pat[20] = 'ffffffff'xL
        pat[21] = 'dddddddd'xL
        pat[22] = 'ffffffff'xL
        pat[23] = '77777777'xL
        pat[24] = 'ffffffff'xL
        pat[25] = 'dddddddd'xL
        pat[26] = 'ffffffff'xL
        pat[27] = '77777777'xL
        pat[28] = 'ffffffff'xL
        pat[29] = 'dddddddd'xL
        pat[30] = 'ffffffff'xL
        pat[31] = '77777777'xL
        end
    15: begin
        pat[0] = 'ffffffff'xL
        pat[1] = 'ffffffff'xL
        pat[2] = 'ffffffff'xL
        pat[3] = '77777777'xL
        pat[4] = 'ffffffff'xL
        pat[5] = 'ffffffff'xL
        pat[6] = 'ffffffff'xL
        pat[7] = '77777777'xL
        pat[8] = 'ffffffff'xL
        pat[9] = 'ffffffff'xL
        pat[10] = 'ffffffff'xL
        pat[11] = '77777777'xL
        pat[12] = 'ffffffff'xL
        pat[13] = 'ffffffff'xL
        pat[14] = 'ffffffff'xL
        pat[15] = '77777777'xL
        pat[16] = 'ffffffff'xL
        pat[17] = 'ffffffff'xL
        pat[18] = 'ffffffff'xL
        pat[19] = '77777777'xL
        pat[20] = 'ffffffff'xL
        pat[21] = 'ffffffff'xL
        pat[22] = 'ffffffff'xL
        pat[23] = '77777777'xL
        pat[24] = 'ffffffff'xL
        pat[25] = 'ffffffff'xL
        pat[26] = 'ffffffff'xL
        pat[27] = '77777777'xL
        pat[28] = 'ffffffff'xL
        pat[29] = 'ffffffff'xL
        pat[30] = 'ffffffff'xL
        pat[31] = '77777777'xL
        end
    16: begin
        pat[0] = 'ffffffff'xL
        pat[1] = 'ffffffff'xL
        pat[2] = 'ffffffff'xL
        pat[3] = 'ffffffff'xL
        pat[4] = 'ffffffff'xL
        pat[5] = 'ffffffff'xL
        pat[6] = 'ffffffff'xL
        pat[7] = 'ffffffff'xL
        pat[8] = 'ffffffff'xL
        pat[9] = 'ffffffff'xL
        pat[10] = 'ffffffff'xL
        pat[11] = 'ffffffff'xL
        pat[12] = 'ffffffff'xL
        pat[13] = 'ffffffff'xL
        pat[14] = 'ffffffff'xL
        pat[15] = 'ffffffff'xL
        pat[16] = 'ffffffff'xL
        pat[17] = 'ffffffff'xL
        pat[18] = 'ffffffff'xL
        pat[19] = 'ffffffff'xL
        pat[20] = 'ffffffff'xL
        pat[21] = 'ffffffff'xL
        pat[22] = 'ffffffff'xL
        pat[23] = 'ffffffff'xL
        pat[24] = 'ffffffff'xL
        pat[25] = 'ffffffff'xL
        pat[26] = 'ffffffff'xL
        pat[27] = 'ffffffff'xL
        pat[28] = 'ffffffff'xL
        pat[29] = 'ffffffff'xL
        pat[30] = 'ffffffff'xL
        pat[31] = 'ffffffff'xL
        end
    endcase

return, pat
end

