# Copyright (c)  NV5 Geospatial Solutions, Inc. All
# rights reserved. This software includes information which is
# proprietary to and a trade secret of NV5 Geospatial Solutions, Inc.
# It is not to be disclosed to anyone outside of this organization.
# Reproduction by any means whatsoever is prohibited without express
# written permission.
#
import sys
import os
from subprocess import check_call
from platform import machine

print("Setting up the Python->IDL bridge...\n")
setupPath = os.path.dirname(os.path.realpath(__file__))

if sys.platform == 'win32' or sys.platform == 'linux':
    setupPath = setupPath.replace('\\', '/')
    print('No setup needed. To use the Python->IDL bridge, add the')
    print('following three lines to the top of your Python script:\n')
    print('import sys')
    print(f'sys.path.append(\'{setupPath}\')')
    print('from idlpy import *\n')
    exit()
elif sys.platform != 'darwin':
    print(f'unknown platform: {sys.platform}')
    exit()

# The rest of this setup script is for Mac.
# For Mac we need to add a symbolic link from IDL's bin directory
# to the Python library location.

idlbinPath = os.path.realpath(setupPath + r'/../../bin')
if machine() == 'x86_64':
    bindir = 'bin.darwin.x86_64'
elif machine() == 'arm64':
    bindir = 'bin.darwin.arm64'
else:
    print(f'unknown machine: {machine()}')
    exit()

idlbinPath = os.path.join(idlbinPath, bindir)

def findfile(name, paths):
    for path in paths:
        for root, dirs, files in os.walk(path):
            if name in files:
                return os.path.join(root, name)

# Dynamically construct the library name from the Python major.minor version.
vmajor = str(sys.version_info[0])
vminor = str(sys.version_info[1])
pylib = "libpython" + vmajor + "." + vminor
if int(vminor) <= 7:
    pylib += 'm'
pylib += ".dylib"
pylibpath = findfile(pylib, [sys.prefix + "/lib"])

print("Setting Python library location within IDL libraries:")

if pylibpath == None:
    print("\n*** Unable to locate Python library: " + pylib)
    print("    Try installing a Python distribution such as 'Anaconda'.\n")
    exit()

try:
    cmd = ["ln", "-s", pylibpath, f'{idlbinPath}/{pylib}']
    print("\n" + " ".join(cmd))
    check_call(cmd)
except Exception as e:
    print("\n*** symbolic link failed.")
    print("*** Check the paths above, or run the script as 'sudo python setup.py'.")
    exit()

print("\nSetup is complete.")
