import importlib.metadata

def getPackagesLicenses(package=None):
    output = {}
    packages = importlib.metadata.distributions()
    for pkg in packages:
            package_name = pkg.metadata['Name']
            package_version = pkg.metadata['Version']
            if package is None or str(package_name).startswith(package):
                metadata = pkg.metadata
                license = metadata['License'] if metadata['License'] is not None else ''
                classifier_license = None
                for v in metadata.values():
                    if 'License ::' in v and classifier_license is None:
                        classifier_license = v
                output[package_name] = { 'version' : package_version, 'license' : classifier_license , 'short_license' : license }
    return output
