<!DOCTYPE DCF>
<assistantconfig version="3.3.0" >
	<profile>
		<property name="name" >DAVE Help</property>
		<property name="title" >DAVE Help</property>
		<property name="startpage" >./dave_home.html</property>
		<property name="assistantdocs" >.</property>
	</profile>
	<DCF title="IDL iTool User's Guide" ref="iTool_Users_Guide.html" >
    <section title="iTool User's Guide" ref="iTool_Users_Guide.html" >
      <section title="Introducing the IDL iTools" ref="Introducing_the_IDL_iTools.html" >
        <section title="Introducing the iTools " ref="IT_INTRO.html" />
        <section title="Using This Guide" ref="Using_This_Guide.html" />
      </section>
      <section title="Importing and Exporting Data" ref="Importing_and_Exporting_Data.html" >
        <keyword ref="IT_DATAMANAGER.html#wp1012324" >data manager</keyword>
        <keyword ref="IT_DATAMANAGER.html#wp1012324" >data:manager</keyword>
        <section title="About the Data Manager " ref="IT_DATAMANAGER.html" >
          <section title="Data Manager Interface" ref="IT_DATAMANAGER.html#wp1012737" />
          <section title="Data Item Management" ref="IT_DATAMANAGER.html#wp1009713" />
        </section>
        <section title="Data Import Methods " ref="IT_DATA_IMPORT.html" >
          <keyword ref="IT_DATA_IMPORT.html#wp1007591" >data:importing in iTool</keyword>
          <keyword ref="IT_DATA_IMPORT.html#wp1007591" >importing:data in iTool</keyword>
          <section title="Using the Data Import Wizard " ref="IT_DATA_WIZ.html" />
          <section title="Using File Open" ref="Using_File_Open.html" />
          <section title="Using the Data Manager Dialog" ref="Using_the_Data_Manager_Dialog.html" />
        </section>
        <section title="Importing Data from a File" ref="Importing_Data_from_a_File.html" >
          <section title="Importing Image Data" ref="Importing_Data_from_a_File.html#wp1012993" />
          <section title="Importing ASCII Data" ref="Importing_Data_from_a_File.html#wp1004502" />
          <section title="Importing Binary Data" ref="Importing_Data_from_a_File.html#wp1006508" />
          <section title="Importing Shapefile Data" ref="Importing_Data_from_a_File.html#wp1013070" />
        </section>
        <section title="Working with Unknown Data " ref="IT_DATA_UNKNOWN.html" >
          <section title="Using the Gridding Wizard" ref="IT_DATA_UNKNOWN.html#wp1012558" />
        </section>
        <section title="Importing Data from the IDL Session" ref="Importing_Data_from_the_IDL_Session.html" >
          <section title="Importing Graphic Objects" ref="Importing_Data_from_the_IDL_Session.html#wp1013503" />
          <section title="Parameter Data and the Command Line" ref="Importing_Data_from_the_IDL_Session.html#wp1012355" />
        </section>
        <section title="Exporting Data " ref="IT_DATA_EXPORT.html" >
          <section title="Exporting Data to a File" ref="Exporting_Data_to_a_File.html" />
          <section title="Exporting Data to the IDL Session" ref="Exporting_Data_to_the_IDL_Session.html" />
        </section>
      </section>
      <section title="Visualizations" ref="Visualizations.html" >
        <section title="About Visualizations" ref="About_Visualizations.html" >
          <keyword ref="About_Visualizations.html#wp1012445" >visualizations:definition of</keyword>
        </section>
        <section title="Visualization Creation Methods" ref="Visualization_Creation_Methods.html" >
          <keyword ref="Visualization_Creation_Methods.html#wp1012447" >visualizations:creating</keyword>
          <section title="Creating Visualizations Automatically" ref="Visualization_Creation_Methods.html#wp1012449" />
          <section title="Inserting Visualizations " ref="IT_INSERT_VIZ.html" >
            <keyword ref="IT_INSERT_VIZ.html#wp1012539" >visualizations:inserting</keyword>
            <keyword ref="IT_INSERT_VIZ.html#wp1012539" >iTools:inserting a visualization</keyword>
          </section>
        </section>
        <section title="Modifying Existing Visualizations " ref="IT_PARAM_EDIT.html" >
          <keyword ref="IT_PARAM_EDIT.html#wp1012496" >visualizations:modifying</keyword>
          <section title="The Parameter Editor" ref="IT_PARAM_EDIT.html#wp1013242" >
            <keyword ref="IT_PARAM_EDIT.html#wp1013243" >parameter editor</keyword>
            <keyword ref="IT_PARAM_EDIT.html#wp1013243" >parameters:editor</keyword>
          </section>
          <section title="Removing Data Associations" ref="IT_PARAM_EDIT.html#wp1012458" >
            <keyword ref="IT_PARAM_EDIT.html#wp1013086" >data associations:removing</keyword>
          </section>
          <section title="Replacing Data Associations" ref="IT_PARAM_EDIT.html#wp1013120" >
            <keyword ref="IT_PARAM_EDIT.html#wp1013121" >data associations:replacing</keyword>
          </section>
        </section>
        <section title="Exporting Visualizations" ref="Exporting_Visualizations.html" >
          <keyword ref="Exporting_Visualizations.html#wp1012461" >visualizations:exporting</keyword>
          <section title="Exporting to a File" ref="Exporting_Visualizations.html#wp1012438" />
        </section>
      </section>
      <section title="Manipulating the Display" ref="Manipulating_the_Display.html" >
        <section title="Introduction" ref="Introductionhpc.html" />
        <section title="Selection of Objects" ref="Selection_of_Objects.html" >
          <keyword ref="Selection_of_Objects.html#wp1004936" >objects:selecting</keyword>
          <keyword ref="Selection_of_Objects.html#wp1004936" >selecting:objects</keyword>
          <section title="Select All" ref="Selection_of_Objects.html#wp1006870" >
            <keyword ref="Selection_of_Objects.html#wp1006874" >objects:selecting all</keyword>
          </section>
        </section>
        <section title="Undo/Redo" ref="UndoRedo.html" >
          <keyword ref="UndoRedo.html#wp1004952" >undo iTool operation</keyword>
          <keyword ref="UndoRedo.html#wp1004952" >redo iTool operation</keyword>
        </section>
        <section title="Adding a Data Space" ref="Adding_a_Data_Space.html" >
          <keyword ref="Adding_a_Data_Space.html#wp1014899" >dataspace:adding</keyword>
        </section>
        <section title="Translation" ref="Translation.html" >
          <keyword ref="Translation.html#wp1005065" >translating:objects</keyword>
          <keyword ref="Translation.html#wp1005065" >objects:translating</keyword>
        </section>
        <section title="Scaling" ref="Scaling.html" >
          <keyword ref="Scaling.html#wp1009548" >scaling:objects</keyword>
          <keyword ref="Scaling.html#wp1009548" >objects:scaling</keyword>
          <keyword ref="Scaling.html#wp1008923" >scaling:constrained</keyword>
          <keyword ref="Scaling.html#wp1008923" >scaling:3-D objects</keyword>
          <keyword ref="Scaling.html#wp1008970" >scaling:unconstrained</keyword>
          <keyword ref="Scaling.html#wp1009584" >scaling:unconstrained 2-D objects</keyword>
          <keyword ref="Scaling.html#wp1009588" >scaling:unconstrained 3-D objects</keyword>
        </section>
        <section title="Zooming" ref="Zooming.html" >
          <keyword ref="Zooming.html#wp1006795" >zooming</keyword>
          <section title="Canvas Zoom" ref="Zooming.html#wp1005139" >
            <keyword ref="Zooming.html#wp1005140" >canvas zooming</keyword>
          </section>
          <section title="View Zoom" ref="Zooming.html#wp1005157" >
            <keyword ref="Zooming.html#wp1005158" >view zooming</keyword>
          </section>
        </section>
        <section title="View Panning" ref="View_Panning.html" />
        <section title="Window Layouts" ref="Window_Layouts.html" >
          <keyword ref="Window_Layouts.html#wp1016417" >window layout</keyword>
          <keyword ref="Window_Layouts.html#wp1016417" >layout window</keyword>
        </section>
      </section>
      <section title="Adding Annotations" ref="Adding_Annotations.html" >
        <section title="Introduction" ref="Introductionhps.html" />
        <section title="Legends" ref="Legends.html" >
          <keyword ref="Legends.html#wp1010406" >legends:adding</keyword>
        </section>
        <section title="Annotations" ref="Annotations.html" >
          <keyword ref="Annotations.html#wp1009864" >annotating:iTools:types of</keyword>
          <section title="Text Annotations" ref="Annotations.html#wp1011683" >
            <keyword ref="Annotations.html#wp1006347" >annotating:iTools:text</keyword>
            <keyword ref="Annotations.html#wp1006347" >text annotations</keyword>
          </section>
          <section title="Line Annotations" ref="Annotations.html#wp1006368" >
            <keyword ref="Annotations.html#wp1008621" >annotating:iTools:line type</keyword>
            <keyword ref="Annotations.html#wp1008621" >line annotations:adding</keyword>
          </section>
          <section title="Rectangle Annotations" ref="Annotations.html#wp1006415" >
            <keyword ref="Annotations.html#wp1008644" >annotating:iTools:rectangle type</keyword>
            <keyword ref="Annotations.html#wp1008644" >rectangle annotations:creating</keyword>
          </section>
          <section title="Oval Annotations" ref="Annotations.html#wp1006568" >
            <keyword ref="Annotations.html#wp1008656" >annotating:iTools:oval type</keyword>
            <keyword ref="Annotations.html#wp1008656" >oval annotations</keyword>
          </section>
          <section title="Polygon Annotations" ref="Annotations.html#wp1006669" >
            <keyword ref="Annotations.html#wp1008670" >annotating:iTools:polygon type</keyword>
            <keyword ref="Annotations.html#wp1008670" >polygon annotations:creating</keyword>
          </section>
          <section title="Freehand Annotations" ref="Annotations.html#wp1006705" >
            <keyword ref="Annotations.html#wp1008684" >annotating:iTools:freehand type</keyword>
            <keyword ref="Annotations.html#wp1008684" >freehand annotations:adding</keyword>
          </section>
        </section>
        <section title="Additional Axes" ref="Additional_Axes.html" >
          <keyword ref="Additional_Axes.html#wp1011088" >axes:adding to:iTools</keyword>
          <keyword ref="Additional_Axes.html#wp1011088" >adding:plot axis object</keyword>
        </section>
      </section>
      <section title="Property Sheets and Browsers" ref="Property_Sheets_and_Browsers.html" >
        <section title="Introduction" ref="Introductionhqg.html" />
        <section title="Property Sheets" ref="Property_Sheets.html" >
          <keyword ref="Property_Sheets.html#wp1013856" >properties:sheets:defined</keyword>
          <section title="Visualization Property Sheets" ref="Property_Sheets.html#wp1004690" >
            <keyword ref="Property_Sheets.html#wp1009472" >visualizations:property sheets</keyword>
            <keyword ref="Property_Sheets.html#wp1009472" >properties:sheets:visualization</keyword>
          </section>
          <section title="Operations Property Sheets" ref="Property_Sheets.html#wp1009251" >
            <keyword ref="Property_Sheets.html#wp1009476" >operations:property sheets</keyword>
            <keyword ref="Property_Sheets.html#wp1009476" >properties:sheets:operations</keyword>
          </section>
        </section>
        <section title="The Visualization Browser" ref="The_Visualization_Browser.html" >
          <keyword ref="The_Visualization_Browser.html#wp1005232" >visualizations:browser</keyword>
          <keyword ref="The_Visualization_Browser.html#wp1005232" >visualizations:object selection</keyword>
        </section>
        <section title="The Operations Browser" ref="The_Operations_Browser.html" >
          <keyword ref="The_Operations_Browser.html#wp1015253" >operations:browser</keyword>
        </section>
        <section title="The Preferences Browser " ref="ITOOL_PREFS_BROWSER.html" >
          <keyword ref="ITOOL_PREFS_BROWSER.html#wp1010179" >preferences:browser in iTools</keyword>
          <section title="General Settings " ref="ITOOL_PREFS_GENERAL.html" >
            <keyword ref="ITOOL_PREFS_GENERAL.html#wp1011430" >general settings, iTool preferences browser</keyword>
          </section>
          <section title="File Readers " ref="ITOOL_PREFS_FILEREAD.html" >
            <keyword ref="ITOOL_PREFS_FILEREAD.html#wp1012122" >reading:files</keyword>
          </section>
          <section title="File Writers " ref="ITOOL_PREFS_FILEWRITE.html" >
            <keyword ref="ITOOL_PREFS_FILEWRITE.html#wp1012552" >files:writing:file writers</keyword>
            <keyword ref="ITOOL_PREFS_FILEWRITE.html#wp1012552" >writing files</keyword>
          </section>
        </section>
      </section>
      <section title="Common Operations" ref="Common_Operations.html" >
        <section title="Introduction" ref="Introductionhqy.html" >
          <keyword ref="Introductiongvy.html#wp1005538" >iTools:common operations</keyword>
          <keyword ref="Introductiongvy.html#wp1005538" >operations:common</keyword>
        </section>
        <section title="File Operations" ref="File_Operations.html" >
          <keyword ref="File_Operations.html#wp1010065" >operations:file</keyword>
          <keyword ref="File_Operations.html#wp1010065" >files:operations</keyword>
          <section title="Opening Files" ref="File_Operations.html#wp1010708" />
          <section title="Importing Variables and Files" ref="File_Operations.html#wp1010783" />
          <section title="Saving Files" ref="File_Operations.html#wp1004754" />
          <section title="Exporting Variables and Files" ref="File_Operations.html#wp1004758" />
          <section title="Exiting the iTool" ref="File_Operations.html#wp1006896" />
        </section>
        <section title="Rotation" ref="Rotation.html" >
          <keyword ref="Rotation.html#wp1015056" >rotating:data</keyword>
          <section title="Mouse Rotation" ref="Rotation.html#wp1015058" >
            <keyword ref="Rotation.html#wp1015060" >rotating:with a mouse</keyword>
          </section>
          <section title="Rotate Left and Rotate Right" ref="Rotation.html#wp1015106" >
            <keyword ref="Rotation.html#wp1015108" >rotating:left</keyword>
            <keyword ref="Rotation.html#wp1015108" >rotating:right</keyword>
          </section>
          <section title="Rotate by Specified Angle" ref="Rotation.html#wp1015110" />
        </section>
        <section title="Transformations" ref="Transformations.html" >
          <keyword ref="Transformations.html#wp1015124" >transforming:data</keyword>
          <section title="Resample" ref="Transformations.html#wp1015126" >
            <keyword ref="Transformations.html#wp1015128" >transforming:resampling</keyword>
            <keyword ref="Transformations.html#wp1015128" >resampling:data</keyword>
          </section>
          <section title="Rotate Data" ref="Transformations.html#wp1015152" >
            <keyword ref="Transformations.html#wp1015154" >transforming:rotate data</keyword>
            <keyword ref="Transformations.html#wp1015154" >rotating:data</keyword>
          </section>
          <section title="Scale Data" ref="Transformations.html#wp1015169" >
            <keyword ref="Transformations.html#wp1015171" >transforming:scale data</keyword>
            <keyword ref="Transformations.html#wp1015171" >scaling:data</keyword>
          </section>
        </section>
        <section title="Filtering" ref="Filtering.html" >
          <keyword ref="Filtering.html#wp1015187" >filtering:data in iTools</keyword>
          <section title="Smooth Filter" ref="Filtering.html#wp1015189" >
            <keyword ref="Filtering.html#wp1015191" >filtering:smooth filter</keyword>
            <keyword ref="Filtering.html#wp1015191" >smooth filtering</keyword>
          </section>
          <section title="Median Filter" ref="Filtering.html#wp1015206" >
            <keyword ref="Filtering.html#wp1015208" >filtering:median</keyword>
            <keyword ref="Filtering.html#wp1015208" >median:filtering</keyword>
          </section>
          <section title="Convolution Filter" ref="Filtering.html#wp1015223" >
            <keyword ref="Filtering.html#wp1015225" >filtering:convolution</keyword>
            <keyword ref="Filtering.html#wp1015225" >convolution:filtering</keyword>
          </section>
          <section title="Unsharp Mask Filter" ref="Filtering.html#wp1015246" >
            <keyword ref="Filtering.html#wp1015247" >filtering:unsharp mask</keyword>
            <keyword ref="Filtering.html#wp1015247" >unsharp mask:filtering</keyword>
          </section>
        </section>
        <section title="Morphing" ref="Morphing.html" >
          <keyword ref="Morphing.html#wp1015264" >morphing:data</keyword>
        </section>
        <section title="Additional Operations" ref="Additional_Operations.html" >
          <section title="Plotting a Histogram" ref="Additional_Operations.html#wp1011707" >
            <keyword ref="Additional_Operations.html#wp1011708" >histogram:plot</keyword>
            <keyword ref="Additional_Operations.html#wp1011708" >plots:histogram</keyword>
          </section>
          <section title="Displaying Statistics" ref="Additional_Operations.html#wp1007756" >
            <keyword ref="Additional_Operations.html#wp1007126" >statistics:displaying</keyword>
            <keyword ref="Additional_Operations.html#wp1007126" >displaying:statistics</keyword>
          </section>
          <section title="Resetting Dataspace Ranges" ref="Resetting_Dataspace_Ranges.html" >
            <keyword ref="Resetting_Dataspace_Ranges.html#wp1011923" >dataspace:range resetting</keyword>
            <keyword ref="Resetting_Dataspace_Ranges.html#wp1011923" >resetting dataspace</keyword>
          </section>
        </section>
        <section title="Rendering Translucent Objects" ref="Rendering_Translucent_Objects.html" >
          <keyword ref="Rendering_Translucent_Objects.html#wp1015027" >translucent object rendering</keyword>
          <keyword ref="Rendering_Translucent_Objects.html#wp1015027" >objects:rendering translucent</keyword>
          <keyword ref="Rendering_Translucent_Objects.html#wp1015027" >rendering:translucent objects</keyword>
        </section>
        <section title="Operations on Regions of Interest" ref="Operations_on_Regions_of_Interest.html" >
          <keyword ref="Operations_on_Regions_of_Interest.html#wp1015520" >region of interest:operations and</keyword>
          <section title="Operations Modifying ROI Data" ref="Operations_on_Regions_of_Interest.html#wp1015525" />
          <section title="Operations Modifying ROI Vertices" ref="Operations_on_Regions_of_Interest.html#wp1015526" />
        </section>
        <section title="Printing" ref="ITOOLS_PRINTING.html" >
          <keyword ref="ITOOLS_PRINTING.html#wp1016552" >printing:iTools</keyword>
          <section title="Print Preview" ref="ITOOLS_PRINTING.html#wp1016565" />
        </section>
      </section>
      <section title="Working with Macros" ref="Working_with_Macros.html" >
        <section title="Introduction" ref="Introductionhsd.html" />
        <section title="What Are Macros?" ref="What_Are_Macros.html" >
          <keyword ref="What_Are_Macrosgze.html#wp1005410" >macros:iTool:definition</keyword>
        </section>
        <section title="Recording Macros " ref="ITOOL_MACRO_REC.html" >
          <keyword ref="ITOOL_MACRO_REC.html#wp1005552" >macros:iTool:recording</keyword>
          <section title="Capturing Intermediate Manipulations" ref="ITOOL_MACRO_REC.html#wp1015443" />
        </section>
        <section title="Running Macros " ref="ITOOL_MACRO_RUN.html" >
          <keyword ref="ITOOL_MACRO_RUN.html#wp1008015" >macros:iTool:running</keyword>
          <section title="Running from the Operations Menu" ref="ITOOL_MACRO_RUN.html#wp1004058" >
            <keyword ref="ITOOL_MACRO_RUN.html#wp1013600" >macros:iTool:running:Operations menu</keyword>
          </section>
          <section title="Running from the Macro Editor" ref="ITOOL_MACRO_RUN.html#wp1006105" >
            <keyword ref="ITOOL_MACRO_RUN.html#wp1006109" >macros:iTool:running:Macro Editor</keyword>
          </section>
          <section title="Running from the Command Line" ref="ITOOL_MACRO_RUN.html#wp1006126" >
            <keyword ref="ITOOL_MACRO_RUN.html#wp1005239" >macros:iTool:running:IDL command line</keyword>
          </section>
          <section title="Using the Macro Controls Dialog" ref="ITOOL_MACRO_RUN.html#wp1014498" >
            <keyword ref="ITOOL_MACRO_RUN.html#wp1014502" >Macro Controls dialog</keyword>
          </section>
        </section>
        <section title="Using the Macro Editor " ref="ITOOL_MACRO_EDIT.html" >
          <keyword ref="ITOOL_MACRO_EDIT.html#wp1004401" >Macro Editor:using</keyword>
          <section title="Understanding the Macro Editor" ref="ITOOL_MACRO_EDIT.html#wp1011677" >
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1008231" >Macro Editor:menu bar</keyword>
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1004280" >Macro Editor:macro tree</keyword>
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1007644" >Macro Editor:macro property sheet</keyword>
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1006779" >Macro Editor:source tree</keyword>
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1006794" >Macro Editor:source property sheet</keyword>
            <keyword ref="ITOOL_MACRO_EDIT.html#wp1004636" >Macro Editor:Add and Remove buttons</keyword>
          </section>
        </section>
        <section title="Understanding Items in the Macro Editor" ref="Understanding_Items_in_the_Macro_Editor.html" >
          <section title="Macro Items" ref="Understanding_Items_in_the_Macro_Editor.html#wp1008211" >
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1011339" >Macro Editor:items:macro</keyword>
          </section>
          <section title="Source Items" ref="Understanding_Items_in_the_Macro_Editor.html#wp1011361" >
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1006543" >Macro Editor:items:history</keyword>
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1007226" >Macro Editor:items:visualization</keyword>
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1007230" >Macro Editor:items:annotation</keyword>
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1013942" >Macro Editor:items:Macro Tools</keyword>
            <keyword ref="Understanding_Items_in_the_Macro_Editor.html#wp1007234" >Macro Editor:items:Tool Menus</keyword>
          </section>
        </section>
        <section title="Making Selection and Tool Changes" ref="Making_Selection_and_Tool_Changes.html" >
          <section title="Macro Type Based on Recording Selection" ref="Making_Selection_and_Tool_Changes.html#wp1007974" >
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007980" >macros:iTool:types</keyword>
          </section>
          <section title="About Containers" ref="Making_Selection_and_Tool_Changes.html#wp1007507" >
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007509" >containers:definition</keyword>
          </section>
          <section title="Selection Changes" ref="Making_Selection_and_Tool_Changes.html#wp1004511" >
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007537" >macros:iTool:Selection Change operation</keyword>
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007605" >macros:iTool:Selection Change operation</keyword>
          </section>
          <section title="Tool Changes" ref="Making_Selection_and_Tool_Changes.html#wp1004517" >
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007812" >macros:iTool:Tool Change operation</keyword>
            <keyword ref="Making_Selection_and_Tool_Changes.html#wp1007546" >macros:iTool:Tool Change operation</keyword>
          </section>
        </section>
        <section title="Importing and Exporting Macros" ref="Importing_and_Exporting_Macros.html" >
          <keyword ref="Importing_and_Exporting_Macros.html#wp1005874" >macros:iTool:importing</keyword>
          <keyword ref="Importing_and_Exporting_Macros.html#wp1005855" >macros:iTool:exporting</keyword>
        </section>
      </section>
      <section title="Working with Styles" ref="Working_with_Styles.html" >
        <section title="What Are Styles?" ref="What_Are_Styles.html" >
          <keyword ref="What_Are_Styles.html#wp1072871" >styles:definition</keyword>
          <section title="Type of Styles" ref="What_Are_Styles.html#wp1072930" >
            <keyword ref="What_Are_Styles.html#wp1073250" >styles:types</keyword>
          </section>
          <section title="Applying a Style" ref="What_Are_Styles.html#wp1076293" >
            <keyword ref="What_Are_Styles.html#wp1076297" >styles:applying</keyword>
          </section>
        </section>
        <section title="Creating Styles " ref="ITOOL_STYLE_CREATE.html" >
          <keyword ref="ITOOL_STYLE_CREATE.html#wp1076304" >styles:creating</keyword>
          <section title="Creating a Style from the Current Visualization" ref="ITOOL_STYLE_CREATE.html#wp1076305" />
          <section title="Creating a New Style from the Style Editor" ref="ITOOL_STYLE_CREATE.html#wp1076362" />
          <section title="Working with the Current Style" ref="ITOOL_STYLE_CREATE.html#wp1076383" >
            <keyword ref="ITOOL_STYLE_CREATE.html#wp1076384" >styles:current style</keyword>
          </section>
          <section title="Copying an Existing Style" ref="ITOOL_STYLE_CREATE.html#wp1076393" >
            <keyword ref="ITOOL_STYLE_CREATE.html#wp1076394" >styles:copying</keyword>
          </section>
        </section>
        <section title="Applying Styles " ref="ITOOL_STYLE_APPLY.html" >
          <section title="Applying a Style to a Selected Item" ref="ITOOL_STYLE_APPLY.html#wp1075909" />
          <section title="Applying a Style to All Items" ref="ITOOL_STYLE_APPLY.html#wp1075913" />
          <section title="Applying a Style When Launching an iTool" ref="ITOOL_STYLE_APPLY.html#wp1075915" />
        </section>
        <section title="Editing Styles " ref="ITOOL_STYLE_EDIT.html" >
          <keyword ref="ITOOL_STYLE_EDIT.html#wp1080818" >styles:editing</keyword>
          <section title="Copying Properties Within Styles" ref="ITOOL_STYLE_EDIT.html#wp1073054" />
          <section title="Cutting and Deleting Properties within Styles" ref="ITOOL_STYLE_EDIT.html#wp1073818" />
          <section title="Selecting Multiple Properties for Editing" ref="ITOOL_STYLE_EDIT.html#wp1073811" />
        </section>
        <section title="Setting the Default Style" ref="Setting_the_Default_Style.html" >
          <keyword ref="Setting_the_Default_Style.html#wp1073196" >styles:default style</keyword>
        </section>
        <section title="Importing and Exporting Styles" ref="Importing_and_Exporting_Styles.html" >
          <keyword ref="Importing_and_Exporting_Styles.html#wp1073281" >styles:importing</keyword>
          <keyword ref="Importing_and_Exporting_Styles.html#wp1073281" >styles:exporting</keyword>
          <section title="Exporting a File to Share" ref="Importing_and_Exporting_Styles.html#wp1077362" />
          <section title="Importing a Received File" ref="Importing_and_Exporting_Styles.html#wp1077367" />
        </section>
      </section>
      <section title="Working with Images" ref="Working_with_Images.html" >
        <keyword ref="Working_with_Images.html#wp1011764" >images:in iImage. See iImage images</keyword>
        <section title="Introduction" ref="Introductionhuh.html" />
        <section title="Displaying Images" ref="Displaying_Images.html" >
          <keyword ref="Displaying_Images.html#wp1011854" >image display:in iImage</keyword>
          <keyword ref="Displaying_Images.html#wp1011854" >displaying:images:in iImage</keyword>
          <keyword ref="Displaying_Images.html#wp1011854" >iImage images:displaying</keyword>
          <keyword ref="Displaying_Images.html#wp1011854" >images:displaying. See image display</keyword>
          <section title="Displaying Multiple Images" ref="Displaying_Images.html#wp1011887" >
            <keyword ref="Displaying_Images.html#wp1011889" >image display:multiple images</keyword>
            <keyword ref="Displaying_Images.html#wp1011889" >iImage images:displaying multiple</keyword>
          </section>
        </section>
        <section title="Using the Image Panel" ref="Using_the_Image_Panel.html" >
          <keyword ref="Using_the_Image_Panel.html#wp1011924" >image panel (IIMAGE)</keyword>
          <keyword ref="Using_the_Image_Panel.html#wp1011924" >panel:IIMAGE</keyword>
          <keyword ref="Using_the_Image_Panel.html#wp1011945" >iImage images:window level control</keyword>
          <keyword ref="Using_the_Image_Panel.html#wp1011945" >window level control</keyword>
          <section title="Image ROIs" ref="Using_the_Image_Panel.html#wp1011950" >
            <keyword ref="Using_the_Image_Panel.html#wp1011951" >iImage images:ROIs</keyword>
          </section>
          <section title="The Palette Editor" ref="Using_the_Image_Panel.html#wp1011962" >
            <keyword ref="Using_the_Image_Panel.html#wp1011964" >colors:in iImage</keyword>
            <keyword ref="Using_the_Image_Panel.html#wp1011964" >iImage tool:color in</keyword>
          </section>
          <section title="Window Level Control" ref="Using_the_Image_Panel.html#wp1011972" >
            <keyword ref="Using_the_Image_Panel.html#wp1011974" >iImage images:brightness</keyword>
          </section>
        </section>
        <section title="Image Properties" ref="Image_Properties.html" >
          <keyword ref="Image_Properties.html#wp1011977" >iImage images:modifying properties</keyword>
          <section title="Modifying Properties" ref="Image_Properties.html#wp1011981" />
        </section>
        <section title="Adding a Colorbar" ref="Adding_a_Colorbar.html" >
          <keyword ref="Adding_a_Colorbar.html#wp1011989" >colorbars:adding to:images</keyword>
          <keyword ref="Adding_a_Colorbar.html#wp1011989" >iImage images:adding:colorbar</keyword>
        </section>
        <section title="Adding Axes" ref="Adding_Axes.html" >
          <keyword ref="Adding_Axes.html#wp1012001" >axes:adding to:images</keyword>
          <keyword ref="Adding_Axes.html#wp1012001" >iImage images:adding:axis</keyword>
        </section>
        <section title="Resampling an Image" ref="Resampling_an_Image.html" >
          <keyword ref="Resampling_an_Image.html#wp1012014" >resampling:images</keyword>
          <keyword ref="Resampling_an_Image.html#wp1012014" >iImage images:resampling</keyword>
        </section>
        <section title="Filtering an Image" ref="Filtering_an_Image.html" >
          <keyword ref="Filtering_an_Image.html#wp1012025" >iImage images:filtering</keyword>
          <keyword ref="Filtering_an_Image.html#wp1012025" >filtering:images in iImage</keyword>
          <section title="Convolving an Image" ref="Filtering_an_Image.html#wp1012026" />
          <section title="Applying a Median Filter" ref="Filtering_an_Image.html#wp1012044" />
          <section title="Smoothing an Image" ref="Filtering_an_Image.html#wp1012053" />
          <section title="Applying a Sobel Filter" ref="Filtering_an_Image.html#wp1012068" >
            <section title="Applying a Roberts Filter" ref="Filtering_an_Image.html#wp1012062" />
          </section>
          <section title="Applying an Unsharp Mask" ref="Filtering_an_Image.html#wp1012074" />
        </section>
        <section title="Applying a Morphological Operator" ref="Applying_a_Morphological_Operator.html" >
          <keyword ref="Applying_a_Morphological_Operator.html#wp1012086" >iImage images:morphing</keyword>
          <keyword ref="Applying_a_Morphological_Operator.html#wp1012086" >morphing:images</keyword>
        </section>
        <section title="Contouring an Image" ref="Contouring_an_Image.html" >
          <keyword ref="Contouring_an_Image.html#wp1012093" >iImage images:contouring</keyword>
        </section>
        <section title="Surfacing an Image" ref="Surfacing_an_Image.html" >
          <keyword ref="Surfacing_an_Image.html#wp1012124" >iImage images:adding:surface</keyword>
          <keyword ref="Surfacing_an_Image.html#wp1012124" >surfaces:adding to an image</keyword>
        </section>
        <section title="Manipulating the Image Display" ref="Manipulating_the_Image_Display.html" >
          <keyword ref="Manipulating_the_Image_Display.html#wp1012145" >iImage images:manipulating</keyword>
          <keyword ref="Manipulating_the_Image_Display.html#wp1012145" >manipulating images:in iTools</keyword>
          <section title="Rotating an Image" ref="Manipulating_the_Image_Display.html#wp1012150" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012152" >rotating:image</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012152" >iImage images:rotating</keyword>
          </section>
          <section title="Scaling an Image and Byte Scaling an Image" ref="Manipulating_the_Image_Display.html#wp1012156" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012158" >iImage images:scaling</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012158" >scaling:images</keyword>
          </section>
          <section title="Inverting an Image" ref="Manipulating_the_Image_Display.html#wp1012163" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012165" >iImage images:inverting</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012165" >inverting images</keyword>
          </section>
          <section title="Flipping an Image" ref="Manipulating_the_Image_Display.html#wp1012166" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012168" >flipping:images</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012168" >iImage images:flipping</keyword>
          </section>
          <section title="View Zoom" ref="Manipulating_the_Image_Display.html#wp1012181" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012182" >iImage images:zooming</keyword>
          </section>
          <section title="Canvas Zoom" ref="Manipulating_the_Image_Display.html#wp1012189" />
          <section title="Pixel Scaling" ref="Manipulating_the_Image_Display.html#wp1012194" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012195" >iImage images:pixel scaling</keyword>
          </section>
          <section title="Region Growing" ref="Manipulating_the_Image_Display.html#wp1012198" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012199" >iImage images:region growing</keyword>
          </section>
          <section title="Adding Annotations" ref="Manipulating_the_Image_Display.html#wp1012202" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012204" >annotating:iTools:images</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012204" >iImage images:annotating</keyword>
          </section>
          <section title="Line Profiles" ref="Manipulating_the_Image_Display.html#wp1012246" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012248" >lines:profiles:in images</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012248" >iImage images:line profiling</keyword>
          </section>
          <section title="View Panning" ref="Manipulating_the_Image_Display.html#wp1012254" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012259" >panning images:IIMAGE</keyword>
            <keyword ref="Manipulating_the_Image_Display.html#wp1012259" >iImage images:panning</keyword>
          </section>
          <section title="Cropping an Image" ref="Manipulating_the_Image_Display.html#wp1012271" >
            <keyword ref="Manipulating_the_Image_Display.html#wp1012272" >iImage images:cropping</keyword>
          </section>
        </section>
        <section title="iImage Tool Operations " ref="IIMAGE_OPS.html" >
          <section title="Viewing a Histogram" ref="IIMAGE_OPS.html#wp1012303" />
          <section title="Viewing Image Statistics" ref="IIMAGE_OPS.html#wp1012308" />
          <section title="Cropping Images" ref="IIMAGE_OPS.html#wp1012314" />
        </section>
      </section>
      <section title="Working with Surfaces" ref="Working_with_Surfaces.html" >
        <section title="Introduction" ref="Introductionham.html" />
        <section title="Displaying Surfaces" ref="Displaying_Surfaces.html" >
          <keyword ref="Displaying_Surfaces.html#wp1006587" >surfaces:displaying</keyword>
          <keyword ref="Displaying_Surfaces.html#wp1006587" >displaying:surfaces</keyword>
        </section>
        <section title="Surface Properties" ref="Surface_Properties.html" >
          <section title="The Visualization Browser" ref="Surface_Properties.html#wp1007419" />
          <section title="The Operations Browser" ref="Surface_Properties.html#wp1007433" />
        </section>
        <section title="Adding a Colorbar" ref="Adding_a_Colorbarhvp.html" >
          <keyword ref="Adding_a_Colorbarhap.html#wp1007497" >colorbars:adding to:surfaces</keyword>
          <keyword ref="Adding_a_Colorbarhap.html#wp1007497" >surfaces:colorbar</keyword>
        </section>
        <section title="Adding a Light" ref="Adding_a_Light.html" >
          <keyword ref="Adding_a_Light.html#wp1007553" >lights:adding to a surface</keyword>
          <keyword ref="Adding_a_Light.html#wp1007553" >surfaces:lights</keyword>
        </section>
        <section title="Adding a Legend" ref="Adding_a_Legend.html" >
          <keyword ref="Adding_a_Legend.html#wp1007294" >legends:adding:to surfaces</keyword>
          <keyword ref="Adding_a_Legend.html#wp1007294" >surfaces:legends</keyword>
        </section>
        <section title="Adding Axes" ref="Adding_Axeshvs.html" >
          <keyword ref="Adding_Axeshas.html#wp1007310" >axes:adding to:surfaces</keyword>
          <keyword ref="Adding_Axeshas.html#wp1007310" >surfaces:adding axes</keyword>
        </section>
        <section title="Imaging a Surface" ref="Imaging_a_Surface.html" >
          <keyword ref="Imaging_a_Surface.html#wp1007677" >iImage images:of surface data</keyword>
          <keyword ref="Imaging_a_Surface.html#wp1007677" >surfaces:creating images of</keyword>
        </section>
        <section title="Contouring a Surface" ref="Contouring_a_Surface.html" >
          <keyword ref="Contouring_a_Surface.html#wp1006663" >contours:on surface data</keyword>
          <keyword ref="Contouring_a_Surface.html#wp1006663" >surfaces:creating contours on</keyword>
        </section>
        <section title="Resampling a Surface" ref="Resampling_a_Surface.html" >
          <keyword ref="Resampling_a_Surface.html#wp1006671" >resampling:surfaces</keyword>
        </section>
        <section title="Filtering a Surface" ref="Filtering_a_Surface.html" >
          <keyword ref="Filtering_a_Surface.html#wp1006576" >filtering:surfaces</keyword>
          <keyword ref="Filtering_a_Surface.html#wp1006576" >surfaces:filtering</keyword>
          <section title="Convolving a Surface" ref="Filtering_a_Surface.html#wp1005842" />
          <section title="Median a Surface" ref="Filtering_a_Surface.html#wp1007748" />
          <section title="Smoothing a Surface" ref="Filtering_a_Surface.html#wp1008044" />
        </section>
        <section title="Adding a Texture Map" ref="Adding_a_Texture_Map.html" >
          <keyword ref="Adding_a_Texture_Map.html#wp1006821" >texture maps:iTools</keyword>
          <keyword ref="Adding_a_Texture_Map.html#wp1006821" >surfaces:adding  texture map  </keyword>
        </section>
        <section title="Manipulating Surface Displays" ref="Manipulating_Surface_Displays.html" >
          <section title="Rotating a Surface" ref="Manipulating_Surface_Displays.html#wp1005824" >
            <keyword ref="Manipulating_Surface_Displays.html#wp1005917" >rotating:surfaces</keyword>
            <keyword ref="Manipulating_Surface_Displays.html#wp1005917" >surfaces:rotating</keyword>
          </section>
          <section title="Scaling a Surface" ref="Manipulating_Surface_Displays.html#wp1006158" >
            <keyword ref="Manipulating_Surface_Displays.html#wp1006159" >surfaces:scaling</keyword>
            <keyword ref="Manipulating_Surface_Displays.html#wp1006159" >scaling:surfaces</keyword>
          </section>
          <section title="Adding Annotations" ref="Manipulating_Surface_Displays.html#wp1006970" />
          <section title="View Zoom" ref="Manipulating_Surface_Displays.html#wp1007523" />
          <section title="Canvas Zoom" ref="Manipulating_Surface_Displays.html#wp1007531" />
          <section title="Extracting a Line Profile" ref="Manipulating_Surface_Displays.html#wp1007817" >
            <keyword ref="Manipulating_Surface_Displays.html#wp1007818" >lines:profiles:extracting for a surface</keyword>
            <keyword ref="Manipulating_Surface_Displays.html#wp1007818" >surfaces:extracting a line profile</keyword>
          </section>
        </section>
        <section title="iSurface Tool Operations" ref="iSurface_Tool_Operations.html" >
          <keyword ref="iSurface_Tool_Operations.html#wp1007790" >surfaces:histogram for</keyword>
          <keyword ref="iSurface_Tool_Operations.html#wp1007790" >histogram:surface</keyword>
          <section title="Viewing a Histogram Plot" ref="iSurface_Tool_Operations.html#wp1007790" />
          <section title="Viewing Statistics" ref="iSurface_Tool_Operations.html#wp1005546" >
            <keyword ref="iSurface_Tool_Operations.html#wp1005805" >statistics:surface</keyword>
            <keyword ref="iSurface_Tool_Operations.html#wp1005805" >surfaces:statistics</keyword>
          </section>
        </section>
      </section>
      <section title="Working with Contours" ref="Working_with_Contours.html" >
        <section title="Introduction" ref="Introductionhzc.html" />
        <section title="Displaying Contours" ref="Displaying_Contours.html" >
          <keyword ref="Displaying_Contours.html#wp1006556" >contours:displaying:in iContour</keyword>
          <keyword ref="Displaying_Contours.html#wp1006556" >displaying:contours:in iContour</keyword>
          <section title="Displaying Regular-grid Data" ref="Displaying_Contours.html#wp1006557" >
            <keyword ref="Displaying_Contours.html#wp1006558" >regular-grid data displays</keyword>
            <keyword ref="Displaying_Contours.html#wp1006558" >displaying:regular-grid data</keyword>
          </section>
          <section title="Displaying Irregular-grid Data" ref="Displaying_Contours.html#wp1006563" >
            <keyword ref="Displaying_Contours.html#wp1006564" >irregularly-gridded data</keyword>
            <keyword ref="Displaying_Contours.html#wp1006564" >displaying:irregular-grid data</keyword>
            <keyword ref="Displaying_Contours.html#wp1004951" >gridding wizard</keyword>
          </section>
        </section>
        <section title="Contour Properties" ref="Contour_Properties.html" >
          <keyword ref="Contour_Properties.html#wp1005037" >contours:properties</keyword>
          <keyword ref="Contour_Properties.html#wp1005037" >properties:contours</keyword>
        </section>
        <section title="Labelling Contours" ref="Labeling_Contours.html" >
          <keyword ref="Labelling_Contours.html#wp1005021" >contours:labelling</keyword>
          <keyword ref="Labelling_Contours.html#wp1005021" >labelling:contours</keyword>
        </section>
        <section title="Changing the Contour Colors" ref="Changing_the_Contour_Colors.html" >
          <keyword ref="Changing_the_Contour_Colors.html#wp1006577" >colors:changing in contours</keyword>
          <keyword ref="Changing_the_Contour_Colors.html#wp1006577" >contours:colors in</keyword>
        </section>
        <section title="Filling Contours" ref="Filling_Contours.html" >
          <keyword ref="Filling_Contours.html#wp1005020" >contours:filling</keyword>
          <keyword ref="Filling_Contours.html#wp1005020" >filling:contours:iTools</keyword>
        </section>
        <section title="Adding a Colorbar" ref="Adding_a_Colorbarhzg.html" >
          <keyword ref="Adding_a_Colorbarhcg.html#wp1006047" >colorbars:adding to:contours</keyword>
          <keyword ref="Adding_a_Colorbarhcg.html#wp1006047" >contours:colorbar</keyword>
        </section>
        <section title="Adding a Legend" ref="Adding_a_Legendhzh.html" >
          <keyword ref="Adding_a_Legendhch.html#wp1006596" >legends:adding:to contours</keyword>
          <keyword ref="Adding_a_Legendhch.html#wp1006596" >contours:colorbar</keyword>
        </section>
        <section title="Adding Axes" ref="Adding_Axeshzi.html" >
          <keyword ref="Adding_Axeshci.html#wp1004846" >axes:adding to:contours</keyword>
          <keyword ref="Adding_Axeshci.html#wp1004846" >contours:adding an axis</keyword>
        </section>
        <section title="Filtering a Contour" ref="Filtering_a_Contour.html" >
          <keyword ref="Filtering_a_Contour.html#wp1005933" >contours:filtering</keyword>
          <keyword ref="Filtering_a_Contour.html#wp1005933" >filtering:contours</keyword>
          <section title="Contour Smoothing" ref="Filtering_a_Contour.html#wp1005934" />
          <section title="Contour Convolution" ref="Filtering_a_Contour.html#wp1005948" />
        </section>
        <section title="Manipulating the Contour Display" ref="Manipulating_the_Contour_Display.html" >
          <section title="Translating" ref="Manipulating_the_Contour_Display.html#wp1005247" />
          <section title="View Zoom" ref="Manipulating_the_Contour_Display.html#wp1005974" />
          <section title="Flipping a Contour" ref="Manipulating_the_Contour_Display.html#wp1007365" >
            <keyword ref="Manipulating_the_Contour_Display.html#wp1007367" >flipping:contours</keyword>
            <keyword ref="Manipulating_the_Contour_Display.html#wp1007367" >contours:flipping</keyword>
          </section>
          <section title="Canvas Zoom" ref="Manipulating_the_Contour_Display.html#wp1007363" />
          <section title="Scaling a Contour Display" ref="Manipulating_the_Contour_Display.html#wp1005995" />
          <section title="Adding Annotations" ref="Manipulating_the_Contour_Display.html#wp1005827" >
            <keyword ref="Manipulating_the_Contour_Display.html#wp1005861" >annotating:iTools:contours</keyword>
            <keyword ref="Manipulating_the_Contour_Display.html#wp1005861" >contours:annotations (iTools)</keyword>
          </section>
        </section>
        <section title="iContour Tool Operations" ref="iContour_Tool_Operations.html" >
          <section title="Viewing a Histogram" ref="iContour_Tool_Operations.html#wp1005370" >
            <keyword ref="iContour_Tool_Operations.html#wp1005371" >contours:histogram</keyword>
            <keyword ref="iContour_Tool_Operations.html#wp1005371" >histogram:for contours</keyword>
          </section>
          <section title="Viewing Statistics" ref="iContour_Tool_Operations.html#wp1005375" >
            <keyword ref="iContour_Tool_Operations.html#wp1005376" >contours:adding statistics</keyword>
          </section>
        </section>
      </section>
      <section title="Working with Plots" ref="Working_with_Plots.html" >
        <section title="Introduction" ref="Introductionhyg.html" />
        <section title="Displaying Two-Dimensional Plots" ref="Displaying_Two-Dimensional_Plots.html" >
          <keyword ref="Displaying_Two-Dimensional_Plots.html#wp1005162" >plotting:IPLOT:displaying 2-D</keyword>
          <keyword ref="Displaying_Two-Dimensional_Plots.html#wp1005162" >displaying:2D plots</keyword>
        </section>
        <section title="Displaying Three-Dimensional Plots" ref="Displaying_Three-Dimensional_Plots.html" >
          <keyword ref="Displaying_Three-Dimensional_Plots.html#wp1005885" >plotting:IPLOT:displaying 3-D</keyword>
          <keyword ref="Displaying_Three-Dimensional_Plots.html#wp1005885" >displaying:3D plots</keyword>
        </section>
        <section title="Displaying Polar Plots" ref="Displaying_Polar_Plots.html" >
          <keyword ref="Displaying_Polar_Plots.html#wp1005460" >plotting:IPLOT:displaying polar</keyword>
          <keyword ref="Displaying_Polar_Plots.html#wp1005460" >polar plots:IPLOT</keyword>
        </section>
        <section title="Overplotting" ref="Overplotting.html" >
          <keyword ref="Overplotting.html#wp1005614" >overplotting:IPLOT</keyword>
          <keyword ref="Overplotting.html#wp1005614" >plotting:overplotting:IPLOT</keyword>
        </section>
        <section title="Plot Properties" ref="Plot_Properties.html" >
          <section title="Modifying Properties" ref="Plot_Properties.html#wp1007134" >
            <keyword ref="Plot_Properties.html#wp1007135" >plotting:IPLOT:modifying properties for</keyword>
          </section>
        </section>
        <section title="Adding Legends" ref="Adding_Legends.html" >
          <keyword ref="Adding_Legends.html#wp1007044" >plotting:IPLOT:legend</keyword>
          <keyword ref="Adding_Legends.html#wp1007044" >legends:adding:to plots</keyword>
        </section>
        <section title="Adding a Colorbar" ref="Adding_a_Colorbarhyk.html" >
          <keyword ref="Adding_a_Colorbarhdk.html#wp1007401" >plotting:IPLOT:colorbar</keyword>
          <keyword ref="Adding_a_Colorbarhdk.html#wp1007401" >colorbars:adding to:plots</keyword>
        </section>
        <section title="Adding Error Bars" ref="Adding_Error_Bars.html" >
          <keyword ref="Adding_Error_Bars.html#wp1006515" >error bar plots</keyword>
          <keyword ref="Adding_Error_Bars.html#wp1006515" >plotting:IPLOT:error bars</keyword>
        </section>
        <section title="Curve Fitting" ref="Curve_Fitting.html" >
          <keyword ref="Curve_Fitting.html#wp1005637" >curve fitting:for plots</keyword>
          <keyword ref="Curve_Fitting.html#wp1005637" >plotting:IPLOT:curve fitting</keyword>
        </section>
        <section title="Filtering a Plot" ref="Filtering_a_Plot.html" >
          <keyword ref="Filtering_a_Plot.html#wp1007161" >plotting:IPLOT:filtering</keyword>
          <keyword ref="Filtering_a_Plot.html#wp1007161" >filtering:plots</keyword>
          <section title="Plot Smoothing" ref="Filtering_a_Plot.html#wp1007162" />
          <section title="Plot Convolution" ref="Filtering_a_Plot.html#wp1007176" />
          <section title="Plot Median" ref="Filtering_a_Plot.html#wp1007301" />
        </section>
        <section title="Manipulating the Plot Display" ref="Manipulating_the_Plot_Display.html" >
          <section title="Translating" ref="Manipulating_the_Plot_Display.html#wp1005719" >
            <keyword ref="Manipulating_the_Plot_Display.html#wp1005720" >translating:plots</keyword>
            <keyword ref="Manipulating_the_Plot_Display.html#wp1005720" >plotting:IPLOT:translating</keyword>
          </section>
          <section title="Adding Annotations" ref="Manipulating_the_Plot_Display.html#wp1005721" >
            <keyword ref="Manipulating_the_Plot_Display.html#wp1006448" >plotting:IPLOT:annotating</keyword>
            <keyword ref="Manipulating_the_Plot_Display.html#wp1006448" >annotating:iTools:plots</keyword>
          </section>
          <section title="View Zoom" ref="Manipulating_the_Plot_Display.html#wp1007202" />
          <section title="Canvas Zoom" ref="Manipulating_the_Plot_Display.html#wp1007210" />
          <section title="Selecting the Data Range" ref="Manipulating_the_Plot_Display.html#wp1007277" />
        </section>
        <section title="iPlot Tool Operations" ref="iPlot_Tool_Operations.html" >
          <section title="Scaling a Plot Display" ref="iPlot_Tool_Operations.html#wp1006839" >
            <keyword ref="iPlot_Tool_Operations.html#wp1006840" >plotting:IPLOT:scaling</keyword>
            <keyword ref="iPlot_Tool_Operations.html#wp1006840" >scaling:plots</keyword>
          </section>
          <section title="Viewing a Histogram" ref="iPlot_Tool_Operations.html#wp1006837" >
            <keyword ref="iPlot_Tool_Operations.html#wp1005695" >plotting:IPLOT:adding a histogram to</keyword>
            <keyword ref="iPlot_Tool_Operations.html#wp1005695" >histogram:plot</keyword>
          </section>
          <section title="Viewing Statistics" ref="iPlot_Tool_Operations.html#wp1005699" >
            <keyword ref="iPlot_Tool_Operations.html#wp1005700" >statistics:adding to plots</keyword>
            <keyword ref="iPlot_Tool_Operations.html#wp1005700" >plotting:IPLOT:statistics</keyword>
          </section>
        </section>
      </section>
      <section title="Working with Volumes" ref="Working_with_Volumes.html" >
        <section title="Introduction" ref="Introductionhzi.html" />
        <section title="Displaying Volumes" ref="Displaying_Volumes.html" >
          <keyword ref="Displaying_Volumes.html#wp1004576" >volumes:displaying</keyword>
          <keyword ref="Displaying_Volumes.html#wp1004576" >displaying:volumes</keyword>
          <section title="Multi-Channel Volumes" ref="Displaying_Volumes.html#wp1006247" >
            <keyword ref="Displaying_Volumes.html#wp1006249" >multi-channel volumes</keyword>
            <keyword ref="Displaying_Volumes.html#wp1006249" >displaying:multi-channel volumes</keyword>
            <keyword ref="Displaying_Volumes.html#wp1006249" >volumes:displaying multi-channel</keyword>
          </section>
          <section title="Rendering Volumes" ref="Displaying_Volumes.html#wp1006242" >
            <keyword ref="Displaying_Volumes.html#wp1005698" >volumes:rendering</keyword>
            <keyword ref="Displaying_Volumes.html#wp1005698" >rendering:volumes</keyword>
            <keyword ref="Displaying_Volumes.html#wp1006168" >volumes:extents</keyword>
          </section>
        </section>
        <section title="Using the Volume Panel" ref="Using_the_Volume_Panel.html" >
          <keyword ref="Using_the_Volume_Panel.html#wp1006729" >volume panel (IVOLUME)</keyword>
          <keyword ref="Using_the_Volume_Panel.html#wp1006729" >panel:IVOLUME</keyword>
        </section>
        <section title="Volume Properties" ref="Volume_Properties.html" >
          <section title="Modifying Properties" ref="Volume_Properties.html#wp1005097" >
            <keyword ref="Volume_Properties.html#wp1005098" >volumes:properties</keyword>
            <keyword ref="Volume_Properties.html#wp1005098" >properties:modifying volume</keyword>
          </section>
        </section>
        <section title="Adding a Colorbar" ref="Adding_a_Colorbarhzl.html" >
          <keyword ref="Adding_a_Colorbarhel.html#wp1005366" >volumes:adding a colorbar to</keyword>
          <keyword ref="Adding_a_Colorbarhel.html#wp1005366" >colorbars:adding to:volumes</keyword>
        </section>
        <section title="Adding Axes" ref="Adding_Axeshzm.html" >
          <keyword ref="Adding_Axeshem.html#wp1005428" >volumes:adding an axis to</keyword>
          <keyword ref="Adding_Axeshem.html#wp1005428" >axes:adding to:volumes</keyword>
        </section>
        <section title="Resampling Volumes" ref="Resampling_Volumes.html" >
          <keyword ref="Resampling_Volumes.html#wp1005457" >volumes:resampling</keyword>
          <keyword ref="Resampling_Volumes.html#wp1005457" >resampling:volumes</keyword>
        </section>
        <section title="Showing an Image Plane" ref="Showing_an_Image_Plane.html" >
          <keyword ref="Showing_an_Image_Plane.html#wp1005607" >volumes:showing an image plane for</keyword>
          <keyword ref="Showing_an_Image_Plane.html#wp1005607" >image plane:for volumes</keyword>
          <keyword ref="Showing_an_Image_Plane.html#wp1005607" >image plane:about</keyword>
          <section title="Viewing the Image Plane in iImage" ref="Showing_an_Image_Plane.html#wp1005936" />
        </section>
        <section title="Extracting an IsoSurface" ref="Extracting_an_IsoSurface.html" >
          <keyword ref="Extracting_an_IsoSurface.html#wp1005642" >volumes:extracting an isosurface for</keyword>
          <keyword ref="Extracting_an_IsoSurface.html#wp1005642" >isosurfaces:extracting in volumes</keyword>
        </section>
        <section title="Extracting an Interval Volume" ref="Extracting_an_Interval_Volume.html" >
          <keyword ref="Extracting_an_Interval_Volume.html#wp1005651" >volumes:extracting an interval volume in</keyword>
          <keyword ref="Extracting_an_Interval_Volume.html#wp1005651" >interval volume:extracting in volumes</keyword>
        </section>
        <section title="Manipulating the Volume Display" ref="Manipulating_the_Volume_Display.html" >
          <keyword ref="Manipulating_the_Volume_Display.html#wp1004737" >manipulating volume data:in iTools</keyword>
          <section title="Rotating a Volume" ref="Manipulating_the_Volume_Display.html#wp1003985" >
            <keyword ref="Manipulating_the_Volume_Display.html#wp1003986" >rotating:volumes</keyword>
            <keyword ref="Manipulating_the_Volume_Display.html#wp1003986" >volumes:rotating</keyword>
          </section>
          <section title="Scaling a Volume" ref="Manipulating_the_Volume_Display.html#wp1005267" >
            <keyword ref="Manipulating_the_Volume_Display.html#wp1005268" >scaling:volumes</keyword>
            <keyword ref="Manipulating_the_Volume_Display.html#wp1005268" >volumes:scaling</keyword>
          </section>
          <section title="View Zoom" ref="Manipulating_the_Volume_Display.html#wp1005516" />
          <section title="Canvas Zoom" ref="Manipulating_the_Volume_Display.html#wp1005524" />
          <section title="Adding Annotations" ref="Manipulating_the_Volume_Display.html#wp1004881" >
            <keyword ref="Manipulating_the_Volume_Display.html#wp1004882" >annotating:iTools:volumes</keyword>
            <keyword ref="Manipulating_the_Volume_Display.html#wp1004882" >volumes:annotating</keyword>
          </section>
        </section>
        <section title="iVolume Tool Operations" ref="iVolume_Tool_Operations.html" >
          <section title="Viewing a Histogram" ref="iVolume_Tool_Operations.html#wp1004496" >
            <keyword ref="iVolume_Tool_Operations.html#wp1004797" >volumes:adding a histogram to</keyword>
            <keyword ref="iVolume_Tool_Operations.html#wp1004797" >histogram:adding to a volume</keyword>
          </section>
          <section title="Viewing Statistics" ref="iVolume_Tool_Operations.html#wp1004498" >
            <keyword ref="iVolume_Tool_Operations.html#wp1004779" >volumes:adding statistics to</keyword>
            <keyword ref="iVolume_Tool_Operations.html#wp1004779" >statistics:adding to volumes</keyword>
          </section>
          <section title="Smoothing a Volume" ref="iVolume_Tool_Operations.html#wp1005991" >
            <keyword ref="iVolume_Tool_Operations.html#wp1006096" >smoothing:volumes</keyword>
            <keyword ref="iVolume_Tool_Operations.html#wp1006096" >volumes:smoothing</keyword>
          </section>
          <section title="Opening an Image Stack" ref="iVolume_Tool_Operations.html#wp1008425" >
            <keyword ref="iVolume_Tool_Operations.html#wp1008440" >iVolume tool:image stack</keyword>
            <keyword ref="iVolume_Tool_Operations.html#wp1008440" >image stack, iVolume</keyword>
          </section>
        </section>
      </section>
      <section title="Working with Maps" ref="Working_with_Maps.html" >
        <section title="Introduction" ref="Introductioniak.html" />
        <section title="Displaying Maps" ref="Displaying_Maps.html" >
          <keyword ref="Displaying_Maps.html#wp1005127" >maps, displaying in IMAP</keyword>
          <keyword ref="Displaying_Maps.html#wp1005127" >displaying:maps</keyword>
        </section>
        <section title="Applying a Map Projection " ref="IT_MAP_PROJ.html" >
          <keyword ref="IT_MAP_PROJ.html#wp1009422" >map projections:definition</keyword>
          <keyword ref="IT_MAP_PROJ.html#wp1010090" >map projection:applying</keyword>
          <keyword ref="IT_MAP_PROJ.html#wp1010165" >map projections:common properties (iTools)</keyword>
        </section>
        <section title="Using the Map Panel" ref="Using_the_Map_Panel.html" >
          <keyword ref="Using_the_Map_Panel.html#wp1013300" >map panel (IMAP)</keyword>
          <keyword ref="Using_the_Map_Panel.html#wp1013300" >panel:IMAP</keyword>
        </section>
        <section title="Displaying an Image" ref="Displaying_an_Image.html" >
          <keyword ref="Displaying_an_Image.html#wp1008977" >displaying:images:in iMap</keyword>
          <keyword ref="Displaying_an_Image.html#wp1008977" >image display:in iMap</keyword>
        </section>
        <section title="Registering an Image " ref="IT_MAP_REG_IMAGE.html" >
          <keyword ref="IT_MAP_REG_IMAGE.html#wp1009225" >iImage images:registering in iMap</keyword>
          <keyword ref="IT_MAP_REG_IMAGE.html#wp1009225" >registering:images:wizard</keyword>
          <section title="Registering an Image in Meters" ref="IT_MAP_REG_IMAGE.html#wp1014432" >
            <keyword ref="IT_MAP_REG_IMAGE.html#wp1017117" >registering:images:in meters</keyword>
          </section>
          <section title="Registering an Image in Degrees" ref="IT_MAP_REG_IMAGE.html#wp1014186" >
            <keyword ref="IT_MAP_REG_IMAGE.html#wp1014470" >registering:images:in degrees</keyword>
          </section>
        </section>
        <section title="Displaying a Contour" ref="Displaying_a_Contour.html" >
          <keyword ref="Displaying_a_Contour.html#wp1008981" >displaying:contours:in iMap</keyword>
          <keyword ref="Displaying_a_Contour.html#wp1008981" >contours:displaying:in iMap</keyword>
        </section>
        <section title="Creating a Shape Visualization" ref="Creating_a_Shape_Visualization.html" >
          <keyword ref="Creating_a_Shape_Visualization.html#wp1010852" >Shapefile:definition</keyword>
          <keyword ref="Creating_a_Shape_Visualization.html#wp1010893" >Shapefile:creating a visualization</keyword>
          <keyword ref="Creating_a_Shape_Visualization.html#wp1010893" >shape visualization:creating</keyword>
        </section>
        <section title="Inserting a Map Grid" ref="Inserting_a_Map_Grid.html" >
          <keyword ref="Inserting_a_Map_Grid.html#wp1012691" >inserting:map grid</keyword>
          <keyword ref="Inserting_a_Map_Grid.html#wp1012691" >map grid, inserting</keyword>
        </section>
        <section title="Inserting an IDL Shapefile" ref="Inserting_an_IDL_Shapefile.html" >
          <keyword ref="Inserting_an_IDL_Shapefile.html#wp1010913" >Shapefile:inserting</keyword>
          <keyword ref="Inserting_an_IDL_Shapefile.html#wp1010913" >inserting:shapefiles</keyword>
          <section title="Inserting the Continents" ref="Inserting_an_IDL_Shapefile.html#wp1011819" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1012085" >Shapefile:inserting:continents</keyword>
          </section>
          <section title="Inserting the Countries (Low Resolution)" ref="Inserting_an_IDL_Shapefile.html#wp1011878" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1012107" >Shapefile:inserting:countries (low resolution)</keyword>
          </section>
          <section title="Inserting the Countries (High Resolution)" ref="Inserting_an_IDL_Shapefile.html#wp1014517" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1014547" >Shapefile:inserting:countries (high resolution)</keyword>
          </section>
          <section title="Inserting the Rivers" ref="Inserting_an_IDL_Shapefile.html#wp1011954" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1012177" >Shapefile:inserting:rivers</keyword>
          </section>
          <section title="Inserting the Lakes" ref="Inserting_an_IDL_Shapefile.html#wp1011964" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1012219" >Shapefile:inserting:lakes</keyword>
          </section>
          <section title="Inserting the United States" ref="Inserting_an_IDL_Shapefile.html#wp1011965" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1012246" >Shapefile:inserting:United States</keyword>
          </section>
          <section title="Inserting the Canadian Provinces" ref="Inserting_an_IDL_Shapefile.html#wp1016816" >
            <keyword ref="Inserting_an_IDL_Shapefile.html#wp1016818" >Shapefile:inserting:Canadian provinces</keyword>
          </section>
        </section>
      </section>
      <section title="iTools Interface Reference" ref="iTools_Interface_Reference.html" >
        <section title="Introduction to iTools Interface Elements" ref="Introduction_to_iTools_Interface_Elements.html" >
          <section title="Menu Bar Items" ref="Introduction_to_iTools_Interface_Elements.html#wp1007706" />
          <section title="Toolbar Items" ref="Introduction_to_iTools_Interface_Elements.html#wp1007720" />
        </section>
        <section title="File Menu " ref="File_Menu.html" >
          <keyword ref="File_Menu.html#wp1005757" >file menu</keyword>
          <keyword ref="File_Menu.html#wp1005757" >iTools:file menu</keyword>
        </section>
        <section title="Edit Menu" ref="Edit_Menuicd.html" >
          <keyword ref="Edit_Menuhgh.html#wp1006356" >iTools:edit menu</keyword>
        </section>
        <section title="Insert Menu" ref="Insert_Menu.html" >
          <keyword ref="Insert_Menu.html#wp1006357" >insert menu</keyword>
          <keyword ref="Insert_Menu.html#wp1006357" >iTools:insert menu</keyword>
        </section>
        <section title="Operations Menu" ref="Operations_Menu.html" >
          <keyword ref="Operations_Menu.html#wp1006358" >operations:menu</keyword>
          <keyword ref="Operations_Menu.html#wp1006358" >iTools:operations menu</keyword>
        </section>
        <section title="Window Menu" ref="Window_Menuicf.html" >
          <keyword ref="Window_Menuhgj.html#wp1006365" >window menu</keyword>
          <keyword ref="Window_Menuhgj.html#wp1006365" >iTools:window menu</keyword>
        </section>
        <section title="Help Menu" ref="Help_Menuicg.html" >
          <keyword ref="Help_Menuhgk.html#wp1006366" >help menu</keyword>
          <keyword ref="Help_Menuhgk.html#wp1006366" >iTools:help menu</keyword>
        </section>
        <section title="File Toolbar" ref="File_Toolbar.html" >
          <keyword ref="File_Toolbar.html#wp1008434" >files:toolbar</keyword>
          <keyword ref="File_Toolbar.html#wp1008434" >iTools:file toolbar</keyword>
        </section>
        <section title="Edit Toolbar" ref="Edit_Toolbar.html" >
          <keyword ref="Edit_Toolbar.html#wp1008616" >iTools:edit toolbar</keyword>
        </section>
        <section title="Manipulator Toolbar" ref="Manipulator_Toolbar.html" >
          <keyword ref="Manipulator_Toolbar.html#wp1013618" >manipulator toolbar</keyword>
          <keyword ref="Manipulator_Toolbar.html#wp1013618" >iTools:manipulator toolbar</keyword>
        </section>
        <section title="Annotation Toolbar" ref="Annotation_Toolbar.html" >
          <keyword ref="Annotation_Toolbar.html#wp1008649" >annotating:iTools:toolbar for</keyword>
          <keyword ref="Annotation_Toolbar.html#wp1008649" >iTools:annotation toolbar</keyword>
        </section>
        <section title="Context Menu" ref="Context_Menu.html" />
      </section>
      <section title="Property Controls" ref="Property_Controls.html" />
      <section title="Operations Properties" ref="Operations_Properties.html" >
        <section title="The Operations Browser " ref="ITOOL_OPS_BROWSER.html" >
          <keyword ref="ITOOL_OPS_BROWSER.html#wp1008602" >operations:browser</keyword>
          <keyword ref="ITOOL_OPS_BROWSER.html#wp1008602" >properties:operations browser</keyword>
        </section>
        <section title="Macros Properties " ref="IT_OPS_MACROS.html" >
          <keyword ref="IT_OPS_MACROS.html#wp1012571" >macros:iTool:properties</keyword>
          <keyword ref="IT_OPS_MACROS.html#wp1012571" >properties:iTool macros</keyword>
        </section>
        <section title="Statistics Properties " ref="IT_OPS_STATS.html" >
          <keyword ref="IT_OPS_STATS.html#wp1006713" >statistics:properties</keyword>
          <keyword ref="IT_OPS_STATS.html#wp1006713" >properties:statistics</keyword>
        </section>
        <section title="Histogram Properties " ref="IT_OPS_HISTOGRAM.html" >
          <keyword ref="IT_OPS_HISTOGRAM.html#wp1008685" >histogram:properties</keyword>
          <keyword ref="IT_OPS_HISTOGRAM.html#wp1008685" >properties:histogram</keyword>
        </section>
        <section title="Filter Properties " ref="IT_OPS_FILTERS.html" >
          <section title="Convolution Properties" ref="IT_OPS_FILTERS.html#wp1006814" >
            <keyword ref="IT_OPS_FILTERS.html#wp1006888" >convolution:properties</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1006888" >properties:convolution</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1011962" >smooth filtering</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1011962" >properties:smooth filter</keyword>
          </section>
          <section title="Median Properties" ref="IT_OPS_FILTERS.html#wp1011962" >
            <keyword ref="IT_OPS_FILTERS.html#wp1012000" >smooth filtering</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1012000" >properties:smooth filter</keyword>
          </section>
          <section title="Smooth Properties" ref="IT_OPS_FILTERS.html#wp1012000" />
          <section title="Roberts Filter Properties" ref="IT_OPS_FILTERS.html#wp1007624" >
            <keyword ref="IT_OPS_FILTERS.html#wp1007631" >Roberts filter</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1007631" >properties:Roberts filter</keyword>
          </section>
          <section title="Sobel Filter Properties" ref="IT_OPS_FILTERS.html#wp1007625" >
            <keyword ref="IT_OPS_FILTERS.html#wp1007662" >Sobel:filter</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1007662" >properties:Sobel filter</keyword>
          </section>
          <section title="Unsharp Mask Properties" ref="IT_OPS_FILTERS.html#wp1006819" >
            <keyword ref="IT_OPS_FILTERS.html#wp1012264" >unsharp mask filter</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1012264" >properties:unsharp mask filter</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1013672" >curve fitting filtering</keyword>
            <keyword ref="IT_OPS_FILTERS.html#wp1013672" >properties:curve fitting</keyword>
          </section>
          <section title="Curve Fitting Properties" ref="IT_OPS_FILTERS.html#wp1013672" />
        </section>
        <section title="Rotate Properties " ref="IT_OPS_ROTATE.html" >
          <keyword ref="IT_OPS_ROTATE.html#wp1007189" >rotating:properties</keyword>
          <keyword ref="IT_OPS_ROTATE.html#wp1007189" >properties:rotate</keyword>
          <section title="Rotate Left Properties" ref="IT_OPS_ROTATE.html#wp1006991" />
          <section title="Rotate Right Properties" ref="IT_OPS_ROTATE.html#wp1008518" />
          <section title="Rotate By Angle Properties" ref="IT_OPS_ROTATE.html#wp1008539" />
          <section title="Flip Horizontal" ref="IT_OPS_ROTATE.html#wp1011666" />
          <section title="Flip Vertical" ref="IT_OPS_ROTATE.html#wp1011675" />
        </section>
        <section title="Transform Properties " ref="IT_OPS_TRANSFORM.html" >
          <keyword ref="IT_OPS_TRANSFORM.html#wp1007164" >transforming :properties</keyword>
          <keyword ref="IT_OPS_TRANSFORM.html#wp1007164" >properties:transform</keyword>
          <section title="Resample Properties" ref="IT_OPS_TRANSFORM.html#wp1007096" >
            <keyword ref="IT_OPS_TRANSFORM.html#wp1007119" >resampling:properties</keyword>
            <keyword ref="IT_OPS_TRANSFORM.html#wp1007119" >properties:resample</keyword>
          </section>
          <section title="Rotate Data Properties" ref="IT_OPS_TRANSFORM.html#wp1010900" >
            <keyword ref="IT_OPS_TRANSFORM.html#wp1010902" >rotating:properties</keyword>
            <keyword ref="IT_OPS_TRANSFORM.html#wp1010902" >properties:rotate data</keyword>
          </section>
          <section title="Scale Data Properties" ref="IT_OPS_TRANSFORM.html#wp1011020" >
            <keyword ref="IT_OPS_TRANSFORM.html#wp1011022" >scaling:properties</keyword>
            <keyword ref="IT_OPS_TRANSFORM.html#wp1011022" >properties:scale data</keyword>
          </section>
          <section title="Invert Image Properties" ref="IT_OPS_TRANSFORM.html#wp1007883" >
            <keyword ref="IT_OPS_TRANSFORM.html#wp1007888" >inverting images</keyword>
            <keyword ref="IT_OPS_TRANSFORM.html#wp1007888" >properties:inverting image</keyword>
          </section>
          <section title="Byte Scale Properties" ref="IT_OPS_TRANSFORM.html#wp1007884" >
            <keyword ref="IT_OPS_TRANSFORM.html#wp1010370" >byte scale properties</keyword>
            <keyword ref="IT_OPS_TRANSFORM.html#wp1010370" >properties:byte scale</keyword>
          </section>
        </section>
        <section title="Map Projection Properties " ref="IT_OPS_MAPPROJ.html" >
          <keyword ref="IT_OPS_MAPPROJ.html#wp1012611" >map projections:properties</keyword>
          <keyword ref="IT_OPS_MAPPROJ.html#wp1012611" >properties:map projection</keyword>
        </section>
        <section title="Map Register Image Properties " ref="IT_OPS_MAPIMAGE.html" >
          <keyword ref="IT_OPS_MAPIMAGE.html#wp1012853" >map register image operation properties (iTools)</keyword>
          <keyword ref="IT_OPS_MAPIMAGE.html#wp1012853" >properties:map register image (iTools)</keyword>
        </section>
        <section title="Morphing Properties " ref="IT_OPS_MORPH.html" >
          <keyword ref="IT_OPS_MORPH.html#wp1012365" >morphing:properties</keyword>
          <keyword ref="IT_OPS_MORPH.html#wp1012365" >properties:morphing</keyword>
        </section>
        <section title="Crop Properties " ref="IT_OPS_CROP.html" >
          <keyword ref="IT_OPS_CROP.html#wp1012705" >cropping images:iTools</keyword>
          <keyword ref="IT_OPS_CROP.html#wp1012705" >properties:cropping</keyword>
        </section>
        <section title="Region Grow Properties " ref="IT_OPS_REGIONGROW.html" >
          <keyword ref="IT_OPS_REGIONGROW.html#wp1011192" >region grow:iTool operation properties</keyword>
          <keyword ref="IT_OPS_REGIONGROW.html#wp1011192" >properties:region grow</keyword>
        </section>
        <section title="Contour Properties " ref="IT_OPS_CONTOUR.html" >
          <keyword ref="IT_OPS_CONTOUR.html#wp1012454" >contour</keyword>
          <keyword ref="IT_OPS_CONTOUR.html#wp1012454" >properties:contour</keyword>
        </section>
        <section title="Image Properties " ref="IT_OPS_IMAGE.html" />
        <section title="Surface Properties " ref="IT_OPS_SURFACE.html" />
        <section title="Volume Properties " ref="IT_OPS_VOLUME.html" >
          <section title="Image Plane" ref="IT_OPS_VOLUME.html#wp1011641" >
            <keyword ref="IT_OPS_VOLUME.html#wp1011643" >image plane:properties</keyword>
            <keyword ref="IT_OPS_VOLUME.html#wp1011643" >properties:image plane</keyword>
          </section>
          <section title="Isosurface" ref="IT_OPS_VOLUME.html#wp1008174" />
          <section title="Render Volume" ref="IT_OPS_VOLUME.html#wp1009442" />
          <section title="Interval Volume" ref="IT_OPS_VOLUME.html#wp1011516" />
        </section>
        <section title="Image Plane Properties " ref="IT_OPS_IMAGEPLANE.html" >
          <keyword ref="IT_OPS_IMAGEPLANE.html#wp1011569" >properties:image plane</keyword>
          <keyword ref="IT_OPS_IMAGEPLANE.html#wp1011569" >image plane:properties</keyword>
          <section title="Launch iImage" ref="IT_OPS_IMAGEPLANE.html#wp1011549" >
            <keyword ref="IT_WINDOW_PROPS.html#wp1028128" >drag quality</keyword>
          </section>
        </section>
      </section>
      <section title="Visualization Properties" ref="Visualization_Properties.html" >
        <section title="Introduction to Visualization Properties" ref="Introduction_to_Visualization_Properties.html" />
        <section title="The Visualization Browser" ref="The_Visualization_Browserifp.html" />
        <section title="Window Properties " ref="IT_WINDOW_PROPS.html" >
          <keyword ref="IT_WINDOW_PROPS.html#wp1021455" >iTools:window properties</keyword>
          <keyword ref="IT_WINDOW_PROPS.html#wp1021455" >properties:window</keyword>
        </section>
        <section title="View Properties " ref="IT_VIEW_PROPS.html" >
          <keyword ref="IT_VIEW_PROPS.html#wp1016547" >iTools:view properties</keyword>
          <keyword ref="IT_VIEW_PROPS.html#wp1016547" >properties:view</keyword>
        </section>
        <section title="Visualization Layer Properties " ref="IT_VISLAYER_PROPS.html" >
          <keyword ref="IT_VISLAYER_PROPS.html#wp1021533" >visualizations:layers</keyword>
          <keyword ref="IT_VISLAYER_PROPS.html#wp1021533" >properties:visualization layer</keyword>
        </section>
        <section title="Data Space Properties " ref="IT_DATASPACE_PROPS.html" >
          <keyword ref="IT_DATASPACE_PROPS.html#wp1006678" >dataspace:properties</keyword>
          <keyword ref="IT_DATASPACE_PROPS.html#wp1006678" >properties:dataspace</keyword>
          <section title="Rendering Objects at Data Space Depth" ref="IT_DATASPACE_PROPS.html#wp1037662" />
        </section>
        <section title="Visualization Type Properties" ref="Visualization_Type_Properties.html" >
          <keyword ref="Visualization_Type_Properties.html#wp1009701" >visualizations:type properties</keyword>
          <keyword ref="Visualization_Type_Properties.html#wp1009701" >properties:visualization type</keyword>
          <section title="Image" ref="IT_VISIMAGE_PROPS.html" >
            <keyword ref="IT_VISIMAGE_PROPS.html#wp1010035" >iImage tool:image properties</keyword>
            <keyword ref="IT_VISIMAGE_PROPS.html#wp1010035" >properties:image</keyword>
          </section>
          <section title="Plot" ref="IT_VISPLOT_PROPS.html" >
            <keyword ref="IT_VISPLOT_PROPS.html#wp1018251" >iPlot:properties</keyword>
            <keyword ref="IT_VISPLOT_PROPS.html#wp1018251" >properties:iPlot</keyword>
          </section>
          <section title="Plot 3D" ref="IT_VISPLOT3D_PROPS.html" >
            <keyword ref="IT_VISPLOT3D_PROPS.html#wp1020327" >three-dimensional plots</keyword>
            <keyword ref="IT_VISPLOT3D_PROPS.html#wp1020327" >3D:plots:properties</keyword>
            <keyword ref="IT_VISPLOT3D_PROPS.html#wp1020327" >properties:3D plot</keyword>
          </section>
          <section title="Surface" ref="IT_VISSURFACE_PROPS.html" >
            <keyword ref="IT_VISSURFACE_PROPS.html#wp1036395" >iSurface tool:properties</keyword>
            <keyword ref="IT_VISSURFACE_PROPS.html#wp1036395" >properties:iSurface</keyword>
          </section>
          <section title="Contour" ref="IT_VISCONTOUR_PROPS.html" >
            <keyword ref="IT_VISCONTOUR_PROPS.html#wp1038064" >contours:properties of </keyword>
            <keyword ref="IT_VISCONTOUR_PROPS.html#wp1038064" >properties:contour</keyword>
          </section>
          <section title="Volume" ref="IT_VISVOLUME_PROPS.html" >
            <keyword ref="IT_VISVOLUME_PROPS.html#wp1028187" >properties:volume</keyword>
            <keyword ref="IT_VISVOLUME_PROPS.html#wp1028187" >volumes:properties</keyword>
          </section>
          <section title="Isosurface" ref="IT_VISISOSURFACE_PROPS.html" >
            <keyword ref="IT_VISISOSURFACE_PROPS.html#wp1023148" >isosurfaces:properties</keyword>
            <keyword ref="IT_VISISOSURFACE_PROPS.html#wp1023148" >properties:isosurface</keyword>
          </section>
          <section title="Interval Volume" ref="IT_VISINTERVALVOL_PROPS.html" >
            <keyword ref="IT_VISINTERVALVOL_PROPS.html#wp1023167" >interval volume:properties</keyword>
            <keyword ref="IT_VISINTERVALVOL_PROPS.html#wp1023167" >properties:interval volume</keyword>
          </section>
          <section title="Image Plane" ref="IT_VISIMAGEPLANE_PROPS.html" >
            <keyword ref="IT_VISIMAGEPLANE_PROPS.html#wp1023180" >image plane:properties</keyword>
            <keyword ref="IT_VISIMAGEPLANE_PROPS.html#wp1023180" >properties:image plane</keyword>
          </section>
          <section title="Colorbar" ref="IT_VISCOLORBAR_PROPS.html" >
            <keyword ref="IT_VISCOLORBAR_PROPS.html#wp1023197" >colorbars:properties</keyword>
            <keyword ref="IT_VISCOLORBAR_PROPS.html#wp1023197" >properties:colorbar</keyword>
          </section>
          <section title="Histogram" ref="IT_VISHISTOGRAM_PROPS.html" >
            <keyword ref="IT_VISHISTOGRAM_PROPS.html#wp1036668" >histogram:properties</keyword>
            <keyword ref="IT_VISHISTOGRAM_PROPS.html#wp1036668" >properties:histogram</keyword>
          </section>
          <section title="Axes" ref="IT_VISAXES_PROPS.html" >
            <keyword ref="IT_VISAXES_PROPS.html#wp1036834" >axes:properties</keyword>
            <keyword ref="IT_VISAXES_PROPS.html#wp1036834" >properties:axis</keyword>
          </section>
          <section title="Lights" ref="IT_VISLIGHT_PROPS.html" >
            <keyword ref="IT_VISLIGHT_PROPS.html#wp1006839" >lights:properties</keyword>
            <keyword ref="IT_VISLIGHT_PROPS.html#wp1006839" >properties:lights</keyword>
          </section>
          <section title="Polygonal ROI" ref="IT_VISPOLYROI_PROPS.html" >
            <keyword ref="IT_VISPOLYROI_PROPS.html#wp1026542" >polygonal ROIs</keyword>
            <keyword ref="IT_VISPOLYROI_PROPS.html#wp1026542" >properties:polygonal ROIs</keyword>
          </section>
          <section title="IDL Graphics Objects" ref="IT_VISGROBJ_PROPS.html" />
          <section title="Map Grid" ref="IT_VISMAP_PROPS.html" >
            <keyword ref="IT_VISMAP_PROPS.html#wp1029590" >polygonal ROIs</keyword>
            <keyword ref="IT_VISMAP_PROPS.html#wp1029590" >properties:polygonal ROIs</keyword>
          </section>
          <section title="ShapePolygon" ref="IT_VISSHPOLYGON_PROPS.html" >
            <keyword ref="IT_VISSHPOLYGON_PROPS.html#wp1028825" >polygonal ROIs</keyword>
            <keyword ref="IT_VISSHPOLYGON_PROPS.html#wp1028825" >properties:polygonal ROIs</keyword>
          </section>
          <section title="ShapePolyline" ref="IT_VISSHPOLYLINE_PROPS.html" >
            <keyword ref="IT_VISSHPOLYLINE_PROPS.html#wp1029801" >polygonal ROIs</keyword>
            <keyword ref="IT_VISSHPOLYLINE_PROPS.html#wp1029801" >properties:polygonal ROIs</keyword>
          </section>
          <section title="ShapePoint " ref="IT_VISSHPOINT_PROPS.html" >
            <keyword ref="IT_VISSHPOINT_PROPS.html#wp1029027" >polygonal ROIs</keyword>
            <keyword ref="IT_VISSHPOINT_PROPS.html#wp1029027" >properties:polygonal ROIs</keyword>
          </section>
        </section>
        <section title="2D Annotation Layer Properties" ref="IT_2DANNOT_PROPS.html" >
          <keyword ref="IT_2DANNOT_PROPS.html#wp1036873" >2D:annotation layer</keyword>
          <keyword ref="IT_2DANNOT_PROPS.html#wp1036873" >properties:2D annotation layer</keyword>
          <keyword ref="IT_2DANNOT_PROPS.html#wp1036873" >annotation layer</keyword>
          <section title="Text Annotation Properties" ref="IT_2DTEXT_PROPS.html" />
          <section title="Line Annotation Properties" ref="IT_2DLINE_PROPS.html" >
            <keyword ref="IT_2DLINE_PROPS.html#wp1021795" >line annotations:properties</keyword>
            <keyword ref="IT_2DLINE_PROPS.html#wp1021795" >properties:line annotation</keyword>
          </section>
          <section title="Line Profile Annotation Properties" ref="IT_LINEPROFILE_PROPS.html" >
            <keyword ref="IT_LINEPROFILE_PROPS.html#wp1026123" >lines:profiles:annotating</keyword>
            <keyword ref="IT_LINEPROFILE_PROPS.html#wp1026123" >properties:line profile annotation</keyword>
          </section>
          <section title="Rectangle Annotation Properties" ref="IT_2DRECT_PROPS.html" >
            <keyword ref="IT_2DRECT_PROPS.html#wp1010590" >rectangle annotations:properties</keyword>
            <keyword ref="IT_2DRECT_PROPS.html#wp1010590" >properties:rectangle annotation</keyword>
          </section>
          <section title="Oval Annotation Properties" ref="IT_2DOVAL_PROPS.html" />
          <section title="Polygon Annotation Properties" ref="IT_2DPOLYGON_PROPS.html" >
            <keyword ref="IT_2DPOLYGON_PROPS.html#wp1021952" >polygon annotations</keyword>
            <keyword ref="IT_2DPOLYGON_PROPS.html#wp1021952" >properties:polygon annotation:properties</keyword>
          </section>
          <section title="Freehand Annotation Properties" ref="IT_2DFREEHAND_PROPS.html" >
            <keyword ref="IT_2DFREEHAND_PROPS.html#wp1010611" >freehand annotations:properties</keyword>
            <keyword ref="IT_2DFREEHAND_PROPS.html#wp1010611" >properties:freehand annotation</keyword>
          </section>
        </section>
        <section title="Legend Properties" ref="IT_LEGEND_PROPS.html" >
          <keyword ref="IT_LEGEND_PROPS.html#wp1026143" >legends:properties</keyword>
          <keyword ref="IT_LEGEND_PROPS.html#wp1026143" >properties:legend</keyword>
          <section title="Legend Contour Items " ref="IT_LEGEND_CONTOUR.html" >
            <keyword ref="IT_LEGEND_CONTOUR.html#wp1025675" >contours:legend properties</keyword>
            <keyword ref="IT_LEGEND_CONTOUR.html#wp1025675" >properties:contour legend</keyword>
          </section>
          <section title="Legend Contour Level Items " ref="IT_LEGEND_CONTOUR_LEVEL.html" >
            <keyword ref="IT_LEGEND_CONTOUR_LEVEL.html#wp1025941" >contours:legend level properties</keyword>
            <keyword ref="IT_LEGEND_CONTOUR_LEVEL.html#wp1025941" >properties:contour legend level</keyword>
          </section>
          <section title="Legend Plot Items " ref="IT_LEGEND_PLOT.html" >
            <keyword ref="IT_LEGEND_PLOT.html#wp1025995" >plots:legend</keyword>
            <keyword ref="IT_LEGEND_PLOT.html#wp1025995" >properties:plot legend</keyword>
          </section>
          <section title="Legend Surface Items " ref="IT_LEGEND_SURFACE.html" >
            <keyword ref="IT_LEGEND_SURFACE.html#wp1026062" >surfaces:legends</keyword>
            <keyword ref="IT_LEGEND_SURFACE.html#wp1026062" >properties:surface legend</keyword>
          </section>
        </section>
      </section>
    </section>
  </DCF>
	<DCF title="Data Analysis and Visualization Environment" ref="dave_home.html" >
		<section title="License/Disclaimer" ref="dave_home.html#disclaimer" >
			<keyword ref="dave_home.html#disclaimer" >DAVE:license</keyword>
			<keyword ref="dave_home.html#disclaimer" >DAVE:disclaimer</keyword>
			<keyword ref="dave_home.html#disclaimer" >DAVE software license</keyword>
			<keyword ref="dave_home.html#disclaimer" >DAVE license</keyword>
		</section>
		<section title="Acknowledgements" ref="dave_home.html#acknowledgment" >
			<keyword ref="dave_home.html#acknowledgment" >DAVE:acknowledgment</keyword>
			<keyword ref="dave_home.html#acknowledgment" >DAVE:developers</keyword>
			<keyword ref="dave_home.html#acknowledgment" >DAVE:contributors</keyword>
		</section>
		<section title="Obtaining and Installing DAVE" ref="dave_installation.html" >
			<keyword ref="dave_installation.html" >DAVE:Obtaining</keyword>
			<keyword ref="dave_installation.html" >DAVE:Download</keyword>
			<keyword ref="dave_installation.html" >DAVE:Installation help</keyword>
			<keyword ref="dave_installation.html" >DAVE:Source code distribution</keyword>
			<keyword ref="dave_installation.html" >DAVE:Binary distribution</keyword>
			<keyword ref="dave_installation.html" >Installation:DAVE</keyword>
			<keyword ref="dave_installation.html" >Download:DAVE</keyword>
		</section>
		<section title="Overview of DAVE" ref="dave_overview.html" >
			<keyword ref="dave_overview.html" >DAVE:introduction</keyword>
			<keyword ref="dave_overview.html" >DAVE:overview</keyword>
			<keyword ref="dave_overview.html" >Introduction:DAVE</keyword>
			<keyword ref="dave_overview.html" >Overview of DAVE</keyword>
			<section title="Brief Historical Context" ref="dave_overview.html#historical_bkgd" >
				<keyword ref="dave_overview.html#historical_bkgd" >DAVE:history</keyword>
				<keyword ref="dave_overview.html#historical_bkgd" >History:DAVE</keyword>
			</section>
			<section title="Principal Project Goals" ref="dave_overview.html#main_goals" >
				<keyword ref="dave_overview.html#main_goals" >DAVE:objectives</keyword>
				<keyword ref="dave_overview.html#main_goals" >DAVE:goals</keyword>
				<keyword ref="dave_overview.html#main_goals" >Objectives:DAVE</keyword>
			</section>
		</section>
		<section title="Description of DAVE Software Package" ref="dave_description.html" >
			<keyword ref="dave_description.html" >DAVE:description</keyword>
			<keyword ref="dave_description.html" >DAVE:main Features</keyword>
			<keyword ref="dave_description.html" >Description of DAVE</keyword>
			<section title="Software Categories in DAVE 1.x" ref="dave_description.html#dave_desc_1xcat" >
				<keyword ref="dave_description.html#dave_desc_1xcat" >DAVE:categories in 1.x</keyword>
				<keyword ref="dave_description.html#dave_desc_1xcat" >DAVE 1.x:categories</keyword>
			</section>
			<section title="Key Elements in DAVE 2.x" ref="dave_description.html#dave_desc_2xcat" >
				<keyword ref="dave_description.html#dave_desc_2xcat" >DAVE:components in 2.x</keyword>
				<keyword ref="dave_description.html#dave_desc_2xcat" >DAVE 2.x:components</keyword>
			</section>
		</section>
		<section title="Getting Started: A Tutorial " ref="dave_gettingstarted.html" >
			<keyword ref="dave_gettingstarted.html" >DAVE:Getting started</keyword>
			<keyword ref="dave_gettingstarted.html" >Getting started</keyword>
			<section title="A Brief Introduction" ref="dave_gettingstarted.html#intro" >
				<keyword ref="dave_gettingstarted.html#ui" >DAVE:Getting Started:Introduction</keyword>
			</section>
			<section title="The Main Application Window" ref="dave_gettingstarted.html#ui" >
				<keyword ref="dave_gettingstarted.html#ui" >DAVE:Getting Started:Main Window</keyword>
				<keyword ref="dave_gettingstarted.html#ui" >Main Window</keyword>
			</section>
			<section title="Loading Data" ref="dave_gettingstarted.html#read" >
				<keyword ref="dave_gettingstarted.html#read" >DAVE:Getting Started:Load Data</keyword>
			</section>
			<section title="Manipulating and Vizualizing Data" ref="dave_gettingstarted.html#intro" >
				<keyword ref="dave_gettingstarted.html#viz" >DAVE:Getting Started:Manipulating data</keyword>
				<keyword ref="dave_gettingstarted.html#viz" >DAVE:Getting Started:Visualize data</keyword>
			</section>
			<section title="Printing or Exporting Graphics" ref="dave_gettingstarted.html#export" >
				<keyword ref="dave_gettingstarted.html#export" >DAVE:Getting Started:Print graphics</keyword>
				<keyword ref="dave_gettingstarted.html#export" >DAVE:Getting Started:Export graphics</keyword>
			</section>
			<section title="Saving Datasets and/or Project" ref="dave_gettingstarted.html#save" >
				<keyword ref="dave_gettingstarted.html#save" >DAVE:Getting Started:Save Dataset</keyword>
				<keyword ref="dave_gettingstarted.html#save" >DAVE:Getting Started:Save Project</keyword>
			</section>
		</section>
		<section title="Data Reduction" ref="dave_reduction.html">
			<section title="FANS Data Reduction" ref="fans_data_reduction.html" >
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Load Raw Data</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Delete Loaded Data</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Plot Data</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Reduction Preferences</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Merge Multiple Datasets</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Mask Detectors</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Fit Fast Background</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Subtract Background</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Subtract Fast Background</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Monitor Rescaling</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Print and Print Preview</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Reseting Preferences</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:View Raw Data Contents</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:View Reduction History</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Save Data:DAVE Format</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Save Data:ASCII Format</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Export Data:DAVE Data Manager</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Export Data:Fitting Module (PAN)</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Energy Units</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Session Management:Load</keyword>
				<keyword ref="fans_data_reduction.html#" >Data Reduction:FANS:Session Management:Save</keyword>
			</section>


			<section title="BT7 PSD Data Reduction" ref="bt7psd_data_reduction.html" >
				<section title="The Main Application Window" ref="bt7psd_data_reduction.html#ui" >
				</section>
				<section title="Loading and Viewing Datasets" ref="bt7psd_data_reduction.html#load" >
				</section>
				<section title="User Preferences" ref="bt7psd_data_reduction.html#pref" >
					<keyword ref="bt7psd_data_reduction.html#samptype" >Data Reduction:BT7 PSD:Sample Type</keyword>
					<keyword ref="bt7psd_data_reduction.html#calibparam" >Data Reduction:BT7 PSD:PSD Calib Parameter file</keyword>
					<keyword ref="bt7psd_data_reduction.html#applyeff" >Data Reduction:BT7 PSD:Channel Efficiency</keyword>
					<keyword ref="bt7psd_data_reduction.html#scanvar" >Data Reduction:BT7 PSD:Scan Variable</keyword>
					<keyword ref="bt7psd_data_reduction.html#haxisvar" >Data Reduction:BT7 PSD:Horizontal Axis Variable</keyword>
					<keyword ref="bt7psd_data_reduction.html#vaxisvar" >Data Reduction:BT7 PSD:Vertical Axis Variable</keyword>
					<keyword ref="bt7psd_data_reduction.html#qxqyunits" >Data Reduction:BT7 PSD:Units of QX, QY</keyword>
					<keyword ref="bt7psd_data_reduction.html#minbinwidth" >Data Reduction:BT7 PSD:Min Bin Width (scan var)</keyword>
					<keyword ref="bt7psd_data_reduction.html#defIntRange" >Data Reduction:BT7 PSD:Intensity Range</keyword>
					<keyword ref="bt7psd_data_reduction.html#minIntVal" >Data Reduction:BT7 PSD:Minimum Intensity</keyword>
					<keyword ref="bt7psd_data_reduction.html#maxIntVal" >Data Reduction:BT7 PSD:Maximum Intensity</keyword>
					<keyword ref="bt7psd_data_reduction.html#lattparamsource" >Data Reduction:BT7 PSD:Lattice Parameters Source</keyword>
					<keyword ref="bt7psd_data_reduction.html#lattparamvalue" >Data Reduction:BT7 PSD:Lattice Parameters</keyword>
					<keyword ref="bt7psd_data_reduction.html#maskflag" >Data Reduction:BT7 PSD:Remove Masked Channels?</keyword>
					<keyword ref="bt7psd_data_reduction.html#maskedchans" >Data Reduction:BT7 PSD:Channels to Mask</keyword>
					<keyword ref="bt7psd_data_reduction.html#normto" >Data Reduction:BT7 PSD:Normalization Quantity</keyword>
					<keyword ref="bt7psd_data_reduction.html#scalefactor" >Data Reduction:BT7 PSD:Overall Scale Factor</keyword>
					<keyword ref="bt7psd_data_reduction.html#fastflag" >Data Reduction:BT7 PSD:Fast Bkgd Correction Flag</keyword>
					<keyword ref="bt7psd_data_reduction.html#fastvalue" >Data Reduction:BT7 PSD:Fast Bkgd Value</keyword>
					<keyword ref="bt7psd_data_reduction.html#moncor" >Data Reduction:BT7 PSD:Monitor Correction</keyword>
					<keyword ref="bt7psd_data_reduction.html#rescor" >Data Reduction:BT7 PSD:Resolution Correction</keyword>
					<keyword ref="bt7psd_data_reduction.html#detbal" >Data Reduction:BT7 PSD:Detailed Balance Correction</keyword>
					<keyword ref="bt7psd_data_reduction.html#multimslice" >Data Reduction:BT7 PSD:Mslice</keyword>
				</section>
				<section title="Loading and Viewing Datasets" ref="bt7psd_data_reduction.html#load" >
				</section>
				<section title="Saving and Exporting Datasets" ref="bt7psd_data_reduction.html#saving" >
					<keyword ref="bt7psd_data_reduction.html#export2pan" >Data Reduction:BT7 PSD:Fitting (PAN)</keyword>
					<keyword ref="bt7psd_data_reduction.html#export2dave" >Data Reduction:BT7 PSD:DAVE Data Manager</keyword>
					<keyword ref="bt7psd_data_reduction.html#save2ascii" >Data Reduction:BT7 PSD:ASCII file</keyword>
					<keyword ref="bt7psd_data_reduction.html#save2dave" >Data Reduction:BT7 PSD:DAVE file</keyword>
				</section>
				<section title="Printing and Exporting Graphics" ref="bt7psd_data_reduction.html#printing" >
					<keyword ref="bt7psd_data_reduction.html#printing" >Data Reduction:BT7 PSD:Print Preview</keyword>
					<keyword ref="bt7psd_data_reduction.html#printing" >Data Reduction:BT7 PSD:EPS JPEG GIF PNG PDF</keyword>
				</section>
				<section title="Session Management" ref="bt7psd_data_reduction.html#session" >
				</section>
			</section>
		</section>
		<section title="Loading and Saving Datasets" ref="dave_datasetio.html">
			<keyword ref="dave_datasetio.html#read" >DAVE:Importing:data</keyword>
			<keyword ref="dave_datasetio.html#write" >DAVE:Exporting:data</keyword>
			<keyword ref="dave_datasetio.html#formats" >DAVE:suported data formats</keyword>
			<keyword ref="dave_datasetio.html#formats" >Data Formats:suported data formats</keyword>
			<keyword ref="dave_datasetio.html#formats" >Data Formats:ASCII</keyword>
			<keyword ref="dave_datasetio.html#formatscol" >Data Formats:ASCII Column</keyword>
			<keyword ref="dave_datasetio.html#formatsgrp" >Data Formats:ASCII Group</keyword>
			<keyword ref="dave_datasetio.html#formatsspe" >Data Formats:ASCII SPE</keyword>
			<keyword ref="dave_datasetio.html#formatsdave" >Data Formats:DAVE</keyword>
			<keyword ref="dave_datasetio.html#read" >Reading:data into DAVE</keyword>
			<keyword ref="dave_datasetio.html#read" >Reading:data files</keyword>
			<keyword ref="dave_datasetio.html#write" >Writing:data from DAVE</keyword>
			<keyword ref="dave_datasetio.html#write" >Writing:data files</keyword>
			<keyword ref="dave_datasetio.html#write" >Exporting:data from DAVE</keyword>
			<keyword ref="dave_datasetio.html#write" >Exporting:ASCII Data</keyword>
			<keyword ref="dave_datasetio.html#write" >Exporting:DAVE Data</keyword>
			<keyword ref="dave_datasetio.html#read" >Importing:data into DAVE</keyword>
			<keyword ref="dave_datasetio.html#read_col" >Importing:ASCII Col data</keyword>
			<keyword ref="dave_datasetio.html#read_grpspe" >Importing:ASCII Group Data</keyword>
			<keyword ref="dave_datasetio.html#read_grpspe" >Importing:ASCII SPE Data</keyword>
			<keyword ref="dave_datasetio.html#read_dave" >Importing:DAVE</keyword>
			<section ref="dave_datasetio.html#intro" title="Introduction">
			</section>
			<section ref="dave_datasetio.html#read" title="Reading/Loading Data from File">
			</section>
			<section ref="dave_datasetio.html#write" title="Writing/Saving Data to File">
			</section>
			<section ref="dave_datasetio.html#formats" title="Description of Supported File Formats">
			</section>
		</section>
		<section title="Introduction to Visualization" ref="dave_visualization.html">
			<keyword ref=".html"></keyword>
		</section>
		<section title="Data Manipulation and Analysis Operations" ref="dave_analysis.html">
			<keyword ref=".html"></keyword>
		</section>
		<section title="Exporting Graphics" ref="dave_graphics.html">
			<keyword ref=".html"></keyword>
		</section>
		<section title="DAVE Sessions" ref="dave_projects.html">
			<keyword ref=".html"></keyword>
		</section>
		<section title="Planning and other Miscellaneous Tools" ref="dave_tools.html">
			<keyword ref=".html"></keyword>
		</section>
		<section title="PDF documentation for self-contained program modules" ref="dave_pdfdocs.html">
			<keyword ref=".html"></keyword>
		</section>
	</DCF>
</assistantconfig>
