/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.symbol.shape;

import com.rsi.pdf.map.symbol.shape.AbstractShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class Pushpin
extends AbstractShape {
    @Override
    public void drawShape(PDPageContentStream contentStream, float screenX, float screenY, float size, float rotation) throws IOException {
        AffineTransform utilXform = new AffineTransform();
        utilXform.setToIdentity();
        Path2D.Float pin = new Path2D.Float();
        pin.moveTo(0.0f, 0.0f);
        pin.lineTo((double)(-(size / 30.0f)), (double)size * 0.4);
        pin.lineTo((double)(size / 30.0f), (double)size * 0.4);
        pin.closePath();
        Rectangle2D.Float rect = new Rectangle2D.Float(-(size * 0.25f), -(size * 0.52f), size / 2.0f, size / 3.0f);
        Arc2D.Float bottom = new Arc2D.Float(rect, 0.0f, 180.0f, 2);
        utilXform.scale(1.0, -1.0);
        Shape arcScaled = utilXform.createTransformedShape(bottom);
        Rectangle2D.Float shaft = new Rectangle2D.Float(-(size * 0.1f), size * 0.47f, size / 5.0f, size / 2.0f);
        utilXform.setToIdentity();
        utilXform.scale(0.75, 0.75);
        utilXform.translate(0.0, (double)size * 1.7);
        Shape top = utilXform.createTransformedShape(bottom);
        Area area = new Area(pin);
        area.add(new Area(arcScaled));
        area.add(new Area(shaft));
        area.add(new Area(top));
        utilXform.setToIdentity();
        utilXform.translate(screenX, screenY);
        Shape path = utilXform.createTransformedShape(area);
        if (rotation != 0.0f) {
            utilXform.setToIdentity();
            utilXform.rotate(Math.toRadians(-rotation), screenX, screenY);
        }
        this.drawPathIterator(path.getPathIterator(utilXform), contentStream);
    }

    @Override
    public boolean hasFill() {
        return true;
    }

    @Override
    public boolean hasOutline() {
        return true;
    }

    @Override
    public String getName() {
        return "Pushpin";
    }
}

