/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.layer;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.symbol.ISymbol;
import com.rsi.pdf.map.symbol.LineSymbol;
import com.rsi.pdf.map.symbol.PointSymbol;
import com.rsi.pdf.map.symbol.PolygonSymbol;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.PDExtendedGraphicsState;

public abstract class AbstractLayer {
    private float opacity = 1.0f;
    private String name = null;
    private PdfMap pdfMap = null;
    private PDDocument doc = null;
    private PDPage page = null;
    private boolean visible = true;

    public AbstractLayer(PdfMap pdfMap, String name, float opacity) {
        if (pdfMap == null || name == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.pdfMap = pdfMap;
        this.name = name.replace(' ', '_');
        this.opacity = opacity;
        this.doc = pdfMap.getDocument();
        this.page = pdfMap.getPage();
    }

    public abstract void render(PDPageContentStream var1) throws IOException;

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public String getName() {
        return this.name;
    }

    protected void addGraphicsState(String name, float transparency) {
        PDExtendedGraphicsState extendedGraphicsState = new PDExtendedGraphicsState();
        extendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(transparency));
        extendedGraphicsState.setStrokingAlphaConstant(Float.valueOf(transparency));
        PDResources resources = this.getPdfPage().findResources();
        Map<String, PDExtendedGraphicsState> graphicsStateDictionary = resources.getGraphicsStates();
        if (graphicsStateDictionary == null) {
            graphicsStateDictionary = new HashMap<String, PDExtendedGraphicsState>();
            resources.setGraphicsStates(graphicsStateDictionary);
        }
        graphicsStateDictionary.put(name, extendedGraphicsState);
        resources.setGraphicsStates(graphicsStateDictionary);
    }

    public Point2D.Float toPixel(double mapPtX, double mapPtY) {
        Point2D.Float point = null;
        Envelope projMapExtent = this.getPdfMap().getProjectedMapExtent();
        float pageWidth = this.getPdfPage().getMediaBox().getWidth();
        float pageHeight = this.getPdfPage().getMediaBox().getHeight();
        double x = (mapPtX - projMapExtent.getMinX()) * ((double)pageWidth / projMapExtent.getWidth());
        double y = (mapPtY - projMapExtent.getMinY()) * ((double)pageHeight / projMapExtent.getHeight());
        point = new Point2D.Float((float)x, (float)y);
        return point;
    }

    public PdfMap getPdfMap() {
        return this.pdfMap;
    }

    public PDDocument getPdfDocument() {
        return this.doc;
    }

    public PDPage getPdfPage() {
        return this.page;
    }

    private void drawLinearRing(LinearRing ring, PDPageContentStream cStream) throws IOException {
        if (ring != null) {
            for (int i = 0; i < ring.getNumPoints(); ++i) {
                Point2D.Float awtPnt = this.toPixel(ring.getPointN(i).getX(), ring.getPointN(i).getY());
                float x = awtPnt.x;
                float y = awtPnt.y;
                if (i == 0) {
                    cStream.moveTo(x, y);
                    continue;
                }
                cStream.lineTo(x, y);
            }
            cStream.closeSubPath();
        }
    }

    private void drawLine(LineString line, PDPageContentStream cStream) throws IOException {
        if (line != null) {
            for (int i = 0; i < line.getNumPoints(); ++i) {
                Point2D.Float awtPnt = this.toPixel(line.getPointN(i).getX(), line.getPointN(i).getY());
                float x = awtPnt.x;
                float y = awtPnt.y;
                if (i == 0) {
                    cStream.moveTo(x, y);
                    continue;
                }
                cStream.lineTo(x, y);
            }
        }
    }

    private void drawPolygon(Polygon poly, PDPageContentStream cStream) throws IOException {
        if (poly != null) {
            this.drawLinearRing((LinearRing)poly.getExteriorRing(), cStream);
            int ringCnt = poly.getNumInteriorRing();
            if (ringCnt > 0) {
                for (int n = 0; n < ringCnt; ++n) {
                    this.drawLinearRing((LinearRing)poly.getInteriorRingN(n), cStream);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawGeometry(Geometry geom, ISymbol symbol, PDPageContentStream cStream) throws IOException {
        cStream.saveGraphicsState();
        if (geom instanceof Point) {
            Point pt = (Point)geom;
            if (!(symbol instanceof PointSymbol)) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : null or incorrect symbol type for Point geometry");
            PointSymbol pSym = (PointSymbol)symbol;
            Point2D.Float awtPnt = this.toPixel(pt.getX(), pt.getY());
            if (pSym.getFillColor() != null && pSym.hasFill()) {
                cStream.setNonStrokingColor(pSym.getFillColor());
                pSym.getShape().drawShape(cStream, awtPnt.x, awtPnt.y, pSym.getSize(), pSym.getRotation());
                cStream.fill(0);
            }
            if (pSym.getOutlineColor() != null && pSym.hasOutline()) {
                cStream.setLineWidth(0.5f);
                cStream.setStrokingColor(pSym.getOutlineColor());
                pSym.getShape().drawShape(cStream, awtPnt.x, awtPnt.y, pSym.getSize(), pSym.getRotation());
                cStream.stroke();
            }
        } else if (geom instanceof LineString) {
            if (!(symbol instanceof LineSymbol)) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : null or incorrect symbol type for LineString geometry");
            LineSymbol lSym = (LineSymbol)symbol;
            cStream.setStrokingColor(lSym.getColor());
            cStream.setLineWidth(lSym.getWidth());
            if (lSym.getDashPattern() != null) {
                cStream.setLineDashPattern(lSym.getDashPattern().getPattern(), lSym.getDashPattern().getPhase());
            }
            this.drawLine((LineString)geom, cStream);
            cStream.stroke();
        } else if (geom instanceof Polygon) {
            if (!(symbol instanceof PolygonSymbol)) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : null or incorrect symbol type for Polygon geometry");
            PolygonSymbol pSym = (PolygonSymbol)symbol;
            Color fillColor = pSym.getFillColor();
            if (pSym.getDrawFill() && fillColor != null) {
                cStream.setNonStrokingColor(fillColor);
                this.drawPolygon((Polygon)geom, cStream);
                cStream.fill(0);
            }
            if (pSym.getDrawOutline()) {
                LineSymbol lSym = pSym.getLineSymbol();
                cStream.setStrokingColor(lSym.getColor());
                cStream.setLineWidth(lSym.getWidth());
                if (lSym.getDashPattern() != null) {
                    cStream.setLineDashPattern(lSym.getDashPattern().getPattern(), lSym.getDashPattern().getPhase());
                }
                this.drawPolygon((Polygon)geom, cStream);
                cStream.stroke();
            }
        } else {
            if (!(geom instanceof GeometryCollection)) throw new IllegalArgumentException(String.valueOf(this.getClass()) + " : unknown or unsupported geometry type");
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                this.drawGeometry(geom.getGeometryN(i), symbol, cStream);
            }
        }
        cStream.restoreGraphicsState();
    }

    public Color generateRandomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }
}

