/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.annotation;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.annotation.IAnnotation;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class ImageIcon
implements IAnnotation {
    private IAnnotation.ScreenLocation mapLocation = null;
    private Point point = null;
    private String imagePath = null;
    private Point2D.Float offset = null;
    private float rotation = 0.0f;
    private PdfMap pdfMap = null;
    private PDXObjectImage ximage = null;

    public ImageIcon(String imagePath, Point point, PdfMap pdfMap) throws IOException {
        this.imagePath = imagePath;
        this.point = point;
        this.pdfMap = pdfMap;
        this.fetchImage();
    }

    public ImageIcon(String imagePath, IAnnotation.ScreenLocation location, PdfMap pdfMap) throws IOException {
        this.imagePath = imagePath;
        this.mapLocation = location;
        this.pdfMap = pdfMap;
        this.fetchImage();
    }

    private void fetchImage() throws IOException {
        this.ximage = new PDPixelMap(this.pdfMap.getDocument(), ImageIO.read(new File(this.imagePath)));
    }

    public IAnnotation.ScreenLocation getMapLocation() {
        return this.mapLocation;
    }

    public Point getPoint() {
        return this.point;
    }

    public PDXObjectImage getImage() {
        return this.ximage;
    }

    public Point2D.Float getOffset() {
        return this.offset;
    }

    public void setOffset(float x, float y) {
        this.offset = new Point2D.Float(x, y);
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }
}

