/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import com.rsi.javab.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;

public class ReflUtil {
    private static Class typeToClass(String sClass, Class basicClass, int arrayDepth) {
        Class cl = null;
        if (arrayDepth > 0) {
            Object sub = "";
            for (int i = 0; i < arrayDepth; ++i) {
                sub = "[" + (String)sub;
            }
            sub = (String)sub + sClass;
            cl = ClassUtil.findClass((String)sub);
        } else {
            cl = basicClass;
        }
        return cl;
    }

    public static String convertClassToString(Class cl) {
        String sType = null;
        Object sRetType = null;
        if (cl == null) {
            return null;
        }
        if (cl.isPrimitive()) {
            sType = cl.toString();
            if (sType == null) {
                sRetType = null;
            }
            sRetType = sType.equals("int") ? "I" : (sType.equals("boolean") ? "Z" : (sType.equals("byte") ? "B" : (sType.equals("char") ? "C" : (sType.equals("short") ? "S" : (sType.equals("int") ? "I" : (sType.equals("long") ? "J" : (sType.equals("float") ? "F" : (sType.equals("double") ? "D" : (sType.equals("void") ? "V" : null)))))))));
        } else {
            sRetType = cl.isArray() ? cl.getName() : "L" + cl.getName() + ";";
            sRetType = ((String)sRetType).replace('.', '/');
        }
        return sRetType;
    }

    public static String getClassName(Object obj) {
        Class<?> cl = obj.getClass();
        String s = cl.getName();
        return s;
    }

    private static Class[] sigToClassArray(String sSig, boolean translateVoid) {
        Class[] classArr = null;
        int arrayDepth = 0;
        Vector<Class> v = new Vector<Class>();
        int slen = sSig.length();
        block15: for (int pos = 0; pos < slen; ++pos) {
            char c = sSig.charAt(pos);
            switch (c) {
                case 'X': {
                    int semipos = sSig.indexOf(59, pos);
                    if (sSig.substring(pos + 1, semipos).equals("null")) {
                        v.addElement(null);
                    }
                    pos = semipos;
                    arrayDepth = 0;
                    continue block15;
                }
                case 'Z': {
                    v.addElement(ReflUtil.typeToClass("" + c, Boolean.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'B': {
                    v.addElement(ReflUtil.typeToClass("" + c, Byte.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'C': {
                    v.addElement(ReflUtil.typeToClass("" + c, Character.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'S': {
                    v.addElement(ReflUtil.typeToClass("" + c, Short.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'I': {
                    v.addElement(ReflUtil.typeToClass("" + c, Integer.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'J': {
                    v.addElement(ReflUtil.typeToClass("" + c, Long.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'F': {
                    v.addElement(ReflUtil.typeToClass("" + c, Float.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case 'D': {
                    v.addElement(ReflUtil.typeToClass("" + c, Double.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
                case '[': {
                    ++arrayDepth;
                    continue block15;
                }
                case 'L': {
                    Class cl;
                    Object sub;
                    int semipos = sSig.indexOf(59, pos);
                    if (arrayDepth > 0) {
                        sub = sSig.substring(pos, semipos + 1).replace('/', '.');
                        for (int i = 0; i < arrayDepth; ++i) {
                            sub = "[" + (String)sub;
                        }
                    } else {
                        sub = sSig.substring(pos + 1, semipos).replace('/', '.');
                    }
                    if ((cl = ClassUtil.findClass((String)sub)) != null) {
                        v.addElement(cl);
                    }
                    arrayDepth = 0;
                    pos = semipos;
                    continue block15;
                }
                case ')': {
                    pos = slen;
                    continue block15;
                }
                case '(': 
                case 'V': {
                    if (!translateVoid) continue block15;
                    v.addElement(ReflUtil.typeToClass("" + c, Void.TYPE, arrayDepth));
                    arrayDepth = 0;
                    continue block15;
                }
            }
        }
        classArr = v.toArray(new Class[v.size()]);
        return classArr;
    }

    public static Class[] sigToClassArray(String sSig) {
        boolean TRANSLATE_VOID = false;
        return ReflUtil.sigToClassArray(sSig, TRANSLATE_VOID);
    }

    public static Class sigToReturnType(String sSig) {
        String sub;
        Class[] tmpClasses;
        boolean TRANSLATE_VOID = true;
        Class retVal = null;
        int pos = 0;
        pos = sSig.lastIndexOf(41);
        if (pos != -1 && (tmpClasses = ReflUtil.sigToClassArray(sub = sSig.substring(pos + 1), TRANSLATE_VOID)) != null) {
            retVal = tmpClasses[0];
        }
        return retVal;
    }

    public static String methodToJNISig(Method m) {
        Object sRetVal = "(";
        Class<?>[] classArr = m.getParameterTypes();
        Class<?> retClass = m.getReturnType();
        for (int i = 0; i < classArr.length; ++i) {
            sRetVal = (String)sRetVal + ReflUtil.convertClassToString(classArr[i]);
        }
        sRetVal = (String)sRetVal + ")" + ReflUtil.convertClassToString(retClass);
        return sRetVal;
    }

    public static String fieldToJNIType(Field f) {
        String sRetVal = "";
        sRetVal = ReflUtil.convertClassToString(f.getType());
        return sRetVal;
    }

    public static String ctorToJNISig(Constructor m) {
        Object sRetVal = "(";
        Class<?>[] classArr = m.getParameterTypes();
        for (int i = 0; i < classArr.length; ++i) {
            sRetVal = (String)sRetVal + ReflUtil.convertClassToString(classArr[i]);
        }
        sRetVal = (String)sRetVal + ")V";
        return sRetVal;
    }
}

