# Korn shell commands to define IDL environment variables and aliases.
#
# This script can be used by IDL users who use ksh as their interactive shell
# to define the environment variables and aliases required by IDL
# related commands (idl, idlde, idlhelp) if the symbolic links to
# the default directory (/usr/local/nv5/idl) are not being used.
#
# ksh users should run idl_setup from their .profile file 
# using the following command:
#
#    . /usr/local/nv5/idl92/bin/idl_setup.ksh
#
ENVI_IDL_DIR=/usr/local/nv5
IDL_DIR=/usr/local/nv5/idl92
export IDL_DIR ENVI_IDL_DIR
alias -x envi_idl_license_admin=$IDL_DIR/bin/envi_idl_license_admin
alias -x idl=$IDL_DIR/bin/idl
if [ -x $IDL_DIR/bin/idlde ]; then
  alias -x idlde=$IDL_DIR/bin/idlde
fi
if [ -x $IDL_DIR/bin/idlhelp ]; then
  alias -x idlhelp=$IDL_DIR/bin/idlhelp
fi
if [ -x $IDL_DIR/bin/idlrpc ]; then
  alias -x idlrpc=$IDL_DIR/bin/idlrpc
fi
if [ -x $IDL_DIR/bin/idltaskengine ]; then 
  alias -x idltaskengine=$IDL_DIR/bin/idltaskengine
fi

