/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map;

import com.rsi.pdf.geopdf.PdfUtils;
import com.rsi.pdf.map.layer.AbstractLayer;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.markedcontent.PDPropertyList;

public class PdfMap {
    public static final String GEOGCS_WGS_84 = "GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    public static final String shapeClassPath = "com.rsi.pdf.map.symbol.shape";
    private List<AbstractLayer> layers = new ArrayList<AbstractLayer>();
    private PDPageContentStream contentStream = null;
    private PDDocument doc = null;
    private PDPage page = null;
    private Envelope geoMapExtent = null;
    private Envelope projMapExtent = null;
    private Color backColor = Color.WHITE;
    private PDDocumentInformation docInfo = new PDDocumentInformation();

    public PdfMap(Envelope geographicMapExtent, Envelope projectedMapExtent, PDRectangle size, String crs) throws IOException {
        this.doc = new PDDocument();
        this.page = new PDPage(size);
        this.doc.addPage(this.page);
        this.geoMapExtent = geographicMapExtent;
        this.projMapExtent = projectedMapExtent;
        PdfUtils pdfUtils = new PdfUtils();
        pdfUtils.generateViewPortArray(this.page, geographicMapExtent, crs);
    }

    public Envelope getGeographicMapExtent() {
        return this.geoMapExtent;
    }

    public Envelope getProjectedMapExtent() {
        return this.projMapExtent;
    }

    public boolean addLayer(AbstractLayer layer) {
        boolean success = false;
        if (!this.layerExists(layer.getName())) {
            this.layers.add(layer);
            success = true;
        }
        return success;
    }

    public void setBackgroundColor(Color backColor) {
        this.backColor = backColor;
    }

    private void renderLayers() throws IOException {
        this.contentStream = new PDPageContentStream(this.doc, this.page, true, false, true);
        this.doc.setDocumentInformation(this.docInfo);
        this.contentStream.saveGraphicsState();
        this.contentStream.setNonStrokingColor(this.backColor);
        this.contentStream.fillRect(0.0f, 0.0f, this.getPage().findMediaBox().getWidth(), this.getPage().findMediaBox().getHeight());
        this.contentStream.restoreGraphicsState();
        for (int i = 0; i < this.layers.size(); ++i) {
            AbstractLayer mapLayer = this.layers.get(i);
            String layerName = mapLayer.getName();
            COSName cosLayerName = COSName.getPDFName(layerName);
            PDDocumentCatalog catalog = this.doc.getDocumentCatalog();
            PDOptionalContentProperties ocprops = catalog.getOCProperties();
            if (ocprops == null) {
                ocprops = new PDOptionalContentProperties();
                catalog.setOCProperties(ocprops);
            }
            PDOptionalContentGroup layer = new PDOptionalContentGroup(layerName);
            ocprops.addGroup(layer);
            layer.setName(layerName);
            ocprops.setGroupEnabled(layerName, mapLayer.isVisible());
            PDResources resources = this.page.findResources();
            PDPropertyList props = resources.getProperties();
            if (props == null) {
                props = new PDPropertyList();
                resources.setProperties(props);
            }
            props.putMapping(cosLayerName, layer);
            this.contentStream.beginMarkedContentSequence(COSName.OC, cosLayerName);
            mapLayer.render(this.contentStream);
            this.contentStream.endMarkedContentSequence();
        }
        this.contentStream.close();
    }

    private boolean layerExists(String layerName) {
        boolean dup = false;
        for (int i = 0; i < this.layers.size(); ++i) {
            AbstractLayer layer = this.layers.get(i);
            if (!layer.getName().equalsIgnoreCase(layerName)) continue;
            dup = true;
            break;
        }
        return dup;
    }

    public void generate(OutputStream outputStream) throws IOException, COSVisitorException {
        this.renderLayers();
        this.doc.save(outputStream);
        this.doc.close();
    }

    public void generate(File file) throws IOException, COSVisitorException {
        this.renderLayers();
        this.doc.save(file);
        this.doc.close();
    }

    public void generate(String fileName) throws IOException, COSVisitorException {
        this.renderLayers();
        this.doc.save(fileName);
        this.doc.close();
    }

    public PDDocument getDocument() {
        return this.doc;
    }

    public PDPage getPage() {
        return this.page;
    }

    public void setAuthor(String author) {
        this.docInfo.setAuthor(author);
    }

    public void setCreationDate(Calendar date) {
        this.docInfo.setCreationDate(date);
    }

    public void setCreator(String creator) {
        this.docInfo.setCreator(creator);
    }

    public void setKeywords(String keyWords) {
        this.docInfo.setKeywords(keyWords);
    }

    public void setModificationDate(Calendar date) {
        this.docInfo.setModificationDate(date);
    }

    public void setProducer(String producer) {
        this.docInfo.setProducer(producer);
    }

    public void setSubject(String subject) {
        this.docInfo.setSubject(subject);
    }

    public void setTitle(String title) {
        this.docInfo.setTitle(title);
    }

    public ArrayList<String> getPointShapeNames() throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = shapeClassPath.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File directory : dirs) {
            classes.addAll(this.findClasses(directory, shapeClassPath));
        }
        return classes;
    }

    private List<String> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<String> classNames = new ArrayList<String>();
        if (!directory.exists()) {
            return classNames;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classNames.addAll(this.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classNames.add(file.getName().substring(0, file.getName().length() - 6));
        }
        return classNames;
    }
}

